/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.ObjectVector;
import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.ArchiveDatabaseEx;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.Archive.SevenZip.Decoder;
import SevenZip.Archive.SevenZip.ExtractFolderInfo;
import SevenZip.Archive.SevenZip.FileItem;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.FolderOutStream;
import SevenZip.Archive.SevenZip.InArchive;
import SevenZip.Archive.SevenZip.MethodID;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.Common.LocalCompressProgressInfo;
import SevenZip.Common.LocalProgress;
import SevenZip.IInStream;
import java.io.IOException;

public class Handler
implements IInArchive {
    IInStream _inStream;
    ArchiveDatabaseEx _database = new ArchiveDatabaseEx();
    int _numThreads = 1;

    @Override
    public int Open(IInStream iInStream) throws IOException {
        return this.Open(iInStream, 0x400000L);
    }

    @Override
    public int Open(IInStream iInStream, long l) throws IOException {
        this.close();
        InArchive inArchive = new InArchive();
        int n = inArchive.Open(iInStream, l);
        if (n != 0) {
            return n;
        }
        n = inArchive.ReadDatabase(this._database);
        if (n != 0) {
            return n;
        }
        this._database.Fill();
        this._inStream = iInStream;
        return 0;
    }

    @Override
    public int Extract(int[] nArray, int n, int n2, IArchiveExtractCallback iArchiveExtractCallback) throws IOException {
        int n3;
        boolean bl;
        boolean bl2 = n2 != 0;
        IArchiveExtractCallback iArchiveExtractCallback2 = iArchiveExtractCallback;
        long l = 0L;
        boolean bl3 = bl = n == -1;
        if (bl) {
            n = this._database.Files.size();
        }
        if (n == 0) {
            return 0;
        }
        ObjectVector<ExtractFolderInfo> objectVector = new ObjectVector<ExtractFolderInfo>();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n4 = bl ? i : nArray[i];
            ArchiveDatabaseEx archiveDatabaseEx = this._database;
            int n5 = n4;
            int n6 = archiveDatabaseEx.FileIndexToFolderIndexMap.get(n5);
            if (n6 == -1) {
                objectVector.add(new ExtractFolderInfo(n5, -1));
                continue;
            }
            if (objectVector.isEmpty() || n6 != ((ExtractFolderInfo)objectVector.Back()).FolderIndex) {
                objectVector.add(new ExtractFolderInfo(-1, n6));
                object = (Folder)archiveDatabaseEx.Folders.get(n6);
                long l2 = ((Folder)object).GetUnPackSize();
                l += l2;
                ((ExtractFolderInfo)objectVector.Back()).UnPackSize = l2;
            }
            object = (ExtractFolderInfo)objectVector.Back();
            int n7 = archiveDatabaseEx.FolderStartFileIndex.get(n6);
            for (n3 = ((ExtractFolderInfo)object).ExtractStatuses.size(); n3 <= n5 - n7; ++n3) {
                ((ExtractFolderInfo)object).ExtractStatuses.add(n3 == n5 - n7);
            }
        }
        iArchiveExtractCallback2.SetTotal(l);
        Decoder decoder = new Decoder(false);
        long l3 = 0L;
        int n8 = 0;
        while (n8 < objectVector.size()) {
            long l4;
            block20: {
                FolderOutStream folderOutStream;
                ExtractFolderInfo extractFolderInfo = (ExtractFolderInfo)objectVector.get(n8);
                l4 = extractFolderInfo.UnPackSize;
                n3 = iArchiveExtractCallback2.SetCompleted(l3);
                if (n3 != 0) {
                    return n3;
                }
                FolderOutStream folderOutStream2 = folderOutStream = new FolderOutStream();
                ArchiveDatabaseEx archiveDatabaseEx = this._database;
                int n9 = extractFolderInfo.FileIndex != -1 ? extractFolderInfo.FileIndex : archiveDatabaseEx.FolderStartFileIndex.get(extractFolderInfo.FolderIndex);
                int n10 = folderOutStream.Init(archiveDatabaseEx, 0, n9, extractFolderInfo.ExtractStatuses, iArchiveExtractCallback2, bl2);
                if (n10 != 0) {
                    return n10;
                }
                if (extractFolderInfo.FileIndex == -1) {
                    LocalCompressProgressInfo localCompressProgressInfo;
                    LocalProgress localProgress;
                    int n11 = extractFolderInfo.FolderIndex;
                    Folder folder = (Folder)archiveDatabaseEx.Folders.get(n11);
                    LocalProgress localProgress2 = localProgress = new LocalProgress();
                    localProgress.Init(iArchiveExtractCallback2, false);
                    LocalCompressProgressInfo localCompressProgressInfo2 = localCompressProgressInfo = new LocalCompressProgressInfo();
                    localCompressProgressInfo.Init(localProgress2, -1L, l3);
                    int n12 = archiveDatabaseEx.FolderStartPackStreamIndex.get(n11);
                    long l5 = archiveDatabaseEx.GetFolderStreamPos(n11, 0);
                    try {
                        n10 = decoder.Decode(this._inStream, l5, archiveDatabaseEx.PackSizes, n12, folder, folderOutStream2, localCompressProgressInfo2);
                        if (n10 == 1) {
                            n10 = folderOutStream.FlushCorrupted(2);
                            if (n10 != 0) {
                                return n10;
                            }
                        } else if (n10 == -2147467263) {
                            n10 = folderOutStream.FlushCorrupted(1);
                            if (n10 != 0) {
                                return n10;
                            }
                        } else {
                            if (n10 != 0) {
                                return n10;
                            }
                            if (folderOutStream.WasWritingFinished() != 0 && (n10 = folderOutStream.FlushCorrupted(2)) != 0) {
                                return n10;
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("IOException : " + exception);
                        exception.printStackTrace();
                        n10 = folderOutStream.FlushCorrupted(2);
                        if (n10 == 0) break block20;
                        return n10;
                    }
                }
            }
            ++n8;
            l3 += l4;
        }
        return 0;
    }

    @Override
    public int close() throws IOException {
        if (this._inStream != null) {
            this._inStream.close();
        }
        this._inStream = null;
        this._database.Clear();
        return 0;
    }

    @Override
    public int size() {
        return this._database.Files.size();
    }

    long getPackSize(int n) {
        long l = 0L;
        int n2 = this._database.FileIndexToFolderIndexMap.get(n);
        if (n2 != -1 && this._database.FolderStartFileIndex.get(n2) == n) {
            l = this._database.GetFolderFullPackSize(n2);
        }
        return l;
    }

    static int GetUInt32FromMemLE(byte[] byArray, int n) {
        return byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24;
    }

    static String GetStringForSizeValue(int n) {
        for (int i = 31; i >= 0; --i) {
            if (1 << i != n) continue;
            return "" + i;
        }
        String string = "";
        if (n % 0x100000 == 0) {
            string = string + "" + (n >> 20);
            string = string + "m";
        } else if (n % 1024 == 0) {
            string = string + "" + (n >> 10);
            string = string + "k";
        } else {
            string = string + "" + n;
            string = string + "b";
        }
        return string;
    }

    String getMethods(int n) {
        String string = "";
        int n2 = this._database.FileIndexToFolderIndexMap.get(n);
        if (n2 != -1) {
            Folder folder = (Folder)this._database.Folders.get(n2);
            String string2 = "";
            for (int i = folder.Coders.size() - 1; i >= 0; --i) {
                CoderInfo coderInfo = (CoderInfo)folder.Coders.get(i);
                if (string2 != "") {
                    string2 = string2 + ' ';
                }
                for (int j = 0; j < coderInfo.AltCoders.size(); ++j) {
                    if (j > 0) {
                        string2 = string2 + "|";
                    }
                    AltCoderInfo altCoderInfo = (AltCoderInfo)coderInfo.AltCoders.get(j);
                    String string3 = "";
                    boolean bl = true;
                    if (altCoderInfo.MethodID.equals(MethodID.k_Copy)) {
                        string3 = "Copy";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_LZMA)) {
                        string3 = "LZMA";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_BCJ)) {
                        string3 = "BCJ";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_BCJ2)) {
                        string3 = "BCJ2";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_PPMD)) {
                        string3 = "PPMD";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_Deflate)) {
                        string3 = "Deflate";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_Deflate64)) {
                        string3 = "Deflate64";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_BZip2)) {
                        string3 = "BZip2";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_7zAES)) {
                        string3 = "7zAES";
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    string2 = string2 + string3;
                    if (!altCoderInfo.MethodID.equals(MethodID.k_LZMA) || altCoderInfo.Properties.GetCapacity() < 5) continue;
                    string2 = string2 + ":";
                    int n3 = Handler.GetUInt32FromMemLE(altCoderInfo.Properties.data(), 1);
                    string2 = string2 + Handler.GetStringForSizeValue(n3);
                }
            }
            string = string2;
        }
        return string;
    }

    @Override
    public SevenZipEntry getEntry(int n) {
        FileItem fileItem = (FileItem)this._database.Files.get(n);
        int n2 = n;
        long l = -1L;
        if (fileItem.IsFileCRCDefined) {
            l = (long)fileItem.FileCRC & 0xFFFFFFFFL;
        }
        long l2 = -1L;
        if (fileItem.IsStartPosDefined) {
            l2 = fileItem.StartPos;
        }
        SevenZipEntry sevenZipEntry = new SevenZipEntry(fileItem.name, this.getPackSize(n2), fileItem.UnPackSize, l, fileItem.LastWriteTime, l2, fileItem.IsDirectory, fileItem.Attributes, this.getMethods(n2));
        return sevenZipEntry;
    }
}

