/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive;

public class SevenZipEntry {
    long LastWriteTime;
    long UnPackSize;
    long PackSize;
    int Attributes;
    long FileCRC;
    boolean IsDirectory;
    String Name;
    String Methods;
    long Position;
    static final String kEmptyAttributeChar = ".";
    static final String kDirectoryAttributeChar = "D";
    static final String kReadonlyAttributeChar = "R";
    static final String kHiddenAttributeChar = "H";
    static final String kSystemAttributeChar = "S";
    static final String kArchiveAttributeChar = "A";
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;

    public SevenZipEntry(String string, long l, long l2, long l3, long l4, long l5, boolean bl, int n, String string2) {
        this.Name = string;
        this.PackSize = l;
        this.UnPackSize = l2;
        this.FileCRC = l3;
        this.LastWriteTime = l4;
        this.Position = l5;
        this.IsDirectory = bl;
        this.Attributes = n;
        this.Methods = string2;
    }

    public long getCompressedSize() {
        return this.PackSize;
    }

    public long getSize() {
        return this.UnPackSize;
    }

    public long getCrc() {
        return this.FileCRC;
    }

    public String getName() {
        return this.Name;
    }

    public long getTime() {
        return this.LastWriteTime;
    }

    public long getPosition() {
        return this.Position;
    }

    public boolean isDirectory() {
        return this.IsDirectory;
    }

    public String getAttributesString() {
        String string = "";
        string = string + ((this.Attributes & 0x10) != 0 || this.IsDirectory ? kDirectoryAttributeChar : kEmptyAttributeChar);
        string = string + ((this.Attributes & 1) != 0 ? kReadonlyAttributeChar : kEmptyAttributeChar);
        string = string + ((this.Attributes & 2) != 0 ? kHiddenAttributeChar : kEmptyAttributeChar);
        string = string + ((this.Attributes & 4) != 0 ? kSystemAttributeChar : kEmptyAttributeChar);
        string = string + ((this.Attributes & 0x20) != 0 ? kArchiveAttributeChar : kEmptyAttributeChar);
        return string;
    }

    public String getMethods() {
        return this.Methods;
    }
}

