/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public final class Element
extends Segment {
    private final StartTag startTag;
    private final EndTag endTag;
    private Segment content = null;
    Element parentElement = NOT_CACHED;
    private int depth = -1;
    private List<Element> childElements = null;
    static final Element NOT_CACHED = new Element();
    private static final boolean INCLUDE_INCORRECTLY_NESTED_CHILDREN_IN_HIERARCHY = true;

    Element(Source source, StartTag startTag, EndTag endTag) {
        super(source, startTag.begin, endTag == null ? startTag.end : endTag.end);
        if (source.isStreamed()) {
            throw new UnsupportedOperationException("Elements are not supported when using StreamedSource");
        }
        this.startTag = startTag;
        this.endTag = endTag == null || endTag.length() == 0 ? null : endTag;
    }

    private Element() {
        this.startTag = null;
        this.endTag = null;
    }

    public Element getParentElement() {
        if (this.parentElement == NOT_CACHED) {
            if (!this.source.wasFullSequentialParseCalled()) {
                throw new IllegalStateException("This operation is only possible after a full sequential parse has been performed");
            }
            if (this.startTag.isOrphaned()) {
                throw new IllegalStateException("This operation is only possible if a full sequential parse was performed immediately after construction of the Source object");
            }
            this.source.getChildElements();
            if (this.parentElement == NOT_CACHED) {
                this.parentElement = null;
            }
        }
        return this.parentElement;
    }

    @Override
    public final List<Element> getChildElements() {
        return this.childElements != null ? this.childElements : this.getChildElements(-1);
    }

    final List<Element> getChildElements(int depth) {
        if (depth != -1) {
            this.depth = depth;
        }
        if (this.childElements == null) {
            if (this.end == this.startTag.end) {
                this.childElements = Collections.emptyList();
            } else {
                StartTag childStartTag;
                int maxChildBegin;
                int childDepth = depth == -1 ? -1 : depth + 1;
                this.childElements = new ArrayList<Element>();
                int pos = this.startTag.end;
                int n = maxChildBegin = this.endTag == null ? this.end : this.endTag.begin;
                while ((childStartTag = this.source.getNextStartTag(pos)) != null && childStartTag.begin < maxChildBegin) {
                    if (childStartTag.getTagType().isServerTag()) {
                        pos = childStartTag.end;
                        continue;
                    }
                    Element childElement = childStartTag.getElement();
                    if (childElement.end > this.end && this.source.logger.isErrorEnabled()) {
                        this.source.logger.error("Child " + childElement.getDebugInfo() + " extends beyond end of parent " + this.getDebugInfo());
                    }
                    childElement.getChildElements(childDepth);
                    if (childElement.parentElement == NOT_CACHED) {
                        childElement.parentElement = this;
                        this.childElements.add(childElement);
                    }
                    pos = childElement.end;
                }
            }
        }
        return this.childElements;
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.getParentElement();
            if (this.depth == -1) {
                this.depth = 0;
            }
        }
        return this.depth;
    }

    public Segment getContent() {
        if (this.content == null) {
            this.content = new Segment(this.source, this.startTag.end, this.getContentEnd());
        }
        return this.content;
    }

    public StartTag getStartTag() {
        return this.startTag;
    }

    public EndTag getEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.startTag.getName();
    }

    @Override
    public boolean isEmpty() {
        return this.startTag.end == this.getContentEnd();
    }

    public boolean isEmptyElementTag() {
        return this.startTag.isEmptyElementTag();
    }

    public Attributes getAttributes() {
        return this.getStartTag().getAttributes();
    }

    public String getAttributeValue(String attributeName) {
        return this.getStartTag().getAttributeValue(attributeName);
    }

    public FormControl getFormControl() {
        return FormControl.construct(this);
    }

    @Override
    public String getDebugInfo() {
        if (this == NOT_CACHED) {
            return "NOT_CACHED";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Element ");
        this.startTag.appendDebugTag(sb);
        if (!this.isEmpty()) {
            sb.append('-');
        }
        if (this.endTag != null) {
            sb.append(this.endTag);
        }
        sb.append(' ');
        this.startTag.appendDebugTagType(sb);
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    int getContentEnd() {
        return this.endTag != null ? this.endTag.begin : this.end;
    }
}

