/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.standardization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nlpcn.commons.lang.standardization.Element;
import org.nlpcn.commons.lang.util.WordAlert;

public class WordUtil {
    private Character num2Value;
    private Character en2Value;

    public WordUtil(Character num2Value, Character enValue) {
        this.num2Value = num2Value;
        this.en2Value = enValue;
    }

    public List<Element> str2Elements(String str) {
        if (str == null || str.trim().length() == 0) {
            return Collections.emptyList();
        }
        char[] chars = WordAlert.alertStr(str);
        int maxLen = chars.length - 1;
        ArrayList<Element> list = new ArrayList<Element>();
        Element element = null;
        block0: for (int i = 0; i < chars.length; ++i) {
            char c;
            if (this.num2Value != null && chars[i] >= '0' && chars[i] <= '9') {
                element = new Element(this.num2Value.charValue());
                list.add(element);
                if (i == maxLen) break;
                c = chars[++i];
                while (c == '.' || c == '%' || c >= '0' && c <= '9') {
                    if (i == maxLen) break block0;
                    c = chars[++i];
                    element.len();
                }
                --i;
                continue;
            }
            if (this.en2Value != null && chars[i] >= 'a' && chars[i] <= 'z') {
                element = new Element(this.en2Value.charValue());
                list.add(element);
                if (i == maxLen) break;
                c = chars[++i];
                while (c >= 'a' && c <= 'z') {
                    if (i == maxLen) break block0;
                    c = chars[++i];
                    element.len();
                }
                --i;
                continue;
            }
            list.add(new Element(chars[i]));
        }
        return list;
    }

    public String str2Str(String str) {
        return new String(this.str2Chars(str));
    }

    public char[] str2Chars(String str) {
        List<Element> elements = this.str2Elements(str);
        char[] chars = new char[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            chars[i] = elements.get((int)i).name;
        }
        return chars;
    }

    public static void main(String[] args) {
        WordUtil wordUtil = new WordUtil(Character.valueOf('1'), Character.valueOf('A'));
        System.out.println(wordUtil.str2Elements("123\u4e2d\u56fdCHINA456\u4f60\u597d!"));
        System.out.println(Arrays.toString(wordUtil.str2Chars("123\u4e2d\u56fdCHINA456\u4f60\u597d!")));
        System.out.println(wordUtil.str2Str("123\u4e2d\u56fdCHINA456\u4f60\u597d!"));
    }
}

