/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapCount<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<T, Double> hm = null;

    public MapCount() {
        this.hm = new HashMap();
    }

    public MapCount(HashMap<T, Double> hm) {
        this.hm = hm;
    }

    public MapCount(int initialCapacity) {
        this.hm = new HashMap(initialCapacity);
    }

    public void add(T t, double n) {
        Double value = null;
        value = this.hm.get(t);
        if (value != null) {
            this.hm.put(t, value + n);
        } else {
            this.hm.put(t, n);
        }
    }

    public void add(T t, int n) {
        this.add(t, (double)n);
    }

    public void add(T t) {
        this.add(t, 1);
    }

    public int size() {
        return this.hm.size();
    }

    public void remove(T t) {
        this.hm.remove(t);
    }

    public HashMap<T, Double> get() {
        return this.hm;
    }

    public String getDic() {
        Iterator<Map.Entry<T, Double>> iterator = this.hm.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        Map.Entry<T, Double> next = null;
        while (iterator.hasNext()) {
            next = iterator.next();
            sb.append(next.getKey());
            sb.append("\t");
            sb.append(next.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void addAll(Collection<T> collection) {
        for (T t : collection) {
            this.add(t);
        }
    }

    public void addAll(Collection<T> collection, double weight) {
        for (T t : collection) {
            this.add(t, weight);
        }
    }

    public void addAll(Map<T, Double> map) {
        for (Map.Entry<T, Double> e : map.entrySet()) {
            this.add(e.getKey(), e.getValue());
        }
    }
}

