/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

public class WordAlert {
    public static final int MIN_LOWER = 65345;
    public static final int MAX_LOWER = 65370;
    public static final int LOWER_GAP = 65248;
    public static final int MIN_UPPER = 65313;
    public static final int MAX_UPPER = 65338;
    public static final int UPPER_GAP = 65216;
    public static final int MIN_UPPER_E = 65;
    public static final int MAX_UPPER_E = 90;
    public static final int UPPER_GAP_E = -32;
    public static final int MIN_UPPER_N = 65296;
    public static final int MAX_UPPER_N = 65305;
    public static final int UPPER_GAP_N = 65248;
    private static final char[] CHARCOVER = new char[65536];

    public static String alertEnglish(char[] chars, int start, int end) {
        char[] result = new char[end];
        char c = '\u0000';
        for (int i = start; i < start + end; ++i) {
            c = chars[i];
            result[i - start] = c >= '\uff41' && c <= '\uff5a' ? (char)(chars[i] - 65248) : (c >= '\uff21' && c <= '\uff3a' ? (char)(c - 65216) : (c >= 'A' && c <= 'Z' ? (char)(c - -32) : c));
        }
        return new String(result);
    }

    public static String alertEnglish(String temp, int start, int end) {
        char c = '\u0000';
        char[] result = new char[end];
        for (int i = start; i < start + end; ++i) {
            c = temp.charAt(i);
            result[i - start] = c >= '\uff41' && c <= '\uff5a' ? (char)(c - 65248) : (c >= '\uff21' && c <= '\uff3a' ? (char)(c - 65216) : (c >= 'A' && c <= 'Z' ? (char)(c - -32) : c));
        }
        return new String(result);
    }

    public static String alertNumber(char[] chars, int start, int end) {
        char[] result = new char[end];
        char c = '\u0000';
        for (int i = start; i < start + end; ++i) {
            c = chars[i];
            result[i - start] = c >= '\uff10' && c <= '\uff19' ? (char)(c - 65248) : c;
        }
        return new String(result);
    }

    public static String alertNumber(String temp, int start, int end) {
        char[] result = new char[end];
        char c = '\u0000';
        for (int i = start; i < start + end; ++i) {
            c = temp.charAt(i);
            result[i - start] = c >= '\uff10' && c <= '\uff19' ? (char)(c - 65248) : c;
        }
        return new String(result);
    }

    public static char[] alertStr(String str) {
        char[] chars = new char[str.length()];
        boolean c = false;
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = CHARCOVER[str.charAt(i)];
        }
        return chars;
    }

    public static boolean isEnglish(String word) {
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            char c = word.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '\uff41' && c <= '\uff5a' || c >= '\uff21' && c <= '\uff3a' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isEnglish(char c) {
        return c >= 'a' && c <= 'z' || c >= '\uff41' && c <= '\uff5a' || c >= '\uff21' && c <= '\uff3a' || c >= 'A' && c <= 'Z';
    }

    public static boolean isNumber(String word) {
        char c = '\u0000';
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            c = word.charAt(i);
            if (c >= '0' && c <= '9' || c >= '\uff10' && c <= '\uff19' || c == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c >= '\uff10' && c <= '\uff19';
    }

    public static char CharCover(char c) {
        return CHARCOVER[c];
    }

    static {
        for (int i = 0; i < CHARCOVER.length; ++i) {
            WordAlert.CHARCOVER[i] = i >= 65345 && i <= 65370 ? (char)(i - 65248) : (i >= 65313 && i <= 65338 ? (char)(i - 65216) : (i >= 65 && i <= 90 ? (char)(i - -32) : (i >= 65296 && i <= 65305 ? (char)(i - 65248) : (char)i)));
        }
    }
}

