/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ansj.dic.PathToStream;
import org.ansj.domain.KV;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.Value;
import org.nlpcn.commons.lang.tire.library.Library;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.logging.Log;

public class AmbiguityLibrary {
    private static final Log LOG = MyStaticValue.getLog(AmbiguityLibrary.class);
    private static final Map<String, KV<String, Forest>> AMBIGUITY = new HashMap<String, KV<String, Forest>>();
    public static final String DEFAULT = "ambiguity";

    public static Forest get() {
        if (!AMBIGUITY.containsKey(DEFAULT)) {
            return null;
        }
        return AmbiguityLibrary.get(DEFAULT);
    }

    public static Forest get(String key) {
        KV<String, Forest> kv = AMBIGUITY.get(key);
        if (kv == null) {
            if (MyStaticValue.ENV.containsKey(key)) {
                AmbiguityLibrary.putIfAbsent(key, MyStaticValue.ENV.get(key));
                return AmbiguityLibrary.get(key);
            }
            LOG.warn("crf " + key + " not found in config ");
            return null;
        }
        Forest sw = kv.getV();
        if (sw == null) {
            try {
                sw = AmbiguityLibrary.init(key, kv);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sw;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized Forest init(String key, KV<String, Forest> kv) {
        Forest forest2 = kv.getV();
        if (forest2 != null) {
            return forest2;
        }
        forest2 = new Forest();
        try {
            BufferedReader br = IOUtil.getReader((InputStream)PathToStream.stream(kv.getK()), (String)"utf-8");
            Throwable throwable = null;
            try {
                String temp;
                LOG.debug("begin init ambiguity");
                long start = System.currentTimeMillis();
                while ((temp = br.readLine()) != null) {
                    if (!StringUtil.isNotBlank((CharSequence)temp)) continue;
                    temp = StringUtil.trim((String)temp);
                    String[] split = temp.split("\t");
                    StringBuilder sb = new StringBuilder();
                    if (split.length % 2 != 0) {
                        LOG.error("init ambiguity  error in line :" + temp + " format err !");
                        continue;
                    }
                    for (int i = 0; i < split.length; i += 2) {
                        sb.append(split[i]);
                    }
                    forest2.addBranch(sb.toString(), (Object)split);
                }
                LOG.info("load dic use time:" + (System.currentTimeMillis() - start) + " path is : " + kv.getK());
                kv.setV(forest2);
                Forest forest = forest2;
                return forest;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Init ambiguity library error :" + e.getMessage() + ", path: " + kv.getK());
            AMBIGUITY.remove(key);
            return null;
        }
    }

    public static void insert(String key, String ... split) {
        Forest forest = AmbiguityLibrary.get(key);
        StringBuilder sb = new StringBuilder();
        if (split.length % 2 != 0) {
            LOG.error("init ambiguity  error in line :" + Arrays.toString(split) + " format err !");
            return;
        }
        for (int i = 0; i < split.length; i += 2) {
            sb.append(split[i]);
        }
        forest.addBranch(sb.toString(), (Object)split);
    }

    public static void insert(String key, Value value) {
        Forest forest = AmbiguityLibrary.get(key);
        Library.insertWord((Forest)forest, (Value)value);
    }

    public static void put(String key, String path) {
        AmbiguityLibrary.put(key, path, null);
    }

    public static void put(String key, String path, Forest value) {
        AMBIGUITY.put(key, KV.with(path, value));
    }

    public static KV<String, Forest> remove(String key) {
        return AMBIGUITY.remove(key);
    }

    public static void reload(String key) {
        KV<String, Forest> kv = AMBIGUITY.get(key);
        if (kv != null) {
            AMBIGUITY.get(key).setV(null);
        }
    }

    public static Set<String> keys() {
        return AMBIGUITY.keySet();
    }

    public static void putIfAbsent(String key, String path) {
        if (!AMBIGUITY.containsKey(key)) {
            AMBIGUITY.put(key, KV.with(path, null));
        }
    }

    static {
        for (Map.Entry<String, String> entry : MyStaticValue.ENV.entrySet()) {
            if (!entry.getKey().startsWith(DEFAULT)) continue;
            AmbiguityLibrary.put(entry.getKey(), entry.getValue());
        }
        AmbiguityLibrary.putIfAbsent(DEFAULT, "library/ambiguity.dic");
    }
}

