/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.Reader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.recognition.arrimpl.AsianPersonRecognition;
import org.ansj.recognition.arrimpl.ForeignPersonRecognition;
import org.ansj.recognition.arrimpl.NumRecognition;
import org.ansj.recognition.arrimpl.UserDefineRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.AnsjReader;
import org.ansj.util.Graph;
import org.ansj.util.NameFix;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.GetWord;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.util.ObjConver;

public class IndexAnalysis
extends Analysis {
    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                graph.walkPath();
                if (IndexAnalysis.this.isNumRecognition.booleanValue() && graph.hasNum) {
                    new NumRecognition().recognition(graph.terms);
                }
                if (graph.hasPerson && IndexAnalysis.this.isNameRecognition.booleanValue()) {
                    new AsianPersonRecognition().recognition(graph.terms);
                    graph.walkPathByScore();
                    NameFix.nameAmbiguity(graph.terms, new Forest[0]);
                    new ForeignPersonRecognition().recognition(graph.terms);
                    graph.walkPathByScore();
                }
                this.userDefineRecognition(graph, IndexAnalysis.this.forests);
                return this.result();
            }

            private void userDefineRecognition(Graph graph2, Forest ... forests) {
                new UserDefineRecognition(TermUtil.InsertTermType.SKIP, forests).recognition(graph2.terms);
                graph2.rmLittlePath();
                graph2.walkPathByScore();
            }

            private List<Term> result() {
                String temp = null;
                HashSet<String> set = new HashSet<String>();
                LinkedList<Term> result = new LinkedList<Term>();
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    if (graph.terms[i] == null) continue;
                    result.add(graph.terms[i]);
                    set.add(graph.terms[i].getName() + graph.terms[i].getOffe());
                }
                LinkedList<Term> last = new LinkedList<Term>();
                char[] chars = graph.chars;
                if (IndexAnalysis.this.forests != null) {
                    for (Forest forest : IndexAnalysis.this.forests) {
                        if (forest == null) continue;
                        GetWord word = forest.getWord(chars);
                        while ((temp = word.getAllWords()) != null) {
                            if (set.contains(temp + word.offe)) continue;
                            set.add(temp + word.offe);
                            last.add(new Term(temp, word.offe, word.getParam(0), ObjConver.getIntValue((String)word.getParam(1))));
                        }
                    }
                }
                result.addAll(last);
                Collections.sort(result, new Comparator<Term>(){

                    @Override
                    public int compare(Term o1, Term o2) {
                        if (o1.getOffe() == o2.getOffe()) {
                            return o2.getName().length() - o1.getName().length();
                        }
                        return o1.getOffe() - o2.getOffe();
                    }
                });
                IndexAnalysis.this.setRealName(graph, result);
                return result;
            }
        };
        return merger.merger();
    }

    public IndexAnalysis() {
    }

    public IndexAnalysis(Reader reader) {
        super.resetContent(new AnsjReader(reader));
    }

    public static Result parse(String str) {
        return new IndexAnalysis().parseStr(str);
    }

    public static Result parse(String str, Forest ... forests) {
        return new IndexAnalysis().setForests(forests).parseStr(str);
    }
}

