/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.lucene.util;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.recognition.Recognition;
import org.ansj.recognition.impl.StopRecognition;
import org.ansj.recognition.impl.SynonymsRecgnition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.AnsjReader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public final class AnsjTokenizer
extends Tokenizer {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute positionAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    protected Analysis ta = null;
    private LinkedList<Object> result;
    private List<StopRecognition> stops;
    private List<SynonymsRecgnition> synonyms;

    public AnsjTokenizer(Analysis ta, List<StopRecognition> stops, List<SynonymsRecgnition> synonyms) {
        this.ta = ta;
        this.stops = stops;
        this.synonyms = synonyms;
    }

    public final boolean incrementToken() throws IOException {
        Object obj;
        int position = 0;
        if (this.result == null) {
            this.parse();
        }
        if ((obj = this.result.pollFirst()) == null) {
            this.result = null;
            return false;
        }
        if (obj instanceof Term) {
            this.clearAttributes();
            Term term = (Term)obj;
            while (this.filterTerm(term)) {
                term = (Term)this.result.pollFirst();
                if (term == null) {
                    this.result = null;
                    return false;
                }
                ++position;
            }
            List synonyms = term.getSynonyms();
            String rName = null;
            if (synonyms != null) {
                for (int i = 1; i < synonyms.size(); ++i) {
                    this.result.addFirst(synonyms.get(i));
                }
                rName = (String)synonyms.get(0);
            } else {
                rName = term.getName();
            }
            this.offsetAtt.setOffset(term.getOffe(), term.getOffe() + term.getName().length());
            this.typeAtt.setType(term.getNatureStr());
            this.positionAttr.setPositionIncrement(++position);
            this.termAtt.setEmpty().append(rName);
        } else {
            this.positionAttr.setPositionIncrement(position);
            this.termAtt.setEmpty().append(obj.toString());
        }
        return true;
    }

    private boolean filterTerm(Term term) {
        if (this.stops != null && this.stops.size() > 0) {
            for (StopRecognition filterRecognition : this.stops) {
                if (!filterRecognition.filter(term)) continue;
                return true;
            }
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.ta.resetContent(new AnsjReader(this.input));
        this.parse();
    }

    private void parse() throws IOException {
        Result parse = this.ta.parse();
        if (this.synonyms != null) {
            for (SynonymsRecgnition sr : this.synonyms) {
                parse.recognition((Recognition)sr);
            }
        }
        this.result = new LinkedList(parse.getTerms());
    }
}

