/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagTypeNormal;
import net.htmlparser.jericho.EndTagTypeUnregistered;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.TagType;

public abstract class EndTagType
extends TagType {
    static final String START_DELIMITER_PREFIX = "</";
    public static final EndTagType UNREGISTERED = EndTagTypeUnregistered.INSTANCE;
    public static final EndTagType NORMAL = EndTagTypeNormal.INSTANCE;

    protected EndTagType(String description, String startDelimiter, String closingDelimiter, boolean isServerTag) {
        super(description, startDelimiter.toLowerCase(), closingDelimiter, isServerTag, START_DELIMITER_PREFIX);
        if (!this.getStartDelimiter().startsWith(START_DELIMITER_PREFIX)) {
            throw new IllegalArgumentException("startDelimiter of an end tag must start with \"</\"");
        }
    }

    public StartTagType getCorrespondingStartTagType() {
        return null;
    }

    public String getEndTagName(String startTagName) {
        return startTagName;
    }

    public String generateHTML(String startTagName) {
        return START_DELIMITER_PREFIX + this.getEndTagName(startTagName) + this.getClosingDelimiter();
    }

    protected final EndTag constructEndTag(Source source, int begin, int end, String name) {
        return new EndTag(source, begin, end, this, name);
    }
}

