/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.LinkedList;
import java.util.Queue;
import net.htmlparser.jericho.Logger;

class LoggerQueue
implements Logger {
    private static final String ERROR = "ERROR";
    private static final String WARN = "WARN";
    private static final String INFO = "INFO";
    private static final String DEBUG = "DEBUG";
    private final Queue<String[]> queue = new LinkedList<String[]>();

    LoggerQueue() {
    }

    @Override
    public void error(String message) {
        this.queue.add(new String[]{ERROR, message});
    }

    @Override
    public void warn(String message) {
        this.queue.add(new String[]{WARN, message});
    }

    @Override
    public void info(String message) {
        this.queue.add(new String[]{INFO, message});
    }

    @Override
    public void debug(String message) {
        this.queue.add(new String[]{DEBUG, message});
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    public void setErrorEnabled(boolean errorEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    public void setWarnEnabled(boolean warnEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    public void setInfoEnabled(boolean infoEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        throw new UnsupportedOperationException();
    }

    public void outputTo(Logger logger) {
        String[] item;
        while ((item = this.queue.poll()) != null) {
            String level = item[0];
            String message = item[1];
            if (level == ERROR) {
                logger.error(message);
                continue;
            }
            if (level == WARN) {
                logger.warn(message);
                continue;
            }
            if (level == INFO) {
                logger.info(message);
                continue;
            }
            if (level != DEBUG) continue;
            logger.debug(message);
        }
        return;
    }
}

