/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.OutputSegment;
import net.htmlparser.jericho.Segment;

final class StringOutputSegment
implements OutputSegment {
    private final int begin;
    private final int end;
    private final CharSequence text;

    public StringOutputSegment(int begin, int end, CharSequence text) {
        this.begin = begin;
        this.end = end;
        this.text = text == null ? "" : text;
    }

    public StringOutputSegment(Segment segment, CharSequence text) {
        this(segment.begin, segment.end, text);
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        appendable.append(this.text);
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.text.length();
    }

    @Override
    public String toString() {
        return this.text.toString();
    }

    @Override
    public String getDebugInfo() {
        return "Replace: (p" + this.begin + "-p" + this.end + ") " + this.text;
    }

    public void output(Writer writer) throws IOException {
        this.writeTo(writer);
    }
}

