/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.enums;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.util.ConfLoader;
import net.sourceforge.docfetcher.util.Util;

public class MsgWriter {
    public static void main(String[] stringArray) throws IOException {
        File file = new File("build/Resource.properties");
        MsgWriter.writeTo(file);
        Util.println("File written: " + file.getAbsolutePath());
    }

    public static void writeTo(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Msg msg : Msg.values()) {
            String string = ConfLoader.convert(msg.name(), true);
            String string2 = MsgWriter.convert(msg.get(), false);
            String string3 = msg.getComment();
            if (!string3.isEmpty()) {
                stringBuilder.append("# " + string3 + Util.LS);
            }
            stringBuilder.append(string + "=" + string2);
            stringBuilder.append(Util.LS);
        }
        Files.write((CharSequence)stringBuilder.toString(), (File)file, (Charset)Charsets.UTF_8);
    }

    private static String convert(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(' ');
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '#': 
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

