/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.enums;

import com.google.common.primitives.Ints;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.util.ConfLoader;
import net.sourceforge.docfetcher.util.Util;

public final class ProgramConf {
    private ProgramConf() {
    }

    public static enum StrList implements ConfLoader.Storable
    {
        HtmlExtensions("html", "htm", "xhtml", "shtml", "shtm");

        private List<String> value;

        private StrList(String ... stringArray) {
            this.value = Arrays.asList(stringArray);
        }

        public List<String> get() {
            return Collections.unmodifiableList(this.value);
        }

        @Override
        public void load(String string) {
            this.value = Util.decodeStrings(';', string);
        }

        @Override
        public String valueToString() {
            return Util.encodeStrings(";", this.value);
        }
    }

    public static final class IntArray
    extends Enum<IntArray>
    implements ConfLoader.Storable {
        private int[] value;
        private static final /* synthetic */ IntArray[] $VALUES;

        public static IntArray[] values() {
            return (IntArray[])$VALUES.clone();
        }

        public static IntArray valueOf(String string) {
            return Enum.valueOf(IntArray.class, string);
        }

        private IntArray(int ... nArray) {
            this.value = nArray;
        }

        public int[] get() {
            return this.value;
        }

        @Override
        public void load(String string) {
            this.value = Util.toIntArray(string, this.value);
        }

        @Override
        public String valueToString() {
            return Ints.join((String)", ", (int[])this.value);
        }

        private static /* synthetic */ IntArray[] $values() {
            return new IntArray[0];
        }

        static {
            $VALUES = IntArray.$values();
        }
    }

    public static enum Str implements ConfLoader.Storable
    {
        AppName("DocFetcher"),
        TextEncodingOverride("");

        private String value;

        private Str(String string2) {
            this.value = string2;
        }

        public String get() {
            return this.value;
        }

        @Override
        public void load(String string) {
            this.value = string;
        }

        public File getFile() {
            return new File(this.value);
        }

        @Override
        public String valueToString() {
            return this.value;
        }
    }

    public static enum Int implements ConfLoader.Storable
    {
        SearchHistorySize(20, 1),
        MaxLinesInProgressPanel(1000, 2),
        SearchBoxMaxWidth(500, 0),
        MaxResultsTotal(10000, 1),
        OpenLimit(10, 1),
        PatternTableHeight(4, 1),
        UnpackCacheCapacity(20, 1),
        InitialSorting(0),
        PythonApiPort(28834);

        private int value;
        private final int min;
        private final int max;

        private Int(int n2, int n3, int n4) {
            this.value = n2;
            this.min = n3;
            this.max = n4;
        }

        private Int(int n2, int n3) {
            this(n2, n3, Integer.MAX_VALUE);
        }

        private Int(int n2) {
            this(n2, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public int get() {
            return this.value;
        }

        @Override
        public void load(String string) {
            this.value = Util.clamp(Util.toInt(string, this.value), this.min, this.max);
        }

        @Override
        public String valueToString() {
            return Integer.toString(this.value);
        }
    }

    public static enum Bool implements ConfLoader.Storable
    {
        CheckSingleInstance(true),
        FixWindowSizes(false),
        DryRun(false),
        AllowIndexCreation(true),
        AllowIndexUpdate(true),
        AllowIndexRenaming(true),
        AllowIndexRebuild(true),
        AllowIndexDeletion(true),
        ShowAdvancedSettingsLink(true),
        ReportObsoleteIndexFiles(true),
        IndexExcelFormulas(true),
        SkipTarArchives(false),
        IgnoreJunctionsAndSymlinks(true),
        SaveSettings(true),
        TextPreviewEnabled(true),
        PdfPreviewVisualOrder(true),
        PythonApiEnabled(false),
        ShowPathsDuringIndexing(false),
        WriteIndexingLog(false),
        HotkeyEnabled(false);

        private boolean value;

        private Bool(boolean bl) {
            this.value = bl;
        }

        public boolean get() {
            return this.value;
        }

        @Override
        public void load(String string) {
            this.value = Boolean.parseBoolean(string);
        }

        @Override
        public String valueToString() {
            return Boolean.toString(this.value);
        }
    }
}

