/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.enums;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.util.ConfLoader;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public final class SettingsConf {
    private SettingsConf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadHeaderComment() throws IOException {
        URL uRL = SettingsConf.class.getResource("settings-conf-header.txt");
        try {
            return Resources.toString((URL)uRL, (Charset)Charsets.UTF_8);
        }
        catch (LinkageError linkageError) {
            try (InputStream inputStream = uRL.openStream();){
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                    stringBuilder.append('\n');
                }
                String string2 = stringBuilder.toString();
                return string2;
            }
        }
    }

    @ConfLoader.Description(value="# Font entries, consisting of font name, height and style.")
    public static enum FontDescription implements ConfLoader.Storable
    {
        PreviewWindows("Segoe UI", 11, 0),
        PreviewLinux("DejaVu Sans", 11, 0),
        PreviewMacOsX("SF Pro Text", 13, 0),
        PreviewMonoWindows("Consolas", 12, 0),
        PreviewMonoLinux("Liberation Mono", 12, 0),
        PreviewMonoMacOsX("Menlo", 12, 0);

        private static Pattern fontPattern;
        public final Event<Void> evtChanged = new Event();
        public final FontData defaultValue;
        private FontData value;

        private FontDescription(String string2, int n2, int n3) {
            this.value = this.defaultValue = new FontData(string2, n2, n3);
        }

        @Override
        public void load(String string) {
            Matcher matcher = fontPattern.matcher(string);
            if (!matcher.matches()) {
                return;
            }
            this.value = new FontData(matcher.group(1).trim(), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
        }

        @Override
        public String valueToString() {
            return Util.join(", ", this.value.getName(), this.value.getHeight(), this.value.getStyle());
        }

        public Font createFont() {
            return new Font((Device)Display.getDefault(), this.value);
        }

        public void set(FontData fontData) {
            Util.checkNotNull(fontData);
            this.value = fontData;
            this.evtChanged.fire(null);
        }

        public FontData createFontData() {
            return new FontData(this.value.getName(), this.value.getHeight(), this.value.getStyle());
        }

        public FontData createDefaultFontData() {
            return new FontData(this.defaultValue.getName(), this.defaultValue.getHeight(), this.defaultValue.getStyle());
        }

        static {
            fontPattern = Pattern.compile("(.*),\\s*(\\d+)\\s*,\\s*(\\d+)\\s*");
        }
    }

    @ConfLoader.Description(value="# Comma-separated lists of sash weights.")
    public static final class SashWeights
    extends Enum<SashWeights>
    implements ConfLoader.Storable {
        public static final /* enum */ SashWeights ProgressPanel = new SashWeights(2, 1);
        private final Event<SashForm> evtChanged = new Event();
        public final int[] defaultValue;
        private int[] value;
        private static final /* synthetic */ SashWeights[] $VALUES;

        public static SashWeights[] values() {
            return (SashWeights[])$VALUES.clone();
        }

        public static SashWeights valueOf(String string) {
            return Enum.valueOf(SashWeights.class, string);
        }

        private SashWeights(int ... nArray) {
            this.defaultValue = nArray;
            this.value = nArray;
        }

        public void bind(final SashForm sashForm) {
            Control[] controlArray = sashForm.getChildren();
            assert (controlArray.length > 0);
            if (controlArray.length != this.value.length) {
                assert (controlArray.length == this.defaultValue.length);
                this.value = this.defaultValue;
            }
            sashForm.setWeights(this.value);
            for (Control control : controlArray) {
                control.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent controlEvent) {
                        value = sashForm.getWeights();
                        UtilGui.runAsyncExec((Widget)sashForm, new Runnable(){

                            @Override
                            public void run() {
                                evtChanged.fire(sashForm);
                            }
                        });
                    }
                });
            }
            final Event.Listener<SashForm> listener = new Event.Listener<SashForm>(){

                @Override
                public void update(SashForm sashForm2) {
                    if (sashForm2 == sashForm) {
                        return;
                    }
                    if (Arrays.equals(sashForm.getWeights(), value)) {
                        return;
                    }
                    sashForm.setWeights(value);
                }
            };
            this.evtChanged.add(listener);
            sashForm.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    evtChanged.remove(listener);
                }
            });
        }

        @Override
        public void load(String string) {
            this.value = Util.toIntArray(string, this.value);
        }

        @Override
        public String valueToString() {
            return Ints.join((String)", ", (int[])this.value);
        }

        private static /* synthetic */ SashWeights[] $values() {
            return new SashWeights[]{ProgressPanel};
        }

        static {
            $VALUES = SashWeights.$values();
        }
    }

    @ConfLoader.Description(value="# Column orderings.")
    public static enum ColumnOrder implements ConfLoader.Storable
    {
        ResultPanelColumnOrder(new int[0]);

        public final int[] defaultValue;
        private int[] value;

        private ColumnOrder(int ... nArray) {
            this.defaultValue = nArray;
            this.value = nArray;
        }

        @Override
        public void load(String string) {
            this.value = Util.toIntArray(string, this.value);
        }

        @Override
        public String valueToString() {
            return Ints.join((String)", ", (int[])this.value);
        }

        public void bind(final Table table) {
            TableColumn[] tableColumnArray = table.getColumns();
            int n = tableColumnArray.length;
            Util.checkThat(n > 0);
            if (n != this.value.length) {
                this.value = this.defaultValue;
            }
            ControlAdapter controlAdapter = new ControlAdapter(){

                public void controlMoved(ControlEvent controlEvent) {
                    value = table.getColumnOrder();
                }
            };
            for (TableColumn tableColumn : tableColumnArray) {
                tableColumn.setMoveable(true);
                tableColumn.addControlListener((ControlListener)controlAdapter);
            }
            if (table.getColumnCount() == this.value.length) {
                table.setColumnOrder(this.value);
            }
        }
    }

    @ConfLoader.Description(value="# Comma-separated lists of table column widths.")
    public static enum ColumnWidths implements ConfLoader.Storable
    {
        ResultPanel(250, 75, 75, 200, 75, 350, 100, 100),
        IndexingErrorTable(100, 100, 500),
        PatternTable(200, 75, 75);

        private final Event<Table> evtChanged = new Event();
        public final int[] defaultValue;
        private int[] value;

        private ColumnWidths(int ... nArray) {
            this.defaultValue = nArray;
            this.value = nArray;
        }

        public void bind(final Table table) {
            final TableColumn[] tableColumnArray = table.getColumns();
            int n = tableColumnArray.length;
            Util.checkThat(n > 0);
            if (n != this.value.length) {
                Util.checkThat(n == this.defaultValue.length);
                this.value = this.defaultValue;
            }
            for (int i = 0; i < n; ++i) {
                final TableColumn tableColumn = tableColumnArray[i];
                final int n2 = i;
                tableColumn.setWidth(this.value[i]);
                tableColumn.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent controlEvent) {
                        value[n2] = tableColumn.getWidth();
                        evtChanged.fire(table);
                    }
                });
            }
            final Event.Listener<Table> listener = new Event.Listener<Table>(){

                @Override
                public void update(Table table2) {
                    if (table2 == table) {
                        return;
                    }
                    Util.checkThat(tableColumnArray.length == table.getColumnCount());
                    for (int i = 0; i < tableColumnArray.length; ++i) {
                        tableColumnArray[i].setWidth(value[i]);
                    }
                }
            };
            this.evtChanged.add(listener);
            table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    evtChanged.remove(listener);
                }
            });
        }

        @Override
        public void load(String string) {
            this.value = Util.toIntArray(string, this.value);
        }

        @Override
        public String valueToString() {
            return Ints.join((String)", ", (int[])this.value);
        }
    }

    @ConfLoader.Description(value="# Window dimensions: x, y, width and height. If x < 0 or\r\n# y < 0, the window is centered relative to the screen or to\r\n# its parent window.")
    public static enum ShellBounds implements ConfLoader.Storable
    {
        MainWindow(-1, -1, 1024, 768),
        IndexingDialog(-1, -1, 600, 750),
        FileExtensionChooser(-1, -1, 300, 450),
        PreferencesDialog(-1, -1, 750, 600);

        public final int[] defaultValue;
        private int[] value;

        private ShellBounds(int n2, int n3, int n4, int n5) {
            this.defaultValue = new int[]{n2, n3, n4, n5};
            this.value = this.defaultValue;
        }

        public void bind(final Shell shell) {
            if (this.value[0] < 0 || this.value[1] < 0) {
                UtilGui.setCenteredBounds(shell, this.value[2], this.value[3]);
            } else {
                shell.setBounds(this.value[0], this.value[1], this.value[2], this.value[3]);
            }
            shell.addControlListener((ControlListener)new ControlAdapter(){

                public void controlMoved(ControlEvent controlEvent) {
                    if (shell.getMaximized()) {
                        return;
                    }
                    Point point = shell.getLocation();
                    value[0] = point.x;
                    value[1] = point.y;
                }

                public void controlResized(ControlEvent controlEvent) {
                    if (shell.getMaximized()) {
                        return;
                    }
                    if (ProgramConf.Bool.FixWindowSizes.get()) {
                        return;
                    }
                    Point point = shell.getSize();
                    value[2] = point.x;
                    value[3] = point.y;
                }
            });
        }

        @Override
        public void load(String string) {
            this.value = Util.toIntArray(string, this.value);
        }

        @Override
        public String valueToString() {
            return Ints.join((String)", ", (int[])this.value);
        }
    }

    @ConfLoader.Description(value="# Semicolon-separated lists of strings.")
    public static enum StrList implements ConfLoader.Storable
    {
        SearchHistory(new String[0]);

        public final Event<List<String>> evtChanged = new Event();
        public final List<String> defaultValue;
        private List<String> value;

        private StrList(String ... stringArray) {
            this.defaultValue = Arrays.asList(stringArray);
            this.value = this.defaultValue;
        }

        public List<String> get() {
            return Collections.unmodifiableList(this.value);
        }

        public void set(String ... stringArray) {
            if (Util.equals(this.value, stringArray)) {
                return;
            }
            this.value = Arrays.asList(stringArray);
            this.evtChanged.fire(this.value);
        }

        public void set(List<String> list) {
            if (this.value.equals(list)) {
                return;
            }
            this.value = list;
            this.evtChanged.fire(list);
        }

        @Override
        public void load(String string) {
            this.value = Util.decodeStrings(';', string);
        }

        @Override
        public String valueToString() {
            return Util.encodeStrings(";", this.value);
        }
    }

    @ConfLoader.Description(value="# Comma-separated lists of integers.")
    public static enum IntArray implements ConfLoader.Storable
    {
        PreviewHighlighting(255, 255, 0),
        Hotkey(262144, 0x1000011),
        FilterSash(1, 1),
        RightSashHorizontal(1, 1),
        RightSashVertical(1, 1);

        public final Event<int[]> evtChanged = new Event();
        public final int[] defaultValue;
        private int[] value;

        private IntArray(int ... nArray) {
            this.defaultValue = nArray;
            this.value = nArray;
        }

        public int[] get() {
            return this.value;
        }

        public void set(int ... nArray) {
            if (Arrays.equals(this.value, nArray)) {
                return;
            }
            this.value = nArray;
            this.evtChanged.fire(nArray);
        }

        @Override
        public void load(String string) {
            this.value = Util.toIntArray(string, this.value);
            if (this.value.length != this.defaultValue.length) {
                this.value = this.defaultValue;
            }
        }

        @Override
        public String valueToString() {
            return Ints.join((String)", ", (int[])this.value);
        }
    }

    @ConfLoader.Description(value="# String entries. All values allowed, except for \\, \\t, \\n,\r\n# \\r, \\f, =, :, #, ! and leading whitespace, which must be\r\n# escaped by a preceding \\.")
    public static enum Str implements ConfLoader.Storable
    {
        LastIndexedFolder(Util.USER_HOME_PATH);

        public final Event<String> evtChanged = new Event();
        public final String defaultValue;
        private String value;

        private Str(String string2) {
            this.value = this.defaultValue = string2;
        }

        public String get() {
            return this.value;
        }

        public void set(String string) {
            if (this.value == string) {
                return;
            }
            this.value = string;
            this.evtChanged.fire(string);
        }

        @Override
        public void load(String string) {
            this.value = string;
        }

        @Override
        public String valueToString() {
            return this.value;
        }
    }

    @ConfLoader.Description(value="# Integer entries.")
    public static enum Int implements ConfLoader.Storable
    {
        FilterPanelWidth(250),
        LuceneAnalyzer(Int.getDefaultAnalyzer());

        public final Event<Integer> evtChanged = new Event();
        public final int defaultValue;
        private int value;

        private Int(int n2) {
            this.value = this.defaultValue = n2;
        }

        public int get() {
            return this.value;
        }

        public void set(int n) {
            if (this.value == n) {
                return;
            }
            this.value = n;
            this.evtChanged.fire(n);
        }

        @Override
        public void load(String string) {
            this.value = Util.toInt(string, this.value);
        }

        @Override
        public String valueToString() {
            return Integer.toString(this.value);
        }

        private static int getDefaultAnalyzer() {
            String string = System.getProperty("user.language");
            if (string.startsWith("zh")) {
                return 2;
            }
            return 0;
        }
    }

    @ConfLoader.Description(value="# Boolean entries. Allowed values: true, false")
    public static enum Bool implements ConfLoader.Storable
    {
        ShowManualOnStartup(true),
        UseOrOperator(true),
        HideOnOpen(false),
        ClearSearchHistoryOnExit(false),
        UseTypeAheadSearch(false),
        ResetLocationFilterOnExit(true),
        HotkeyEnabled(true),
        ShowDocFetcherProTip(true),
        ShowFilterPanel(true),
        ShowPreviewPanel(true),
        ShowPreviewPanelAtBottom(true),
        FilesizeFilterMaximized(true),
        TypesFilterMaximized(false),
        LocationFilterMaximized(false),
        MainShellMaximized(false),
        PreferHtmlPreview(true),
        HighlightingEnabled(true),
        ShowRelativePathsMessage(true),
        AutoScrollToFirstMatch(true),
        CloseToTray(false),
        AllowOnlyOneInstance(false);

        public final Event<Boolean> evtChanged = new Event();
        public final boolean defaultValue;
        private boolean value;

        private Bool(boolean bl) {
            this.value = this.defaultValue = bl;
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean bl) {
            if (this.value == bl) {
                return;
            }
            this.value = bl;
            this.evtChanged.fire(bl);
        }

        @Override
        public void load(String string) {
            this.value = Boolean.parseBoolean(string);
        }

        @Override
        public String valueToString() {
            return Boolean.toString(this.value);
        }

        public void bindMaximized(final Shell shell) {
            shell.setMaximized(this.value);
            shell.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    value = shell.getMaximized();
                }
            });
        }
    }
}

