/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import com.drew.lang.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.common.io.LineReader;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.docfetcher.Main;
import net.sourceforge.docfetcher.Py4jHandler;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.enums.SystemConf;
import net.sourceforge.docfetcher.gui.HintOverlay;
import net.sourceforge.docfetcher.gui.HotkeyHandler;
import net.sourceforge.docfetcher.gui.ManualLocator;
import net.sourceforge.docfetcher.gui.MovingBox;
import net.sourceforge.docfetcher.gui.ResultPanel;
import net.sourceforge.docfetcher.gui.SearchBar;
import net.sourceforge.docfetcher.gui.SearchQueue;
import net.sourceforge.docfetcher.gui.StatusBar;
import net.sourceforge.docfetcher.gui.SystemTrayHider;
import net.sourceforge.docfetcher.gui.ThreePanelForm;
import net.sourceforge.docfetcher.gui.filter.FileTypePanel;
import net.sourceforge.docfetcher.gui.filter.FilesizePanel;
import net.sourceforge.docfetcher.gui.filter.IndexPanel;
import net.sourceforge.docfetcher.gui.filter.ToolBarForm;
import net.sourceforge.docfetcher.gui.filter.TwoFormExpander;
import net.sourceforge.docfetcher.gui.pref.PrefDialog;
import net.sourceforge.docfetcher.gui.preview.PreviewPanel;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.Daemon;
import net.sourceforge.docfetcher.model.FolderWatcher;
import net.sourceforge.docfetcher.model.IndexLoadingProblems;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.index.IndexingQueue;
import net.sourceforge.docfetcher.model.index.Task;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.model.search.ResultDocument;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.CharsetDetectorHelper;
import net.sourceforge.docfetcher.util.ConfLoader;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.AlphanumComparator;
import net.sourceforge.docfetcher.util.collect.ListMap;
import net.sourceforge.docfetcher.util.gui.CocoaUIEnhancer;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import net.sourceforge.docfetcher.util.gui.LazyImageCache;
import net.sourceforge.docfetcher.util.gui.dialog.InfoDialog;
import net.sourceforge.docfetcher.util.gui.dialog.ListConfirmDialog;
import net.sourceforge.docfetcher.util.gui.dialog.MultipleChoiceDialog;
import org.apache.lucene.index.MergePolicy;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class Application {
    private static final int sashWidth = 5;
    private static volatile IndexRegistry indexRegistry;
    private static volatile FolderWatcher folderWatcher;
    private static HotkeyHandler hotkeyHandler;
    private static File programConfFile;
    private static FilesizePanel filesizePanel;
    private static FileTypePanel fileTypePanel;
    private static IndexPanel indexPanel;
    private static volatile Shell shell;
    private static ThreePanelForm threePanelForm;
    private static SearchBar searchBar;
    private static ResultPanel resultPanel;
    private static PreviewPanel previewPanel;
    private static volatile StatusBar.StatusBarPart indexingStatus;
    private static SystemTrayHider systemTrayHider;
    private static StatusBar statusBar;
    private static HintOverlay docfetcherProTip;
    private static boolean systemTrayShutdown;
    private static File settingsConfFile;
    private static boolean indexRegistryLoaded;
    private static Runnable clearIndexLoadingMsg;

    private Application() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        File file;
        File file2;
        block20: {
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            String string = "system-conf.txt";
            String string2 = "dev/system-conf.txt";
            boolean bl = ConfLoader.loadFromStreamOrFile(Main.class, SystemConf.class, string, string2);
            if (!bl) {
                Util.printErr("Couldn't find resource: " + string);
                System.exit(1);
            }
            AppUtil.Const.PROGRAM_NAME.set(SystemConf.Str.ProgramName.get());
            AppUtil.Const.PROGRAM_VERSION.set(SystemConf.Str.ProgramVersion.get());
            AppUtil.Const.PROGRAM_BUILD_DATE.set(SystemConf.Str.BuildDate.get());
            AppUtil.Const.USER_DIR_PATH.set(Util.USER_DIR_PATH);
            AppUtil.Const.IS_PORTABLE.set(SystemConf.Bool.IsPortable.get());
            AppUtil.Const.IS_DEVELOPMENT_VERSION.set(SystemConf.Bool.IsDevelopmentVersion.get());
            Msg.loadFromDisk();
            Msg.setCheckEnabled(false);
            AppUtil.Messages.system_error.set(Msg.system_error.get());
            AppUtil.Messages.confirm_operation.set(Msg.confirm_operation.get());
            AppUtil.Messages.invalid_operation.set(Msg.invalid_operation.get());
            AppUtil.Messages.program_died_stacktrace_written.set(Msg.report_bug.get());
            AppUtil.Messages.program_running_launch_another.set(Msg.program_running_launch_another.get());
            AppUtil.Messages.ok.set(Msg.ok.get());
            AppUtil.Messages.cancel.set(Msg.cancel.get());
            Msg.setCheckEnabled(true);
            AppUtil.Messages.checkInitialized();
            file2 = null;
            file = null;
            try {
                if (Util.IS_MAC_OS_X && !AppUtil.isPortable()) {
                    serializable = AppUtil.getAppDataDir();
                    object3 = new File((File)serializable, "paths.txt");
                    if (!((File)object3).exists() && ((File)(object2 = new File("../Resources/misc", "paths.txt"))).exists()) {
                        Files.copy((File)object2, (File)object3);
                    }
                } else {
                    object3 = new File("misc", "paths.txt");
                }
                serializable = CharsetDetectorHelper.load((File)object3);
                file2 = Application.toFile((Properties)serializable, "settings");
                IndexRegistry.indexPathOverride = Application.toFile((Properties)serializable, "indexes");
                file = Application.toFile((Properties)serializable, "swt");
            }
            catch (IOException iOException) {
                if (SystemConf.Bool.IsDevelopmentVersion.get()) break block20;
                iOException.printStackTrace();
            }
        }
        Application.configureSwtLibraryPath(file);
        programConfFile = Application.loadProgramConf(file2);
        settingsConfFile = Application.loadSettingsConf(file2);
        if (stringArray.length >= 1 && stringArray[0].equals("--update-indexes")) {
            Application.loadIndexRegistryHeadless(Application.getIndexParentDir(IndexRegistry.indexPathOverride));
            return;
        }
        if (ProgramConf.Bool.CheckSingleInstance.get() && !AppUtil.checkSingleInstance()) {
            return;
        }
        Application.checkMultipleDocFetcherJars();
        object3 = SystemConf.Bool.IsDevelopmentVersion.get() ? SystemConf.Str.ProgramName.get() : ProgramConf.Str.AppName.get();
        Display.setAppName((String)object3);
        serializable = new Display();
        AppUtil.setDisplay((Display)serializable);
        shell = new Shell((Display)serializable);
        Application.loadIndexRegistry(shell, Application.getIndexParentDir(IndexRegistry.indexPathOverride));
        object2 = new LazyImageCache((Display)serializable, AppUtil.getImageDir());
        Img.initialize((LazyImageCache)object2);
        ((LazyImageCache)object2).reportMissingFiles(shell, Img.class, Msg.missing_image_files.get());
        shell.setImages(new Image[]{Img.DOCFETCHER_16.get(), Img.DOCFETCHER_24.get(), Img.DOCFETCHER_32.get(), Img.DOCFETCHER_48.get(), Img.DOCFETCHER_64.get(), Img.DOCFETCHER_128.get()});
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                Application.handleCrash(throwable);
            }
        });
        SettingsConf.ShellBounds.MainWindow.bind(shell);
        SettingsConf.Bool.MainShellMaximized.bindMaximized(shell);
        shell.setLayout((Layout)new FormLayout());
        shell.setText((String)object3);
        Application.initCocoaMenu((Display)serializable);
        Application.initSystemTrayHider();
        Application.initThreePanelForm();
        Application.initStatusBar();
        Application.initHotkey();
        Application.initGlobalKeys((Display)serializable);
        if (SettingsConf.Bool.ShowDocFetcherProTip.get()) {
            Application.showDocFetcherProTip();
        }
        new SearchQueue(searchBar, filesizePanel, fileTypePanel, indexPanel, resultPanel, statusBar);
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.bottom().left().right().applyTo((Control)statusBar);
        formDataFactory.top().bottom((Control)statusBar).applyTo((Control)threePanelForm);
        searchBar.setFocus();
        boolean bl = true;
        if (SettingsConf.Bool.ShowManualOnStartup.get() && SettingsConf.Bool.ShowPreviewPanel.get()) {
            object = ManualLocator.getManualFile();
            if (object == null) {
                bl = false;
                if (!SystemConf.Bool.IsDevelopmentVersion.get()) {
                    String string = Msg.file_not_found.get() + "\n" + SystemConf.Str.ProgramName.get() + "_Manual.html";
                    AppUtil.showError(string, true, true);
                }
            } else if (previewPanel.setHtmlFile((File)object)) {
                bl = false;
            }
        }
        if (bl) {
            object = Msg.press_f1_for_help.get();
            statusBar.getLeftPart().setContents(Img.HELP.get(), (String)object);
        }
        if (ProgramConf.Bool.PythonApiEnabled.get()) {
            Py4jHandler.openGatewayServer();
        }
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                Application.handleShellClosed(shellEvent);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            try {
                if (serializable.readAndDispatch()) continue;
                serializable.sleep();
            }
            catch (Throwable throwable) {
                Application.handleCrash(throwable);
            }
        }
        if (ProgramConf.Bool.PythonApiEnabled.get()) {
            Py4jHandler.shutdownGatewayServer();
        }
        serializable.dispose();
        Application.saveSettingsConfFile();
    }

    private static File toFile(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\$\\{user\\.home}(?:[\\\\/](.*))?");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            if (matcher.group(1) == null || matcher.group(1).trim().isEmpty()) {
                return new File(Util.USER_HOME_PATH);
            }
            return new File(Util.USER_HOME_PATH, matcher.group(1));
        }
        return Util.getCanonicalFile(string2);
    }

    private static void handleCrash(Throwable throwable) {
        Object object;
        Object object2;
        if (throwable instanceof SWTException) {
            object2 = (SWTException)throwable;
            if ((((SWTException)object2).code == 24 || object2.getMessage() != null && object2.getMessage().contains("Widget is disposed")) && ((String)(object = Throwables.getStackTraceAsString((Throwable)throwable))).contains("org.eclipse.swt.accessibility.Accessible")) {
                return;
            }
            if (object2.getMessage() != null && object2.getMessage().contains("g_object_get_qdata") && (((String)(object = Throwables.getStackTraceAsString((Throwable)throwable))).contains("Display.removeWidget") || ((String)object).contains("Widget.deregister") || ((String)object).contains("Widget.releaseWidget"))) {
                return;
            }
        }
        if ((object2 = Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)throwable), OutOfMemoryError.class).iterator()).hasNext()) {
            object = (OutOfMemoryError)object2.next();
            UtilGui.showOutOfMemoryMessage((Control)shell, (Throwable)object);
            return;
        }
        if (throwable instanceof MergePolicy.MergeException) {
            object2 = throwable.getMessage();
            object2 = (String)object2 + "\n\nPlease ensure no other programs are accessing or locking the index files.";
            AppUtil.showError((String)object2, true, false);
            return;
        }
        AppUtil.showStackTrace(throwable);
    }

    private static void saveSettingsConfFile() {
        if (ProgramConf.Bool.SaveSettings.get() && settingsConfFile.canWrite()) {
            try {
                String string = SettingsConf.loadHeaderComment();
                ConfLoader.save(settingsConfFile, SettingsConf.class, string);
            }
            catch (IOException iOException) {
                boolean bl = Display.getCurrent() != null;
                Application.handleConfigurationIOException(iOException, settingsConfFile, bl);
            }
        }
    }

    private static void checkMultipleDocFetcherJars() {
        if (SystemConf.Bool.IsDevelopmentVersion.get()) {
            return;
        }
        if (!AppUtil.isPortable() && !Util.IS_WINDOWS) {
            return;
        }
        Pattern pattern = Pattern.compile("net\\.sourceforge\\.docfetcher.*\\.jar");
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file : Util.listFiles(new File("lib"))) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            linkedList.add(file);
        }
        if (linkedList.size() == 1) {
            return;
        }
        assert (!linkedList.isEmpty());
        String string = Msg.multiple_docfetcher_jars.format(Util.join("\n", linkedList));
        AppUtil.showErrorOnStart(string, false);
    }

    private static void initGlobalKeys(Display display) {
        display.addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                if (Display.getCurrent().getActiveShell() != shell) {
                    return;
                }
                event.doit = false;
                int n = event.stateMask;
                int n2 = event.keyCode;
                if (n2 == 0x100000A) {
                    Application.showManual();
                    String string = Msg.press_f1_for_help.get();
                    StatusBar.StatusBarPart statusBarPart = statusBar.getLeftPart();
                    if (string.equals(statusBarPart.getText())) {
                        statusBarPart.setContents(null, "");
                    }
                } else if (n == SWT.MOD1 && n2 == 102) {
                    searchBar.setFocus();
                } else {
                    event.doit = true;
                }
            }
        });
    }

    private static File getIndexParentDir(File file) {
        File file2;
        if (SystemConf.Bool.IsDevelopmentVersion.get()) {
            file2 = new File("bin/indexes");
        } else if (file != null && !file.isFile()) {
            file.mkdirs();
            file2 = file;
        } else {
            File file3 = AppUtil.getAppDataDir();
            file2 = SystemConf.Bool.IsPortable.get() ? new File(file3, "indexes") : file3;
        }
        file2.mkdirs();
        return file2;
    }

    private static void loadIndexRegistry(final Shell shell, File file) {
        UtilGui.assertSwtThread();
        final Display display = shell.getDisplay();
        int n = ProgramConf.Int.UnpackCacheCapacity.get();
        int n2 = ProgramConf.Int.MaxLinesInProgressPanel.get();
        indexRegistry = new IndexRegistry(file, n, n2);
        final Daemon daemon = new Daemon(indexRegistry);
        IndexingQueue indexingQueue = indexRegistry.getQueue();
        indexingQueue.evtWorkerThreadTerminated.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                daemon.writeIndexesToFile();
            }
        });
        indexingQueue.evtQueueEmpty.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                if (indexingStatus == null) {
                    return;
                }
                UtilGui.runAsyncExec((Widget)indexingStatus.getControl(), new Runnable(this){

                    @Override
                    public void run() {
                        indexingStatus.setVisible(false);
                    }
                });
            }
        });
        new Thread(Application.class.getName() + " (load index registry)"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    IndexLoadingProblems indexLoadingProblems;
                    block10: {
                        indexLoadingProblems = indexRegistry.load(new Cancelable(){

                            @Override
                            public boolean isCanceled() {
                                return display.isDisposed();
                            }
                        });
                        if (!display.isDisposed()) break block10;
                        UtilGui.runAsyncExec((Widget)shell, new Runnable(this){

                            @Override
                            public void run() {
                                indexRegistryLoaded = true;
                                if (clearIndexLoadingMsg != null) {
                                    clearIndexLoadingMsg.run();
                                }
                            }
                        });
                        return;
                    }
                    try {
                        StringBuilder stringBuilder;
                        folderWatcher = new FolderWatcher(indexRegistry);
                        Application.folderWatcher.evtWatchLimitError.add(new Event.Listener<String>(){

                            @Override
                            public void update(final String string) {
                                UtilGui.runAsyncExec((Widget)shell, new Runnable(){

                                    @Override
                                    public void run() {
                                        InfoDialog infoDialog = new InfoDialog(shell);
                                        infoDialog.setTitle(Msg.system_error.get());
                                        infoDialog.setImage(1);
                                        infoDialog.setText(string);
                                        infoDialog.open();
                                    }
                                });
                            }
                        });
                        daemon.enqueueUpdateTasks();
                        if (ProgramConf.Bool.ReportObsoleteIndexFiles.get() && !indexLoadingProblems.getObsoleteFiles().isEmpty()) {
                            UtilGui.runSyncExec((Widget)shell, new Runnable(){

                                @Override
                                public void run() {
                                    Application.reportObsoleteIndexFiles(shell, indexRegistry.getIndexParentDir(), indexLoadingProblems.getObsoleteFiles());
                                }
                            });
                        }
                        if (!indexLoadingProblems.getCorruptedIndexes().isEmpty()) {
                            stringBuilder = new StringBuilder(Msg.corrupted_indexes.get());
                            for (IndexLoadingProblems.CorruptedIndex object : indexLoadingProblems.getCorruptedIndexes()) {
                                stringBuilder.append("\n\n");
                                String string = object.index.getRootFolder().getDisplayName();
                                String string2 = object.ioException.getMessage();
                                stringBuilder.append(Msg.index.format(string));
                                stringBuilder.append("\n");
                                stringBuilder.append(Msg.error.format(string2));
                            }
                            AppUtil.showError(stringBuilder.toString(), true, false);
                        }
                        if (indexLoadingProblems.getOverflowIndexes().isEmpty()) break block11;
                        stringBuilder = new StringBuilder(Msg.folder_hierarchy_too_deep_on_loading.get());
                        stringBuilder.append("\n");
                        for (IndexLoadingProblems.OverflowIndex overflowIndex : indexLoadingProblems.getOverflowIndexes()) {
                            stringBuilder.append("\n");
                            stringBuilder.append(overflowIndex.file.getName());
                        }
                        AppUtil.showError(stringBuilder.toString(), true, false);
                    }
                    catch (IOException iOException) {
                        block12: {
                            try {
                                if (display.isDisposed()) {
                                    AppUtil.showStackTraceInOwnDisplay(iOException);
                                    break block12;
                                }
                                AppUtil.showStackTrace(iOException);
                            }
                            catch (Throwable throwable) {
                                UtilGui.runAsyncExec((Widget)shell, new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                        UtilGui.runAsyncExec((Widget)shell, new /* invalid duplicate definition of identical inner class */);
                    }
                }
                UtilGui.runAsyncExec((Widget)shell, new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
    }

    private static void loadIndexRegistryHeadless(File file) {
        int n = ProgramConf.Int.UnpackCacheCapacity.get();
        int n2 = ProgramConf.Int.MaxLinesInProgressPanel.get();
        indexRegistry = new IndexRegistry(file, n, n2);
        try {
            indexRegistry.load(Cancelable.nullCancelable);
            final IndexingQueue indexingQueue = indexRegistry.getQueue();
            indexingQueue.evtQueueEmpty.add(new Event.Listener<Void>(){

                @Override
                public void update(Void void_) {
                    indexRegistry.getSearcher().shutdown();
                    indexingQueue.shutdown(new Task.CancelHandler(this){

                        @Override
                        public Task.CancelAction cancel() {
                            return Task.CancelAction.KEEP;
                        }
                    });
                }
            });
            for (LuceneIndex luceneIndex : indexRegistry.getIndexes()) {
                indexingQueue.addTask(luceneIndex, Task.IndexAction.UPDATE);
            }
        }
        catch (IOException iOException) {
            Util.printErr(iOException);
        }
    }

    private static void reportObsoleteIndexFiles(Shell shell, File file, List<File> list) {
        ListConfirmDialog listConfirmDialog = new ListConfirmDialog(shell, 2);
        listConfirmDialog.setTitle(Msg.confirm_operation.get());
        listConfirmDialog.setText(Msg.delete_obsolete_index_files.format(file.getPath()));
        listConfirmDialog.setButtonLabels(Msg.delete_bt.get(), Msg.keep.get());
        list = new ArrayList<File>(list);
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                boolean bl = file.isDirectory();
                boolean bl2 = file2.isDirectory();
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
                return AlphanumComparator.ignoreCaseInstance.compare(file.getName(), file2.getName());
            }
        });
        for (File file2 : list) {
            Image image = (file2.isDirectory() ? Img.FOLDER : Img.FILE).get();
            listConfirmDialog.addItem(image, file2.getName());
        }
        listConfirmDialog.evtLinkClicked.add(new Event.Listener<String>(){

            @Override
            public void update(String string) {
                UtilGui.launch(string);
            }
        });
        if (listConfirmDialog.open()) {
            for (File file2 : list) {
                try {
                    Util.deleteRecursively(file2);
                }
                catch (IOException iOException) {
                    Util.printErr(iOException);
                }
            }
        }
    }

    private static void handleConfigurationIOException(IOException iOException, File file, boolean bl) {
        boolean bl2;
        File file2 = Util.getParentFile(file);
        boolean bl3 = bl2 = file2 != null && file2.exists() && !AppUtil.canWriteToDirectory(file2);
        if (bl2 && SystemConf.Bool.IsPortable.get()) {
            String string = new File(Util.USER_DIR_PATH).getAbsolutePath();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The portable version of " + SystemConf.Str.ProgramName.get() + " cannot write to the following location:\n\n");
            stringBuilder.append(file.getAbsolutePath() + "\n\n");
            stringBuilder.append("This is likely because the program is installed in a protected system directory:\n\n");
            stringBuilder.append(string + "\n\n");
            stringBuilder.append("Possible solutions:\n\n");
            stringBuilder.append("1. Use the official installer instead of the portable version. The installer will place files in the appropriate user directories. (Recommended)\n\n");
            stringBuilder.append("2. Move the portable version to a writable location such as your Desktop, Documents folder, or a folder in your user directory.\n\n");
            stringBuilder.append("3. Run the program as Administrator. (Not recommended for security reasons.)\n\n");
            stringBuilder.append("Technical details: " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
            AppUtil.showErrorOnStart(stringBuilder.toString(), false);
        } else if (bl) {
            AppUtil.showStackTrace(iOException);
        } else {
            AppUtil.showStackTraceInOwnDisplay(iOException);
        }
    }

    private static File loadProgramConf(File file) {
        Object object;
        File file2;
        AppUtil.checkConstInitialized();
        AppUtil.ensureNoDisplay();
        if (SystemConf.Bool.IsDevelopmentVersion.get()) {
            file2 = new File("dist/program-conf.txt");
        } else if (file != null && !file.isFile()) {
            file.mkdirs();
            file2 = new File(file, "program-conf.txt");
        } else {
            object = AppUtil.getAppDataDir();
            file2 = new File((File)object, "conf/program-conf.txt");
        }
        try {
            object = ConfLoader.load(file2, ProgramConf.class, false);
            if (!object.isEmpty()) {
                if (SystemConf.Bool.IsDevelopmentVersion.get()) {
                    ArrayList<CallSite> arrayList = new ArrayList<CallSite>(object.size());
                    Object object2 = object.iterator();
                    while (object2.hasNext()) {
                        ConfLoader.Loadable loadable = (ConfLoader.Loadable)object2.next();
                        arrayList.add((CallSite)((Object)("  " + loadable.name())));
                    }
                    object2 = Msg.entries_missing.format(file2.getName());
                    object2 = (String)object2 + "\n" + Joiner.on((String)"\n").join(arrayList);
                    AppUtil.showErrorOnStart((String)object2, false);
                } else {
                    Application.regenerateConfFile(file2, ProgramConf.class);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Application.regenerateConfFile(file2, ProgramConf.class);
        }
        catch (IOException iOException) {
            Application.handleConfigurationIOException(iOException, file2, false);
        }
        return file2;
    }

    private static void regenerateConfFile(File file, Class<?> clazz) {
        Pattern pattern = Pattern.compile("(\\w+)\\s*=.*");
        try {
            String string;
            URL uRL = Resources.getResource(Main.class, (String)file.getName());
            LineReader lineReader = new LineReader((Readable)new StringReader(Resources.toString((URL)uRL, (Charset)Charsets.UTF_8)));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = lineReader.readLine()) != null) {
                if ((string = string.trim()).isEmpty() || string.startsWith("#")) {
                    arrayList.add(string);
                    continue;
                }
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) {
                    arrayList.add(string);
                    continue;
                }
                String string2 = matcher.group(1);
                String string3 = ConfLoader.getRawValue(string2, clazz);
                if (string3 != null) {
                    if (string3.trim().isEmpty()) {
                        arrayList.add(String.format("%s =", string2));
                        continue;
                    }
                    arrayList.add(String.format("%s = %s", string2, string3));
                    continue;
                }
                arrayList.add(string);
            }
            string = Util.join(Util.LS, arrayList);
            Util.getParentFile(file).mkdirs();
            Files.write((CharSequence)string, (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            Application.handleConfigurationIOException(iOException, file, false);
        }
        catch (Exception exception) {
            AppUtil.showStackTraceInOwnDisplay(exception);
        }
    }

    private static File loadSettingsConf(File file) {
        File file2;
        AppUtil.checkConstInitialized();
        AppUtil.ensureNoDisplay();
        if (SystemConf.Bool.IsDevelopmentVersion.get()) {
            file2 = new File("bin/settings-conf.txt");
        } else if (file != null && !file.isFile()) {
            file.mkdirs();
            file2 = new File(file, "settings-conf.txt");
        } else {
            File file3 = AppUtil.getAppDataDir();
            file2 = new File(file3, "conf/settings-conf.txt");
        }
        try {
            ConfLoader.load(file2, SettingsConf.class, true);
        }
        catch (IOException iOException) {
            Application.handleConfigurationIOException(iOException, file2, false);
        }
        return file2;
    }

    private static Control createLeftPanel(Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        ToolBarForm toolBarForm = new ToolBarForm(composite2){

            @Override
            protected Control createToolBar(Composite composite) {
                final Label label = new Label(composite, 0);
                Image image = SettingsConf.Bool.FilesizeFilterMaximized.get() ? Img.MINIMIZE.get() : Img.MAXIMIZE.get();
                label.setImage(image);
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent mouseEvent) {
                        boolean bl = !this.isContentsVisible();
                        this.setContentsVisible(bl);
                        Image image = bl ? Img.MINIMIZE.get() : Img.MAXIMIZE.get();
                        label.setImage(image);
                        composite2.layout();
                        SettingsConf.Bool.FilesizeFilterMaximized.set(bl);
                    }
                });
                label.setCursor(label.getDisplay().getSystemCursor(21));
                UtilGui.addMouseHighlighter((Control)label);
                return label;
            }

            @Override
            protected Control createContents(Composite composite) {
                filesizePanel = new FilesizePanel(composite);
                return filesizePanel.getControl();
            }
        };
        toolBarForm.setText(Msg.min_max_filesize.get());
        toolBarForm.setContentsVisible(SettingsConf.Bool.FilesizeFilterMaximized.get());
        final TwoFormExpander twoFormExpander = new TwoFormExpander(composite2){

            @Override
            protected Control createFirstContents(Composite composite) {
                List<Parser> list = ParseService.getParsers();
                ListMap<Parser, Boolean> listMap = ListMap.create(list.size());
                for (Parser parser : list) {
                    listMap.add(parser, true);
                }
                fileTypePanel = new FileTypePanel(composite, listMap);
                return fileTypePanel.getControl();
            }

            @Override
            protected Control createSecondContents(Composite composite) {
                indexPanel = new IndexPanel(composite, indexRegistry);
                Application.indexPanel.evtIndexingDialogMinimized.add(new Event.Listener<Rectangle>(this){

                    @Override
                    public void update(Rectangle rectangle) {
                        Application.moveIndexingDialogToStatusBar(rectangle);
                    }
                });
                return indexPanel.getControl();
            }

            @Override
            protected void onMaximizationChanged() {
                TwoFormExpander.MaximizedControl maximizedControl = this.getMaximizedControl();
                boolean bl = maximizedControl == TwoFormExpander.MaximizedControl.TOP;
                boolean bl2 = maximizedControl == TwoFormExpander.MaximizedControl.BOTTOM;
                SettingsConf.Bool.TypesFilterMaximized.set(bl);
                SettingsConf.Bool.LocationFilterMaximized.set(bl2);
            }
        };
        twoFormExpander.setTopText(Msg.document_types.get());
        if (indexRegistryLoaded) {
            twoFormExpander.setBottomText(Msg.search_scope.get());
        } else {
            twoFormExpander.setBottomText(Msg.search_scope.get() + " (" + Msg.loading.get() + ")");
            clearIndexLoadingMsg = new Runnable(){

                @Override
                public void run() {
                    UtilGui.assertSwtThread();
                    twoFormExpander.setBottomText(Msg.search_scope.get());
                }
            };
        }
        twoFormExpander.setSashWidth(5);
        twoFormExpander.setSashWeights(SettingsConf.IntArray.FilterSash.get());
        if (SettingsConf.Bool.TypesFilterMaximized.get()) {
            twoFormExpander.setMaximizedControl(TwoFormExpander.MaximizedControl.TOP);
        }
        if (SettingsConf.Bool.LocationFilterMaximized.get()) {
            twoFormExpander.setMaximizedControl(TwoFormExpander.MaximizedControl.BOTTOM);
        }
        twoFormExpander.getFirstControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                UtilGui.runAsyncExec((Widget)twoFormExpander, new Runnable(){

                    @Override
                    public void run() {
                        TwoFormExpander.MaximizedControl maximizedControl = twoFormExpander.getMaximizedControl();
                        if (maximizedControl != TwoFormExpander.MaximizedControl.NONE) {
                            return;
                        }
                        int[] nArray = twoFormExpander.getSashWeights();
                        SettingsConf.IntArray.FilterSash.set(nArray);
                    }
                });
            }
        });
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.margin(0).left().top().right().applyTo((Control)toolBarForm);
        formDataFactory.top((Control)toolBarForm, 5).bottom().applyTo((Control)twoFormExpander);
        return composite2;
    }

    private static Control createRightTopPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        searchBar = new SearchBar(composite2, programConfFile);
        Application.searchBar.evtOKClicked.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                Application.saveSettingsConfFile();
            }
        });
        resultPanel = new ResultPanel(composite2);
        composite2.setLayout((Layout)new FormLayout());
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.margin(0).top().left().right().applyTo(searchBar.getControl());
        formDataFactory.top(searchBar.getControl()).bottom().applyTo((Control)resultPanel.getControl());
        Application.searchBar.evtHideInSystemTray.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                systemTrayHider.hide();
            }
        });
        Application.searchBar.evtOpenManual.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                Application.showManual();
            }
        });
        Application.resultPanel.evtSelection.add(new Event.Listener<List<ResultDocument>>(){

            @Override
            public void update(List<ResultDocument> list) {
                if (!list.isEmpty()) {
                    previewPanel.setPreview(list.get(0));
                }
            }
        });
        Application.resultPanel.evtHideInSystemTray.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                systemTrayHider.hide();
            }
        });
        return composite2;
    }

    private static void moveIndexingDialogToStatusBar(Rectangle rectangle) {
        indexingStatus.setVisible(true);
        Rectangle rectangle2 = indexingStatus.getBounds();
        rectangle2 = shell.getDisplay().map((Control)shell, null, rectangle2);
        MovingBox movingBox = new MovingBox(shell, rectangle, rectangle2, 0.2, 40L);
        movingBox.start();
    }

    private static void initSystemTrayHider() {
        systemTrayHider = new SystemTrayHider(shell);
        final ResultDocument[] resultDocumentArray = new ResultDocument[1];
        Application.systemTrayHider.evtHiding.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                resultDocumentArray[0] = previewPanel.clear();
            }
        });
        Application.systemTrayHider.evtRestored.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                if (resultDocumentArray[0] != null) {
                    previewPanel.setPreview(resultDocumentArray[0]);
                    resultDocumentArray[0] = null;
                }
                searchBar.setFocus();
            }
        });
        Application.systemTrayHider.evtShutdown.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                systemTrayShutdown = true;
                shell.close();
            }
        });
    }

    private static void initCocoaMenu(Display display) {
        if (!Util.IS_MAC_OS_X) {
            return;
        }
        CocoaUIEnhancer cocoaUIEnhancer = new CocoaUIEnhancer(ProgramConf.Str.AppName.get());
        cocoaUIEnhancer.hookApplicationMenu(display, new Listener(){

            public void handleEvent(Event event) {
                shell.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                String string = SystemConf.Str.ProgramName.get();
                String string2 = SystemConf.Str.ProgramVersion.get();
                AppUtil.showInfo(string + " " + string2);
            }
        }, new Runnable(){

            @Override
            public void run() {
                PrefDialog prefDialog = new PrefDialog(shell, programConfFile);
                prefDialog.evtOKClicked.add(new Event.Listener<Void>(this){

                    @Override
                    public void update(Void void_) {
                        Application.saveSettingsConfFile();
                    }
                });
                prefDialog.open();
            }
        });
    }

    private static void initThreePanelForm() {
        int n = SettingsConf.Int.FilterPanelWidth.get();
        threePanelForm = new ThreePanelForm((Composite)shell, n){

            @Override
            protected Control createFirstControl(Composite composite) {
                return Application.createLeftPanel(composite);
            }

            @Override
            protected Control createFirstSubControl(Composite composite) {
                return Application.createRightTopPanel(composite);
            }

            @Override
            protected Control createSecondSubControl(Composite composite) {
                previewPanel = new PreviewPanel(composite);
                Application.previewPanel.evtHideInSystemTray.add(new Event.Listener<Void>(this){

                    @Override
                    public void update(Void void_) {
                        systemTrayHider.hide();
                    }
                });
                Application.previewPanel.evtSaveSettings.add(new Event.Listener<Void>(this){

                    @Override
                    public void update(Void void_) {
                        Application.saveSettingsConfFile();
                    }
                });
                return previewPanel;
            }
        };
        threePanelForm.setSashWidth(5);
        threePanelForm.setSubSashWidth(5);
        threePanelForm.setFirstControlVisible(SettingsConf.Bool.ShowFilterPanel.get());
        threePanelForm.setSecondSubControlVisible(SettingsConf.Bool.ShowPreviewPanel.get());
        boolean bl = SettingsConf.Bool.ShowPreviewPanelAtBottom.get();
        threePanelForm.setVertical(bl);
        threePanelForm.setSubSashWeights(Application.getRightSashWeights(bl));
        Application.threePanelForm.evtFirstControlShown.add(new Event.Listener<Boolean>(){

            @Override
            public void update(Boolean bl) {
                SettingsConf.Bool.ShowFilterPanel.set(bl);
            }
        });
        final Control control = threePanelForm.getFirstControl();
        control.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (control.isVisible()) {
                    int n = control.getSize().x;
                    SettingsConf.Int.FilterPanelWidth.set(n);
                }
            }
        });
        final boolean[] blArray = new boolean[]{false};
        Control control2 = threePanelForm.getFirstSubControl();
        ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (!previewPanel.isVisible() || blArray[0]) {
                    return;
                }
                int[] nArray = threePanelForm.getSubSashWeights();
                if (threePanelForm.isVertical()) {
                    SettingsConf.IntArray.RightSashVertical.set(nArray);
                } else {
                    SettingsConf.IntArray.RightSashHorizontal.set(nArray);
                }
            }
        };
        control2.addControlListener((ControlListener)controlAdapter);
        previewPanel.addControlListener((ControlListener)controlAdapter);
        Application.threePanelForm.evtSecondSubControlShown.add(new Event.Listener<Boolean>(){

            @Override
            public void update(Boolean bl) {
                SettingsConf.Bool.ShowPreviewPanel.set(bl);
            }
        });
        Application.threePanelForm.evtSubOrientationChanging.add(new Event.Listener<Boolean>(){

            @Override
            public void update(Boolean bl) {
                blArray[0] = true;
            }
        });
        Application.threePanelForm.evtSubOrientationChanged.add(new Event.Listener<Boolean>(){

            @Override
            public void update(Boolean bl) {
                SettingsConf.Bool.ShowPreviewPanelAtBottom.set(bl);
                threePanelForm.setSubSashWeights(Application.getRightSashWeights(bl));
                blArray[0] = false;
            }
        });
    }

    private static int[] getRightSashWeights(boolean bl) {
        return bl ? SettingsConf.IntArray.RightSashVertical.get() : SettingsConf.IntArray.RightSashHorizontal.get();
    }

    private static void initStatusBar() {
        statusBar = new StatusBar((Composite)shell){

            @Override
            public List<StatusBar.StatusBarPart> createRightParts(StatusBar statusBar) {
                indexingStatus = new StatusBar.StatusBarPart(statusBar, true);
                indexingStatus.setContents(Img.INDEXING.get(), Msg.indexing.get());
                indexingStatus.setVisible(false);
                Application.indexPanel.evtIndexingDialogOpened.add(new Event.Listener<Void>(this){

                    @Override
                    public void update(Void void_) {
                        indexingStatus.setVisible(false);
                    }
                });
                Application.indexingStatus.evtClicked.add(new Event.Listener<Void>(this){

                    @Override
                    public void update(Void void_) {
                        indexPanel.openIndexingDialog();
                    }
                });
                StatusBar.StatusBarPart statusBarPart = new StatusBar.StatusBarPart(statusBar, false);
                statusBarPart.setContents(null, "<a>" + Msg.try_docfetcher_pro.get() + "</a>");
                statusBarPart.evtLinkClicked.add(new Event.Listener<Void>(this){

                    @Override
                    public void update(Void void_) {
                        UtilGui.launch("https://docfetcherpro.com/comparison/");
                        if (docfetcherProTip != null) {
                            Application.docfetcherProTip.shell.close();
                        }
                    }
                });
                ArrayList<StatusBar.StatusBarPart> arrayList = new ArrayList<StatusBar.StatusBarPart>(2);
                arrayList.add(indexingStatus);
                arrayList.add(statusBarPart);
                return arrayList;
            }
        };
    }

    private static void showDocFetcherProTip() {
        String string = Msg.docfetcher_pro_tip.get();
        String string2 = Msg.dont_show_msg_again.get();
        final HintOverlay hintOverlay = new HintOverlay(shell, string, string2);
        hintOverlay.evtLinkClicked.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                hintOverlay.shell.close();
            }
        });
        hintOverlay.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                SettingsConf.Bool.ShowDocFetcherProTip.set(false);
                docfetcherProTip = null;
            }
        });
        hintOverlay.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2) {
                    traverseEvent.doit = false;
                }
            }
        });
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Point point = hintOverlay.shell.getSize();
                List<StatusBar.StatusBarPart> list = statusBar.getRightParts();
                if (list.isEmpty()) {
                    return;
                }
                Control control = list.get(list.size() - 1).getControl();
                Rectangle rectangle = control.getBounds();
                rectangle = control.getDisplay().map((Control)control.getParent(), null, rectangle);
                Point point2 = new Point(rectangle.x + rectangle.width, rectangle.y);
                Point point3 = new Point(point2.x - point.x - 5, point2.y - point.y - 10);
                hintOverlay.shell.setLocation(point3);
            }
        };
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int n = Util.IS_WINDOWS ? 300 : 350;
                Point point = hintOverlay.shell.computeSize(n, -1);
                hintOverlay.shell.setSize(point);
                runnable.run();
                hintOverlay.open();
            }
        });
        final ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlMoved(ControlEvent controlEvent) {
                runnable.run();
            }

            public void controlResized(ControlEvent controlEvent) {
                runnable.run();
                shell.getDisplay().asyncExec(runnable);
            }
        };
        shell.addControlListener((ControlListener)controlAdapter);
        hintOverlay.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                shell.removeControlListener((ControlListener)controlAdapter);
            }
        });
        docfetcherProTip = hintOverlay;
    }

    private static void handleShellClosed(ShellEvent shellEvent) {
        if (SettingsConf.Bool.CloseToTray.get() && !systemTrayShutdown && !Util.IS_UBUNTU_UNITY) {
            shellEvent.doit = false;
            systemTrayHider.hide();
        } else {
            shellEvent.doit = indexRegistry.getQueue().shutdown(new Task.CancelHandler(){

                @Override
                public Task.CancelAction cancel() {
                    return Application.confirmExit();
                }
            });
            if (!shellEvent.doit) {
                return;
            }
            if (SettingsConf.Bool.ClearSearchHistoryOnExit.get()) {
                SettingsConf.StrList.SearchHistory.set(new String[0]);
            }
            new Thread(){

                @Override
                public void run() {
                    if (folderWatcher != null) {
                        folderWatcher.shutdown();
                    }
                    if (hotkeyHandler != null) {
                        hotkeyHandler.shutdown();
                    }
                    indexRegistry.getSearcher().shutdown();
                }
            }.start();
        }
    }

    private static void initHotkey() {
        int[] nArray;
        boolean bl;
        if (!ProgramConf.Bool.HotkeyEnabled.get()) {
            return;
        }
        boolean bl2 = SettingsConf.Bool.HotkeyEnabled.get();
        SettingsConf.Bool.HotkeyEnabled.set(false);
        Application.saveSettingsConfFile();
        try {
            hotkeyHandler = new HotkeyHandler();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        catch (Throwable throwable) {
            Util.printErr(throwable);
            return;
        }
        if (bl2 && !(bl = hotkeyHandler.registerHotkey((nArray = SettingsConf.IntArray.Hotkey.get())[0], nArray[1]))) {
            Application.handleHotkeyConflict(nArray);
        }
        SettingsConf.Bool.HotkeyEnabled.set(bl2);
        SettingsConf.IntArray.Hotkey.evtChanged.add(new Event.Listener<int[]>(){

            @Override
            public void update(int[] nArray) {
                boolean bl;
                hotkeyHandler.unregisterHotkey();
                if (SettingsConf.Bool.HotkeyEnabled.get() && !(bl = hotkeyHandler.registerHotkey(nArray[0], nArray[1]))) {
                    Application.handleHotkeyConflict(nArray);
                }
            }
        });
        SettingsConf.Bool.HotkeyEnabled.evtChanged.add(new Event.Listener<Boolean>(){

            @Override
            public void update(Boolean bl) {
                if (bl.booleanValue()) {
                    int[] nArray = SettingsConf.IntArray.Hotkey.get();
                    hotkeyHandler.registerHotkey(nArray[0], nArray[1]);
                } else {
                    hotkeyHandler.unregisterHotkey();
                }
            }
        });
        Application.hotkeyHandler.evtHotkeyPressed.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                UtilGui.runSyncExec((Widget)shell, new Runnable(this){

                    @Override
                    public void run() {
                        if (systemTrayHider.isHidden()) {
                            systemTrayHider.restore();
                        } else {
                            shell.setMinimized(false);
                            shell.setVisible(true);
                            shell.forceActive();
                            searchBar.setFocus();
                        }
                    }
                });
            }
        });
    }

    private static void handleHotkeyConflict(int[] nArray) {
        String string = UtilGui.toString(nArray);
        AppUtil.showError(Msg.hotkey_in_use.format(string), false, true);
        if (shell.isVisible()) {
            PrefDialog prefDialog = new PrefDialog(shell, programConfFile);
            prefDialog.evtOKClicked.add(new Event.Listener<Void>(){

                @Override
                public void update(Void void_) {
                    Application.saveSettingsConfFile();
                }
            });
            prefDialog.open();
        }
    }

    private static Task.CancelAction confirmExit() {
        MultipleChoiceDialog<Task.CancelAction> multipleChoiceDialog = new MultipleChoiceDialog<Task.CancelAction>(shell);
        multipleChoiceDialog.setTitle(Msg.abort_indexing.get());
        multipleChoiceDialog.setText(Msg.keep_partial_index_on_exit.get());
        if (shell.getDisplay().getDismissalAlignment() == 16384) {
            multipleChoiceDialog.addButton(Msg.keep.get(), Task.CancelAction.KEEP);
            multipleChoiceDialog.addButton(Msg.discard.get(), Task.CancelAction.DISCARD);
            multipleChoiceDialog.addButton(Msg.dont_exit.get(), null);
        } else {
            multipleChoiceDialog.addButton(Msg.dont_exit.get(), null);
            multipleChoiceDialog.addButton(Msg.discard.get(), Task.CancelAction.DISCARD);
            multipleChoiceDialog.addButton(Msg.keep.get(), Task.CancelAction.KEEP);
        }
        return (Task.CancelAction)((Object)multipleChoiceDialog.open());
    }

    private static void showManual() {
        File file = ManualLocator.getManualFile();
        if (file != null) {
            if (previewPanel.setHtmlFile(file)) {
                threePanelForm.setSecondSubControlVisible(true);
            } else {
                UtilGui.launch(file);
            }
        } else {
            String string = Msg.file_not_found.get() + "\n" + SystemConf.Str.ProgramName.get() + "_Manual.html";
            AppUtil.showError(string, true, true);
        }
    }

    private static void configureSwtLibraryPath(File file) {
        File file2 = file != null ? file : (AppUtil.isPortable() ? new File(AppUtil.getAppDataDir(), "lib/swt") : new File(AppUtil.getAppDataDir(), "swt"));
        file2.mkdirs();
        File file3 = file2.isDirectory() && file2.canWrite() ? file2 : new File(System.getProperty("java.io.tmpdir"));
        Application.unpackSwtNativeLibs(file3);
        try {
            System.setProperty("swt.library.path", file3.getCanonicalPath());
        }
        catch (IOException iOException) {
            System.setProperty("swt.library.path", file3.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void unpackSwtNativeLibs(File file) {
        String string;
        File file2;
        File file3 = file2 = Util.IS_MAC_OS_X && !AppUtil.isPortable() ? new File("../Resources/lib") : new File("lib");
        if (!file2.isDirectory()) {
            return;
        }
        File object2 = null;
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            for (File file4 : fileArray) {
                string = file4.getName();
                if (!string.startsWith("swt-") || !string.endsWith(".jar")) continue;
                object2 = file4;
                break;
            }
        }
        if (object2 == null) {
            return;
        }
        if (Util.IS_WINDOWS) {
            String string2 = ".dll";
        } else if (Util.IS_LINUX) {
            String string3 = ".so";
        } else if (Util.IS_MAC_OS_X) {
            String string4 = ".jnilib";
        } else {
            return;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(object2);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                File file5;
                void var4_8;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || (string = jarEntry.getName()).contains("/") || !string.endsWith((String)var4_8) || (file5 = new File(file, string)).exists() && file5.length() == jarEntry.getSize()) continue;
                Application.unpackJarEntry(jarFile, jarEntry, file5);
            }
        }
        catch (IOException iOException) {
            if (SystemConf.Bool.IsDevelopmentVersion.get()) {
                iOException.printStackTrace();
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void unpackJarEntry(JarFile jarFile, JarEntry jarEntry, File file) throws IOException {
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            if (!Util.IS_WINDOWS) {
                file.setExecutable(true);
            }
        }
    }

    public static IndexRegistry getIndexRegistry() {
        return indexRegistry;
    }

    static {
        systemTrayShutdown = false;
        indexRegistryLoaded = false;
    }
}

