/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

final class HintOverlay {
    public final Event<Void> evtLinkClicked = new Event();
    private static RGB bgDark = new RGB(99, 128, 99);
    private static RGB bgLight = new RGB(200, 255, 200);
    private static RGB fgLinkDark = new RGB(220, 220, 255);
    public final Shell shell;
    private final StyledText textField;
    private final Link link;
    private final List<Color> colors = new ArrayList<Color>(2);

    public HintOverlay(Shell shell, String string, String string2) {
        this.shell = new Shell(shell, 8);
        UtilGui.paintBorder((Control)this.shell);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                for (Color color : HintOverlay.this.colors) {
                    color.dispose();
                }
            }
        });
        this.textField = new StyledText((Composite)this.shell, 72);
        this.textField.setText(string);
        UtilGui.hideCaretAndSelection(this.textField);
        this.link = new Link((Composite)this.shell, 0);
        this.link.setText(String.format("<a href=\"\">%s</a>", string2));
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HintOverlay.this.evtLinkClicked.fire(null);
            }
        });
        this.setColors();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        this.shell.setLayout((Layout)gridLayout);
        this.textField.setLayoutData((Object)new GridData(4, 4, true, true));
        this.link.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public void open() {
        this.shell.open();
    }

    private void setColors() {
        for (Color color : this.colors) {
            color.dispose();
        }
        this.colors.clear();
        Display display = this.shell.getDisplay();
        boolean bl = UtilGui.isDarkTheme();
        Color color = new Color((Device)display, bl ? bgDark : bgLight);
        this.colors.add(color);
        this.shell.setBackground(color);
        this.textField.setBackground(color);
        UtilGui.setForegroundFromBackground((Control)this.textField);
        this.link.setBackground(color);
        if (bl) {
            Color color2 = new Color((Device)display, fgLinkDark);
            this.link.setLinkForeground(color2);
            this.colors.add(color2);
        } else {
            UtilGui.setLinkForeground(this.link, 36);
        }
    }
}

