/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.Locale;
import net.sourceforge.docfetcher.enums.SystemConf;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;

public final class ManualLocator {
    private ManualLocator() {
    }

    public static File getManualFile() {
        String string;
        if (SystemConf.Bool.IsDevelopmentVersion.get()) {
            string = "dist";
        } else if (AppUtil.isPortable() || Util.IS_WINDOWS || Util.IS_LINUX) {
            string = Util.USER_DIR_PATH;
        } else if (Util.IS_MAC_OS_X) {
            string = "../Resources";
        } else {
            throw new IllegalStateException();
        }
        File file = ManualLocator.getManualParentDir(string);
        if (file == null) {
            return null;
        }
        File[] fileArray = Util.listFiles(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && Util.hasExtension(file.getName(), "html", "htm");
            }
        });
        if (fileArray.length == 0) {
            return null;
        }
        return fileArray[0];
    }

    public static File getManualSubpageFile(String string) {
        File file = ManualLocator.getManualFile();
        if (file == null) {
            return null;
        }
        File file2 = Util.getParentFile(file);
        File[] fileArray = Util.listFiles(file2, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray.length == 0) {
            return null;
        }
        return new File(fileArray[0], string);
    }

    public static String getManualSubpageUrl(String string) {
        try {
            File file = ManualLocator.getManualSubpageFile(string);
            if (file == null) {
                return null;
            }
            return file.toURI().toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static File getManualParentDir(String string) {
        File file = new File(string, "help");
        String[] stringArray = new String[]{Locale.getDefault().getDisplayName(Locale.ENGLISH), new Locale(Locale.getDefault().getLanguage()).getDisplayName(Locale.ENGLISH), Locale.ENGLISH.getDisplayName(Locale.ENGLISH)};
        File[] fileArray = new File[3];
        block0: for (File file2 : Util.listFiles(file)) {
            if (!file2.isDirectory()) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!file2.getName().equals(stringArray[i])) continue;
                fileArray[i] = file2;
                continue block0;
            }
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == null) continue;
            return fileArray[i];
        }
        return null;
    }
}

