/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class MovingBox {
    private static final int bw = 2;
    private final Thread thread;
    private final Shell movingBox;
    private volatile double progress = 0.0;
    private Region region;

    public MovingBox(final Shell shell, Rectangle rectangle, Rectangle rectangle2, final double d, final long l) {
        this.movingBox = new Shell(shell, 65544);
        this.movingBox.setBackground(Col.DARK_GRAY.get());
        this.updateRegion(rectangle);
        this.movingBox.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MovingBox.this.region.dispose();
            }
        });
        final Vector vector = new Vector(rectangle.x, rectangle.y);
        final Vector vector2 = new Vector(rectangle2.x, rectangle2.y);
        final Vector vector3 = new Vector(vector.x + rectangle.width, vector.y + rectangle.height);
        final Vector vector4 = new Vector(vector2.x + rectangle2.width, vector2.y + rectangle2.height);
        this.thread = new Thread(MovingBox.class.getSimpleName()){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    MovingBox.this.progress = MovingBox.this.progress * (1.0 - d) + d;
                    if (MovingBox.this.progress > 0.95) break;
                    Vector vector5 = MovingBox.this.m(vector, vector2);
                    Vector vector22 = MovingBox.this.m(vector3, vector4);
                    final Rectangle rectangle = new Rectangle(vector5.x, vector5.y, vector22.x - vector5.x, vector22.y - vector5.y);
                    UtilGui.runSyncExec((Widget)shell, new Runnable(){

                        @Override
                        public void run() {
                            MovingBox.this.updateRegion(rectangle);
                        }
                    });
                }
                UtilGui.runSyncExec((Widget)shell, new Runnable(){

                    @Override
                    public void run() {
                        MovingBox.this.movingBox.dispose();
                    }
                });
            }
        };
        this.movingBox.open();
    }

    public void start() {
        this.thread.start();
    }

    private Vector m(Vector vector, Vector vector2) {
        return new Vector(this.m(vector.x, vector2.x), this.m(vector.y, vector2.y));
    }

    private int m(int n, int n2) {
        return (int)Math.round((double)n + (double)(n2 - n) * this.progress);
    }

    private void updateRegion(Rectangle rectangle) {
        this.movingBox.setBounds(rectangle);
        if (this.region != null) {
            this.region.dispose();
        }
        this.region = new Region();
        this.region.add(new int[]{0, 0, rectangle.width, 0, rectangle.width, rectangle.height, 0, rectangle.height});
        this.region.subtract(new int[]{2, 2, rectangle.width - 2, 2, rectangle.width - 2, rectangle.height - 2, 2, rectangle.height - 2});
        this.movingBox.setRegion(this.region);
    }

    private static class Vector {
        private final int x;
        private final int y;

        public Vector(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }
}

