/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.gui.ResultPanel;
import net.sourceforge.docfetcher.gui.SearchBar;
import net.sourceforge.docfetcher.gui.StatusBar;
import net.sourceforge.docfetcher.gui.filter.FileTypePanel;
import net.sourceforge.docfetcher.gui.filter.FilesizePanel;
import net.sourceforge.docfetcher.gui.filter.IndexPanel;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.TreeCheckState;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.model.search.PhraseDetectingQueryParser;
import net.sourceforge.docfetcher.model.search.ResultDocument;
import net.sourceforge.docfetcher.model.search.SearchException;
import net.sourceforge.docfetcher.model.search.Searcher;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.ListMap;
import org.apache.lucene.queryparser.classic.ParseException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

public final class SearchQueue {
    private static final String spaces = Strings.repeat((String)" ", (int)5);
    private final SearchBar searchBar;
    private final FilesizePanel filesizePanel;
    private final FileTypePanel fileTypePanel;
    private final IndexPanel indexPanel;
    private final ResultPanel resultPanel;
    private final StatusBar statusBar;
    private final Thread thread;
    private final Lock lock = new ReentrantLock(true);
    private final Condition queueNotEmpty = this.lock.newCondition();
    private final EnumSet<GuiEvent> queue = EnumSet.noneOf(GuiEvent.class);
    private volatile String query;
    private volatile Set<String> listDocIds;
    private List<ResultDocument> results;
    private Set<String> checkedParsers;
    private TreeCheckState treeCheckState;
    private boolean allParsersChecked;

    public SearchQueue(SearchBar searchBar, FilesizePanel filesizePanel, FileTypePanel fileTypePanel, IndexPanel indexPanel, ResultPanel resultPanel, StatusBar statusBar) {
        Util.checkNotNull(searchBar, filesizePanel, fileTypePanel);
        Util.checkNotNull(indexPanel, resultPanel, (Object)statusBar);
        this.searchBar = searchBar;
        this.filesizePanel = filesizePanel;
        this.fileTypePanel = fileTypePanel;
        this.indexPanel = indexPanel;
        this.resultPanel = resultPanel;
        this.statusBar = statusBar;
        resultPanel.evtSelection.add(new Event.Listener<List<ResultDocument>>(){

            @Override
            public void update(List<ResultDocument> list) {
                SearchQueue.this.updateResultStatus();
            }
        });
        this.thread = new Thread(SearchQueue.class.getName()){

            @Override
            public void run() {
                while (SearchQueue.this.threadLoop()) {
                }
            }
        };
        this.thread.start();
        this.initListeners();
    }

    private void initListeners() {
        this.searchBar.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SearchQueue.this.thread.interrupt();
            }
        });
        this.searchBar.evtSearch.add(new Event.Listener<String>(){

            @Override
            public void update(String string) {
                SearchQueue.this.lock.lock();
                try {
                    SearchQueue.this.indexPanel.getIndexRegistry().getSearcher().stopSearch();
                    SearchQueue.this.query = string;
                    SearchQueue.this.searchBar.setEnabled(false);
                    SearchQueue.this.queue.add(GuiEvent.SEARCH_OR_LIST);
                    SearchQueue.this.queue.add(GuiEvent.EXPLICIT_SEARCH);
                    SearchQueue.this.queueNotEmpty.signal();
                }
                finally {
                    SearchQueue.this.lock.unlock();
                }
            }
        });
        this.searchBar.evtSearchTypeAhead.add(new Event.Listener<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(String string) {
                String string2 = string + "*";
                try {
                    PhraseDetectingQueryParser phraseDetectingQueryParser = new PhraseDetectingQueryParser(Fields.CONTENT.key(), IndexRegistry.getAnalyzer());
                    phraseDetectingQueryParser.parse(string2);
                }
                catch (ParseException parseException) {
                    return;
                }
                SearchQueue.this.lock.lock();
                try {
                    SearchQueue.this.query = string2;
                    if (SearchQueue.this.queue.contains((Object)GuiEvent.EXPLICIT_SEARCH)) {
                        return;
                    }
                    SearchQueue.this.indexPanel.getIndexRegistry().getSearcher().stopSearch();
                    SearchQueue.this.queue.add(GuiEvent.SEARCH_OR_LIST);
                    SearchQueue.this.queue.add(GuiEvent.TYPE_AHEAD);
                    SearchQueue.this.queueNotEmpty.signal();
                }
                finally {
                    SearchQueue.this.lock.unlock();
                }
            }
        });
        this.filesizePanel.evtValuesChanged.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                SearchQueue.this.lock.lock();
                try {
                    SearchQueue.this.queue.add(GuiEvent.SIZE);
                    SearchQueue.this.queueNotEmpty.signal();
                }
                finally {
                    SearchQueue.this.lock.unlock();
                }
            }
        });
        this.fileTypePanel.evtCheckStatesChanged.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                SearchQueue.this.lock.lock();
                try {
                    SearchQueue.this.queue.add(GuiEvent.TYPE);
                    SearchQueue.this.queueNotEmpty.signal();
                }
                finally {
                    SearchQueue.this.lock.unlock();
                }
            }
        });
        this.indexPanel.evtCheckStatesChanged.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                SearchQueue.this.lock.lock();
                try {
                    SearchQueue.this.queue.add(GuiEvent.LOCATION);
                    SearchQueue.this.queueNotEmpty.signal();
                }
                finally {
                    SearchQueue.this.lock.unlock();
                }
            }
        });
        this.indexPanel.evtListDocuments.add(new Event.Listener<Set<String>>(){

            @Override
            public void update(Set<String> set) {
                SearchQueue.this.lock.lock();
                try {
                    SearchQueue.this.listDocIds = set;
                    SearchQueue.this.queue.add(GuiEvent.SEARCH_OR_LIST);
                    SearchQueue.this.queueNotEmpty.signal();
                }
                finally {
                    SearchQueue.this.lock.unlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean threadLoop() {
        Long[] longArray;
        IndexRegistry indexRegistry;
        String string;
        EnumSet<GuiEvent> enumSet;
        block21: {
            Set<String> set;
            this.lock.lock();
            try {
                while (this.queue.isEmpty()) {
                    this.queueNotEmpty.await();
                }
                enumSet = EnumSet.copyOf(this.queue);
                this.queue.clear();
                string = this.query;
                set = this.listDocIds;
                this.query = null;
                this.listDocIds = null;
            }
            catch (InterruptedException interruptedException) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
            indexRegistry = this.indexPanel.getIndexRegistry();
            if (enumSet.contains((Object)GuiEvent.SEARCH_OR_LIST)) {
                try {
                    longArray = indexRegistry.getSearcher();
                    if (longArray == null) {
                        return false;
                    }
                    if (string != null) {
                        this.results = longArray.search(string);
                        break block21;
                    }
                    if (set != null) {
                        this.results = longArray.list(set);
                        break block21;
                    }
                    throw new IllegalStateException();
                }
                catch (SearchException searchException) {
                    AppUtil.showError(searchException.getMessage(), true, true);
                    UtilGui.runSyncExec((Widget)this.searchBar.getControl(), new Runnable(){

                        @Override
                        public void run() {
                            SearchQueue.this.searchBar.setEnabled(true);
                        }
                    });
                    this.results = null;
                }
                catch (CheckedOutOfMemoryError checkedOutOfMemoryError) {
                    UtilGui.showOutOfMemoryMessage(this.searchBar.getControl(), checkedOutOfMemoryError);
                }
            }
        }
        if (this.checkedParsers == null || enumSet.contains((Object)GuiEvent.TYPE)) {
            UtilGui.runSyncExec((Widget)this.fileTypePanel.getControl(), new Runnable(){

                @Override
                public void run() {
                    SearchQueue.this.updateParserFilter();
                }
            });
        }
        if (this.treeCheckState == null || enumSet.contains((Object)GuiEvent.LOCATION)) {
            this.treeCheckState = indexRegistry.getTreeCheckState();
        }
        if (this.results == null) {
            return true;
        }
        longArray = this.filesizePanel.getValuesInKB();
        final ArrayList<ResultDocument> arrayList = new ArrayList<ResultDocument>();
        for (ResultDocument resultDocument : this.results) {
            String string2;
            if (longArray != null) {
                long l = resultDocument.getSizeInKB();
                if (longArray[0] != null && l < longArray[0] || longArray[1] != null && l > longArray[1]) continue;
            }
            if (!resultDocument.isEmail() && (this.checkedParsers.isEmpty() || !this.allParsersChecked && !this.checkedParsers.contains(string2 = resultDocument.getParserName())) || !this.treeCheckState.isChecked(resultDocument.getParentPath())) continue;
            arrayList.add(resultDocument);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (LuceneIndex luceneIndex : indexRegistry.getIndexes()) {
            if (luceneIndex.isEmailIndex()) {
                bl2 = true;
                continue;
            }
            bl = true;
        }
        Object object = ResultPanel.HeaderMode.getInstance(bl, bl2);
        UtilGui.runSyncExec((Widget)this.searchBar.getControl(), new Runnable(){
            final /* synthetic */ ResultPanel.HeaderMode val$mode;
            final /* synthetic */ EnumSet val$queueCopy;
            final /* synthetic */ String val$query;
            {
                this.val$mode = headerMode;
                this.val$queueCopy = enumSet;
                this.val$query = string;
            }

            @Override
            public void run() {
                SearchQueue.this.resultPanel.setResults(arrayList, this.val$mode);
                SearchQueue.this.resultPanel.sortByColumn(ProgramConf.Int.InitialSorting.get());
                if (this.val$queueCopy.contains((Object)GuiEvent.SEARCH_OR_LIST) && this.val$queueCopy.contains((Object)GuiEvent.EXPLICIT_SEARCH)) {
                    SearchQueue.this.resultPanel.getControl().setFocus();
                }
                SearchQueue.this.updateResultStatus();
                SearchQueue.this.searchBar.setEnabled(true);
                if (this.val$queueCopy.contains((Object)GuiEvent.EXPLICIT_SEARCH) && this.val$query != null) {
                    SearchQueue.this.searchBar.addToSearchHistory(this.val$query);
                }
            }
        });
        return true;
    }

    private void updateParserFilter() {
        ListMap<Parser, Boolean> listMap = this.fileTypePanel.getParserStateMap();
        this.checkedParsers = Sets.newHashSetWithExpectedSize((int)listMap.size());
        for (ListMap.Entry<Parser, Boolean> entry : listMap) {
            if (!entry.getValue().booleanValue()) continue;
            String string = entry.getKey().getClass().getSimpleName();
            this.checkedParsers.add(string);
        }
        this.allParsersChecked = this.checkedParsers.size() == listMap.size();
    }

    private void updateResultStatus() {
        int n;
        int n2 = this.resultPanel.getItemCount();
        Object object = Msg.num_results.format(n2);
        if (n2 >= Searcher.MAX_RESULTS) {
            object = (String)object + "+";
        }
        if ((n = this.resultPanel.getSelection().size()) > 1) {
            object = (String)object + spaces + Msg.num_sel_results.format(n);
        }
        this.statusBar.getLeftPart().setContents(Img.INFO.get(), (String)object);
    }

    private static enum GuiEvent {
        SEARCH_OR_LIST,
        SIZE,
        TYPE,
        LOCATION,
        TYPE_AHEAD,
        EXPLICIT_SEARCH;

    }
}

