/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.filter;

public enum FilesizeUnit {
    Byte(0),
    KB(1),
    MB(2),
    GB(3);

    private final int e;

    private FilesizeUnit(int n2) {
        this.e = n2;
    }

    public Long convert(Long l, FilesizeUnit filesizeUnit) {
        if (l == null) {
            return null;
        }
        int n = filesizeUnit.e - this.e;
        if (n == 0) {
            return l;
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                l = l * 1024L;
            }
            return l;
        }
        int n2 = 1024;
        for (int i = 1; i < -n; ++i) {
            n2 *= 1024;
        }
        return Math.round((double)l.longValue() / (double)n2);
    }

    public static String[] valuesAsStrings() {
        FilesizeUnit[] filesizeUnitArray = FilesizeUnit.values();
        String[] stringArray = new String[filesizeUnitArray.length];
        for (int i = 0; i < filesizeUnitArray.length; ++i) {
            stringArray[i] = filesizeUnitArray[i].toString();
        }
        return stringArray;
    }
}

