/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.filter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.docfetcher.UtilGlobal;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.MultiFileLauncher;
import net.sourceforge.docfetcher.gui.indexing.IndexingDialog;
import net.sourceforge.docfetcher.gui.indexing.SingletonDialogFactory;
import net.sourceforge.docfetcher.model.Folder;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.TreeIndex;
import net.sourceforge.docfetcher.model.ViewNode;
import net.sourceforge.docfetcher.model.index.IndexingQueue;
import net.sourceforge.docfetcher.model.index.Task;
import net.sourceforge.docfetcher.model.index.file.FileIndex;
import net.sourceforge.docfetcher.model.index.outlook.OutlookIndex;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.AlphanumComparator;
import net.sourceforge.docfetcher.util.gui.ContextMenuManager;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import net.sourceforge.docfetcher.util.gui.dialog.InputLoop;
import net.sourceforge.docfetcher.util.gui.dialog.TextInputDialog;
import net.sourceforge.docfetcher.util.gui.viewer.SimpleTreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class IndexPanel {
    public final Event<Void> evtCheckStatesChanged = new Event();
    public final Event<Set<String>> evtListDocuments = new Event();
    public final Event<Rectangle> evtIndexingDialogMinimized = new Event();
    public final Event<Void> evtIndexingDialogOpened = new Event();
    private final SimpleTreeViewer<ViewNode> viewer;
    private final Tree tree;
    private final IndexRegistry indexRegistry;
    private final DialogFactory dialogFactory;
    private final Set<ViewNode> nodesToBeAdded = new HashSet<ViewNode>();
    private MenuAction updateIndexAction;
    private MenuAction removeIndexAction;
    private MenuAction renameIndexAction;

    public IndexPanel(Composite composite, final IndexRegistry indexRegistry) {
        Util.checkNotNull(composite, indexRegistry);
        this.indexRegistry = indexRegistry;
        this.dialogFactory = new DialogFactory(composite.getShell()){

            @Override
            protected IndexingDialog createDialog(Shell shell) {
                IndexingDialog indexingDialog = new IndexingDialog(shell, indexRegistry);
                indexingDialog.evtDialogMinimized.add(new Event.Listener<Rectangle>(){

                    @Override
                    public void update(Rectangle rectangle) {
                        IndexPanel.this.evtIndexingDialogMinimized.fire(rectangle);
                    }
                });
                return indexingDialog;
            }
        };
        this.dialogFactory.evtDialogOpened.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                IndexPanel.this.evtIndexingDialogOpened.fire(void_);
            }
        });
        final Comparator<ViewNode> comparator = new Comparator<ViewNode>(this){

            @Override
            public int compare(ViewNode viewNode, ViewNode viewNode2) {
                return AlphanumComparator.ignoreCaseInstance.compare(viewNode.getDisplayName(), viewNode2.getDisplayName());
            }
        };
        this.viewer = new SimpleTreeViewer<ViewNode>(composite, 2082){

            @Override
            protected Iterable<ViewNode> getChildren(ViewNode viewNode) {
                return Iterables.filter(viewNode.getChildren(), (Predicate)new Predicate<ViewNode>(){

                    public boolean apply(ViewNode viewNode) {
                        return !IndexPanel.this.nodesToBeAdded.contains(viewNode);
                    }
                });
            }

            @Override
            protected String getLabel(ViewNode viewNode) {
                return viewNode.getDisplayName();
            }

            @Override
            protected boolean isChecked(ViewNode viewNode) {
                return viewNode.isChecked();
            }

            @Override
            protected void setChecked(ViewNode viewNode, boolean bl) {
                IndexPanel.this.setCheckedRecursively(viewNode, bl);
                IndexPanel.this.setCheckedRecursively(IndexPanel.this.viewer.getItem(viewNode), bl);
                IndexPanel.this.evtCheckStatesChanged.fire(null);
            }

            @Override
            protected void sort(List<ViewNode> list) {
                Collections.sort(list, comparator);
            }
        };
        this.tree = this.viewer.getControl();
        Folder.evtFolderAdding.add(new Event.Listener<Folder.FolderEvent>(){

            @Override
            public void update(final Folder.FolderEvent folderEvent) {
                UtilGui.runSwtSafe((Widget)IndexPanel.this.tree, new Runnable(){

                    @Override
                    public void run() {
                        IndexPanel.this.nodesToBeAdded.add(folderEvent.folder);
                    }
                });
            }
        });
        Folder.evtFolderAdded.add(new Event.Listener<Folder.FolderEvent>(){

            @Override
            public void update(final Folder.FolderEvent folderEvent) {
                UtilGui.runSwtSafe((Widget)IndexPanel.this.tree, new Runnable(){

                    @Override
                    public void run() {
                        if (folderEvent.parent.getParent() == null) {
                            for (ViewNode viewNode : IndexPanel.this.viewer.getElements()) {
                                if (!(viewNode instanceof LuceneIndex) || ((LuceneIndex)viewNode).getRootFolder() != folderEvent.parent) continue;
                                IndexPanel.this.viewer.add(viewNode, folderEvent.folder);
                                break;
                            }
                        } else {
                            IndexPanel.this.viewer.add(folderEvent.parent, folderEvent.folder);
                        }
                        IndexPanel.this.nodesToBeAdded.remove(folderEvent.folder);
                    }
                });
            }
        });
        Folder.evtFolderRemoved.add(new Event.Listener<Folder.FolderEvent>(){

            @Override
            public void update(final Folder.FolderEvent folderEvent) {
                UtilGui.runSwtSafe((Widget)IndexPanel.this.tree, new Runnable(){

                    @Override
                    public void run() {
                        IndexPanel.this.viewer.remove(folderEvent.folder);
                    }
                });
            }
        });
        indexRegistry.addListeners(new IndexRegistry.ExistingIndexesHandler(){

            @Override
            public void handleExistingIndexes(List<LuceneIndex> list) {
                for (LuceneIndex luceneIndex : list) {
                    IndexPanel.this.viewer.addRoot(luceneIndex);
                }
            }
        }, new Event.Listener<LuceneIndex>(){

            @Override
            public void update(final LuceneIndex luceneIndex) {
                UtilGui.runAsyncExec((Widget)IndexPanel.this.tree, new Runnable(){

                    @Override
                    public void run() {
                        IndexPanel.this.viewer.addRoot(luceneIndex);
                        IndexPanel.this.evtCheckStatesChanged.fire(null);
                    }
                });
            }
        }, new Event.Listener<List<LuceneIndex>>(){

            @Override
            public void update(final List<LuceneIndex> list) {
                UtilGui.runAsyncExec((Widget)IndexPanel.this.tree, new Runnable(){

                    @Override
                    public void run() {
                        IndexPanel.this.viewer.remove(UtilGlobal.convert(list));
                    }
                });
            }
        });
        this.initContextMenu();
        this.initAccelerators();
    }

    private void initContextMenu() {
        ViewNode[] viewNodeArray;
        Menu menu;
        ContextMenuManager contextMenuManager = new ContextMenuManager((Control)this.tree);
        if (ProgramConf.Bool.AllowIndexCreation.get()) {
            menu = contextMenuManager.addSubmenu(new MenuAction(Msg.create_index_from.get()));
            contextMenuManager.add(menu, new MenuAction(Img.FOLDER.get(), Msg.folder.get()){

                @Override
                public void run() {
                    IndexPanel.createFileTaskFromDialog(IndexPanel.this.tree.getShell(), IndexPanel.this.indexRegistry, IndexPanel.this.dialogFactory, true);
                }
            });
            contextMenuManager.addSeparator(menu);
            contextMenuManager.add(menu, new MenuAction(Img.PACKAGE.get(), Msg.archive.get()){

                @Override
                public void run() {
                    IndexPanel.createFileTaskFromDialog(IndexPanel.this.tree.getShell(), IndexPanel.this.indexRegistry, IndexPanel.this.dialogFactory, false);
                }
            });
            contextMenuManager.add(menu, new MenuAction(Img.EMAIL.get(), Msg.outlook_pst.get()){

                @Override
                public void run() {
                    IndexPanel.createOutlookTaskFromDialog(IndexPanel.this.tree.getShell(), IndexPanel.this.indexRegistry, IndexPanel.this.dialogFactory);
                }
            });
            viewNodeArray = Util.IS_MAC_OS_X ? Msg.clipboard_macosx.get() : Msg.clipboard.get();
            contextMenuManager.add(menu, new MenuAction(Img.CLIPBOARD.get(), (String)viewNodeArray){

                @Override
                public void run() {
                    IndexPanel.createTaskFromClipboard(IndexPanel.this.tree.getShell(), IndexPanel.this.indexRegistry, IndexPanel.this.dialogFactory);
                }
            });
        }
        if (ProgramConf.Bool.AllowIndexUpdate.get() || ProgramConf.Bool.AllowIndexRebuild.get()) {
            contextMenuManager.addSeparatorIfNonEmpty();
            class UpdateOrRebuildAction
            extends MenuAction {
                private final boolean isUpdate;

                public UpdateOrRebuildAction(String string, boolean bl) {
                    super(string);
                    this.isUpdate = bl;
                }

                @Override
                public boolean isEnabled() {
                    return IndexPanel.this.isOnlyIndexesSelected();
                }

                @Override
                public void run() {
                    IndexingQueue indexingQueue = IndexPanel.this.indexRegistry.getQueue();
                    Task.IndexAction indexAction = this.isUpdate ? Task.IndexAction.UPDATE : Task.IndexAction.REBUILD;
                    List<LuceneIndex> list = IndexPanel.this.getSelectedIndexes();
                    IndexPanel.this.dialogFactory.open();
                    for (LuceneIndex luceneIndex : list) {
                        indexingQueue.addTask(luceneIndex, indexAction);
                    }
                }
            }
            this.updateIndexAction = new UpdateOrRebuildAction(Msg.update_index.get(), true);
            if (ProgramConf.Bool.AllowIndexUpdate.get()) {
                contextMenuManager.add(this.updateIndexAction);
            }
            if (ProgramConf.Bool.AllowIndexRebuild.get()) {
                contextMenuManager.add(new UpdateOrRebuildAction(Msg.rebuild_index.get(), false));
            }
        }
        class RenameIndexAction
        extends MenuAction {
            public RenameIndexAction(String string) {
                super(string);
            }

            @Override
            public boolean isEnabled() {
                return IndexPanel.this.viewer.getSelection().size() == 1 && IndexPanel.this.isOnlyIndexesSelected();
            }

            @Override
            public void run() {
                List<LuceneIndex> list = IndexPanel.this.getSelectedIndexes();
                LuceneIndex luceneIndex = list.get(0);
                TextInputDialog textInputDialog = new TextInputDialog(IndexPanel.this.tree.getShell(), Msg.rename_index_title.get(), Msg.rename_index_msg.get(), luceneIndex.getRootFolder().getDisplayName());
                String string = textInputDialog.open();
                if (string != null) {
                    if (string.trim().isEmpty()) {
                        String string2 = Msg.empty_name.get();
                        AppUtil.showError(string2, true, true);
                        IndexPanel.this.renameIndexAction.run();
                    } else {
                        luceneIndex.getRootFolder().setDisplayName(string);
                        IndexPanel.this.indexRegistry.save(luceneIndex);
                        IndexPanel.this.viewer.update();
                    }
                }
            }
        }
        this.renameIndexAction = new RenameIndexAction(Msg.rename_index_context.get());
        if (ProgramConf.Bool.AllowIndexRenaming.get()) {
            contextMenuManager.addSeparatorIfNonEmpty();
            contextMenuManager.add(this.renameIndexAction);
        }
        if (ProgramConf.Bool.AllowIndexDeletion.get()) {
            contextMenuManager.addSeparatorIfNonEmpty();
            this.removeIndexAction = new MenuAction(Msg.remove_index.get()){

                @Override
                public boolean isEnabled() {
                    return IndexPanel.this.isOnlyIndexesSelected();
                }

                @Override
                public void run() {
                    List<LuceneIndex> list = IndexPanel.this.getSelectedIndexes();
                    assert (!list.isEmpty());
                    if (AppUtil.showConfirmation(Msg.remove_sel_indexes.get(), false)) {
                        IndexPanel.this.indexRegistry.removeIndexes(list, true);
                    }
                }
            };
            contextMenuManager.add(this.removeIndexAction);
            contextMenuManager.add(new MenuAction(Msg.remove_orphaned_indexes.get()){

                @Override
                public boolean isEnabled() {
                    return IndexPanel.this.tree.getItemCount() > 0;
                }

                @Override
                public void run() {
                    List<LuceneIndex> list = IndexPanel.this.indexRegistry.getIndexes();
                    ArrayList<LuceneIndex> arrayList = new ArrayList<LuceneIndex>(list.size());
                    for (LuceneIndex luceneIndex : list) {
                        if (luceneIndex.getCanonicalRootFile().exists()) continue;
                        arrayList.add(luceneIndex);
                    }
                    if (arrayList.isEmpty()) {
                        return;
                    }
                    String string = Msg.remove_orphaned_indexes_msg.get();
                    if (AppUtil.showConfirmation(string, false)) {
                        IndexPanel.this.indexRegistry.removeIndexes(arrayList, true);
                    }
                }
            });
        }
        contextMenuManager.addSeparatorIfNonEmpty();
        class CheckAllAction
        extends MenuAction {
            private final boolean checkAll;

            public CheckAllAction(boolean bl) {
                super(bl ? Msg.check_all.get() : Msg.uncheck_all.get());
                this.checkAll = bl;
            }

            @Override
            public boolean isEnabled() {
                return IndexPanel.this.tree.getItemCount() > 0;
            }

            @Override
            public void run() {
                for (ViewNode viewNode : IndexPanel.this.viewer.getRoots()) {
                    IndexPanel.this.setCheckedRecursively(viewNode, this.checkAll);
                    IndexPanel.this.setCheckedRecursively(IndexPanel.this.viewer.getItem(viewNode), this.checkAll);
                }
                IndexPanel.this.evtCheckStatesChanged.fire(null);
            }
        }
        contextMenuManager.add(new CheckAllAction(true));
        contextMenuManager.add(new CheckAllAction(false));
        contextMenuManager.add(new MenuAction(Msg.check_single.get()){

            @Override
            public boolean isEnabled() {
                return !IndexPanel.this.viewer.getSelection().isEmpty();
            }

            @Override
            public void run() {
                boolean bl = true;
                List<ViewNode> list = IndexPanel.this.viewer.getSelection();
                for (ViewNode viewNode : list) {
                    if (viewNode.isChecked()) continue;
                    bl = false;
                    break;
                }
                for (ViewNode viewNode : list) {
                    viewNode.setChecked(!bl);
                    IndexPanel.this.viewer.getItem(viewNode).setChecked(!bl);
                }
                IndexPanel.this.evtCheckStatesChanged.fire(null);
            }
        });
        contextMenuManager.addSeparator();
        contextMenuManager.add(new MenuAction(Msg.open_folder.get()){

            @Override
            public boolean isEnabled() {
                return !IndexPanel.this.viewer.getSelection().isEmpty();
            }

            @Override
            public void run() {
                MultiFileLauncher multiFileLauncher = new MultiFileLauncher();
                for (ViewNode viewNode : IndexPanel.this.viewer.getSelection()) {
                    File file;
                    ViewNode viewNode2;
                    if (viewNode instanceof LuceneIndex) {
                        viewNode2 = (LuceneIndex)viewNode;
                        file = viewNode2.getCanonicalRootFile();
                        if (!file.exists()) {
                            multiFileLauncher.addMissing(file);
                            continue;
                        }
                        multiFileLauncher.addFile(file);
                        continue;
                    }
                    viewNode2 = (Folder)viewNode;
                    file = ((Folder)((Folder)viewNode2).getRoot()).getPath().getCanonicalFile();
                    if (!file.exists()) {
                        multiFileLauncher.addMissing(file);
                        continue;
                    }
                    multiFileLauncher.addFile(IndexPanel.getNearestFile(viewNode2));
                }
                multiFileLauncher.launch();
            }
        });
        contextMenuManager.add(new MenuAction(Msg.list_docs.get()){

            @Override
            public boolean isEnabled() {
                return !IndexPanel.this.viewer.getSelection().isEmpty();
            }

            @Override
            public void run() {
                List<ViewNode> list = IndexPanel.this.viewer.getSelection();
                HashSet<String> hashSet = new HashSet<String>();
                for (ViewNode viewNode : list) {
                    hashSet.addAll(viewNode.getDocumentIds());
                }
                IndexPanel.this.evtListDocuments.fire(hashSet);
            }
        });
        menu = this.tree.getMenu();
        viewNodeArray = new ViewNode[]{null};
        final Event.Listener<Folder.FolderEvent> listener = new Event.Listener<Folder.FolderEvent>(){

            @Override
            public void update(Folder.FolderEvent folderEvent) {
                if (folderEvent == null) {
                    return;
                }
                if (folderEvent.folder != viewNodeArray[0]) {
                    return;
                }
                UtilGui.runSwtSafe((Widget)IndexPanel.this.tree, new Runnable(){

                    @Override
                    public void run() {
                        menu.setVisible(false);
                    }
                });
            }
        };
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Display display = IndexPanel.this.tree.getDisplay();
                Point point = display.getCursorLocation();
                point = display.map(null, (Control)IndexPanel.this.tree, point);
                viewNodeArray[0] = IndexPanel.this.viewer.getElement(point);
                if (viewNodeArray[0] != null) {
                    Folder.evtFolderRemoved.add(listener);
                }
            }

            public void menuHidden(MenuEvent menuEvent) {
                Folder.evtFolderRemoved.remove(listener);
            }
        });
    }

    private void initAccelerators() {
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000E) {
                    if (IndexPanel.this.updateIndexAction != null && IndexPanel.this.updateIndexAction.isEnabled() && ProgramConf.Bool.AllowIndexUpdate.get()) {
                        IndexPanel.this.updateIndexAction.run();
                    }
                } else if (keyEvent.keyCode == 0x100000B) {
                    if (IndexPanel.this.renameIndexAction != null && IndexPanel.this.renameIndexAction.isEnabled() && ProgramConf.Bool.AllowIndexUpdate.get()) {
                        IndexPanel.this.renameIndexAction.run();
                    }
                } else if (keyEvent.stateMask == SWT.MOD1 && keyEvent.keyCode == 118) {
                    if (ProgramConf.Bool.AllowIndexCreation.get()) {
                        IndexPanel.createTaskFromClipboard(IndexPanel.this.tree.getShell(), IndexPanel.this.indexRegistry, IndexPanel.this.dialogFactory);
                    }
                } else if (keyEvent.keyCode == 127 && IndexPanel.this.removeIndexAction != null && IndexPanel.this.removeIndexAction.isEnabled() && ProgramConf.Bool.AllowIndexDeletion.get()) {
                    IndexPanel.this.removeIndexAction.run();
                }
            }
        });
    }

    private boolean isOnlyIndexesSelected() {
        List<ViewNode> list = this.viewer.getSelection();
        if (list.isEmpty()) {
            return false;
        }
        for (ViewNode viewNode : list) {
            if (viewNode.isIndex()) continue;
            return false;
        }
        return true;
    }

    private List<LuceneIndex> getSelectedIndexes() {
        List<ViewNode> list = this.viewer.getSelection();
        ArrayList<LuceneIndex> arrayList = new ArrayList<LuceneIndex>(list.size());
        for (ViewNode viewNode : list) {
            if (!viewNode.isIndex()) continue;
            arrayList.add((LuceneIndex)viewNode);
        }
        return arrayList;
    }

    private void setCheckedRecursively(ViewNode viewNode, boolean bl) {
        viewNode.setChecked(bl);
        for (ViewNode viewNode2 : viewNode.getChildren()) {
            this.setCheckedRecursively(viewNode2, bl);
        }
    }

    private void setCheckedRecursively(TreeItem treeItem, boolean bl) {
        treeItem.setChecked(bl);
        for (TreeItem treeItem2 : treeItem.getItems()) {
            this.setCheckedRecursively(treeItem2, bl);
        }
    }

    private static File getNearestFile(Folder<?, ?> folder) {
        File file = folder.getPath().getCanonicalFile();
        if (file.exists()) {
            return file;
        }
        Object obj = folder.getParent();
        if (obj == null) {
            return file;
        }
        return IndexPanel.getNearestFile(obj);
    }

    public Tree getControl() {
        return this.tree;
    }

    public IndexRegistry getIndexRegistry() {
        return this.indexRegistry;
    }

    public static boolean createFileTaskFromDialog(final Shell shell, final IndexRegistry indexRegistry, final DialogFactory dialogFactory, final boolean bl) {
        Object t;
        String string = SettingsConf.Str.LastIndexedFolder.get().trim();
        if (string.isEmpty() || !new File(string).isDirectory()) {
            string = SettingsConf.Str.LastIndexedFolder.defaultValue;
        }
        return (t = new InputLoop<Object>(){

            @Override
            protected String getNewValue(String string) {
                if (bl) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(shell);
                    directoryDialog.setText(Msg.select_folder_title.get());
                    directoryDialog.setMessage(Msg.select_folder_msg.get());
                    directoryDialog.setFilterPath(string);
                    return directoryDialog.open();
                }
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setText(Msg.select_archive_title.get());
                fileDialog.setFilterPath(string);
                return fileDialog.open();
            }

            @Override
            protected String getDenyMessage(String string) {
                File file;
                File file2 = indexRegistry.getIndexParentDir();
                String string2 = IndexPanel.checkIndexDirOverlap(file2, file = new File(string));
                if (string2 != null) {
                    return string2;
                }
                FileIndex fileIndex = new FileIndex(file2, file);
                IndexingQueue.Rejection rejection = indexRegistry.getQueue().addTask(fileIndex, Task.IndexAction.CREATE);
                if (rejection == null) {
                    return null;
                }
                return IndexPanel.getMessage(rejection);
            }

            @Override
            protected Object onAccept(String string) {
                String string2 = Util.getSystemAbsPath(string);
                if (!bl) {
                    string2 = new File(string2).getParent();
                }
                SettingsConf.Str.LastIndexedFolder.set(string2);
                if (dialogFactory != null) {
                    dialogFactory.open();
                }
                return new Object();
            }
        }.run(string)) != null;
    }

    public static boolean createOutlookTaskFromDialog(final Shell shell, final IndexRegistry indexRegistry, final DialogFactory dialogFactory) {
        Object object;
        File file;
        String string = SettingsConf.Str.LastIndexedFolder.get().trim();
        if (string.isEmpty() || !new File(string).isDirectory()) {
            string = SettingsConf.Str.LastIndexedFolder.defaultValue;
        }
        if ((file = IndexPanel.getOutlookPSTFile()) != null && AppUtil.showConfirmation(object = Msg.found_pst_file.format(file.getPath()), false)) {
            string = file.getPath();
        }
        return (object = new InputLoop<Object>(){

            @Override
            protected String getNewValue(String string) {
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setText(Msg.select_outlook_pst_title.get());
                fileDialog.setFilterNames(new String[]{"Outlook Personal Storage Table (*.pst, *.ost)"});
                if (!string.equals("")) {
                    fileDialog.setFilterPath(string);
                }
                return fileDialog.open();
            }

            @Override
            protected String getDenyMessage(String string) {
                File file;
                File file2 = indexRegistry.getIndexParentDir();
                String string2 = IndexPanel.checkIndexDirOverlap(file2, file = new File(string));
                if (string2 != null) {
                    return string2;
                }
                OutlookIndex outlookIndex = new OutlookIndex(file2, file);
                IndexingQueue.Rejection rejection = indexRegistry.getQueue().addTask(outlookIndex, Task.IndexAction.CREATE);
                if (rejection == null) {
                    return null;
                }
                return IndexPanel.getMessage(rejection);
            }

            @Override
            protected Void onAccept(String string) {
                String string2 = Util.getSystemAbsPath(string);
                string2 = new File(string2).getParent();
                SettingsConf.Str.LastIndexedFolder.set(string2);
                if (dialogFactory != null) {
                    dialogFactory.open();
                }
                return null;
            }
        }.run(string)) != null;
    }

    private static File getOutlookPSTFile() {
        if (!Util.IS_WINDOWS) {
            return null;
        }
        String string = Shell32Util.getFolderPath((int)28);
        String string2 = Util.joinPath(string, "Microsoft/Outlook/Outlook.pst", new String[0]);
        File file = new File(string2);
        return file.isFile() ? file : null;
    }

    public static void createTaskFromClipboard(Shell shell, IndexRegistry indexRegistry, DialogFactory dialogFactory) {
        File file;
        List<File> list = UtilGui.getFilesFromClipboard();
        if (list == null) {
            AppUtil.showError(Msg.no_files_in_cb.get(), true, true);
            return;
        }
        if (list.isEmpty()) {
            throw new IllegalStateException();
        }
        File file2 = indexRegistry.getIndexParentDir();
        String string = IndexPanel.checkIndexDirOverlap(file2, file = list.get(0));
        if (string != null) {
            AppUtil.showError(string, true, true);
            return;
        }
        TreeIndex treeIndex = Util.hasExtension(file.getName(), "pst") ? new OutlookIndex(file2, file) : new FileIndex(file2, file);
        IndexingQueue.Rejection rejection = indexRegistry.getQueue().addTask(treeIndex, Task.IndexAction.CREATE);
        if (rejection != null) {
            AppUtil.showError(IndexPanel.getMessage(rejection), true, true);
        } else if (dialogFactory != null) {
            dialogFactory.open();
        }
    }

    public void openIndexingDialog() {
        this.dialogFactory.open();
    }

    private static String getMessage(IndexingQueue.Rejection rejection) {
        switch (rejection) {
            case OVERLAP_WITH_REGISTRY: 
            case OVERLAP_WITH_QUEUE: 
            case SAME_IN_REGISTRY: 
            case SAME_IN_QUEUE: {
                return Msg.overlaps_not_allowed.get();
            }
        }
        return "";
    }

    private static String checkIndexDirOverlap(File file, File file2) {
        if (Util.isCanonicallyEqual(file, file2) || Util.contains(file, file2)) {
            return Msg.overlap_with_index_dir.get();
        }
        return null;
    }

    private static abstract class DialogFactory
    extends SingletonDialogFactory<IndexingDialog> {
        public DialogFactory(Shell shell) {
            super(shell);
        }
    }
}

