/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.util.Collection;
import java.util.List;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.indexing.ConfigPanel;
import net.sourceforge.docfetcher.gui.indexing.FileExtensionGroupWrapper;
import net.sourceforge.docfetcher.gui.indexing.IndexNameGroupWrapper;
import net.sourceforge.docfetcher.gui.indexing.PatternTable;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.LazyList;
import net.sourceforge.docfetcher.util.gui.GroupWrapper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

final class FileConfigPanel
extends ConfigPanel {
    private IndexNameGroupWrapper indexGroupWrapper;
    private FileExtensionGroupWrapper extGroupWrapper;
    private PatternTable patternTable;
    private Button htmlPairingBt;
    private Button detectExecArchivesBt;
    private Button indexFilenameBt;
    private Button storeRelativePathsBt;
    private Button watchFolderBt;

    public FileConfigPanel(Composite composite, LuceneIndex luceneIndex) {
        super(composite, luceneIndex, true);
    }

    @Override
    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.indexGroupWrapper = new IndexNameGroupWrapper(composite2, this.index);
        this.extGroupWrapper = new FileExtensionGroupWrapper(composite2, this.index);
        Group group = this.extGroupWrapper.getGroup();
        Group group2 = new GroupWrapper(composite2, Msg.exclude_files_detect_mime_type.get()){

            @Override
            protected void createLayout(Group group) {
                group.setLayout((Layout)UtilGui.createFillLayout(5));
            }

            @Override
            protected void createContents(Group group) {
                FileConfigPanel.this.patternTable = new PatternTable((Composite)group, FileConfigPanel.this.index);
            }
        }.getGroup();
        Group group3 = new GroupWrapper(composite2, Msg.miscellaneous.get()){

            @Override
            protected void createLayout(Group group) {
                group.setLayout((Layout)UtilGui.createGridLayout(1, false, 3, 3));
            }

            @Override
            protected void createContents(Group group) {
                FileConfigPanel.this.createMiscGroupContents(group);
            }
        }.getGroup();
        GridLayout gridLayout = UtilGui.createGridLayout(1, false, 0, 10);
        gridLayout.marginTop = 5;
        composite2.setLayout((Layout)gridLayout);
        UtilGui.setGridData((Control)group, false);
        UtilGui.setGridData((Control)group2, false);
        UtilGui.setGridData((Control)group3, false);
        return composite2;
    }

    private void createMiscGroupContents(Group group) {
        this.htmlPairingBt = UtilGui.createCheckButton((Composite)group, Msg.index_html_pairs.get());
        this.detectExecArchivesBt = UtilGui.createCheckButton((Composite)group, Msg.detect_exec_archives.get());
        this.indexFilenameBt = UtilGui.createCheckButton((Composite)group, Msg.index_filenames.get());
        this.storeRelativePathsBt = UtilGui.createCheckButton((Composite)group, Msg.store_relative_paths.get());
        this.watchFolderBt = UtilGui.createCheckButton((Composite)group, Msg.watch_folders.get());
        IndexingConfig indexingConfig = this.index.getConfig();
        this.htmlPairingBt.setSelection(indexingConfig.isHtmlPairing());
        this.detectExecArchivesBt.setSelection(indexingConfig.isDetectExecutableArchives());
        this.indexFilenameBt.setSelection(indexingConfig.isIndexFilenames());
        this.watchFolderBt.setSelection(indexingConfig.isWatchFolders());
        boolean bl = indexingConfig.isStoreRelativePaths();
        this.patternTable.setStoreRelativePaths(bl);
        this.storeRelativePathsBt.setSelection(bl);
        this.storeRelativePathsBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileConfigPanel.this.onStoreRelativePathsButtonClicked();
            }
        });
    }

    private void onStoreRelativePathsButtonClicked() {
        this.patternTable.setStoreRelativePaths(this.storeRelativePathsBt.getSelection());
        if (!SettingsConf.Bool.ShowRelativePathsMessage.get()) {
            return;
        }
        for (PatternAction patternAction : this.patternTable.getPatternActions()) {
            if (patternAction.getTarget() != PatternAction.MatchTarget.PATH) continue;
            AppUtil.showInfo(Msg.changing_store_relative_paths_setting.get());
            SettingsConf.Bool.ShowRelativePathsMessage.set(false);
            break;
        }
    }

    @Override
    protected boolean writeToConfig() {
        String string = this.indexGroupWrapper.getName();
        if (string.trim().isEmpty()) {
            String string2 = Msg.empty_name.get();
            AppUtil.showError(string2, true, true);
            return false;
        }
        List<PatternAction> list = this.patternTable.getPatternActions();
        for (PatternAction object2 : list) {
            if (object2.validateRegex()) continue;
            String object3 = object2.getRegex();
            String string5 = Msg.malformed_regex.format(object3);
            AppUtil.showError(string5, true, true);
            return false;
        }
        Collection<String> collection = this.extGroupWrapper.getTextExtensions();
        if (!this.confirmExtensionOverride(collection, Msg.confirm_text_ext, new String[0])) {
            return false;
        }
        Collection<String> collection2 = this.extGroupWrapper.getZipExtensions();
        for (String string2 : collection2) {
            if (!string2.matches("\\d.*")) continue;
            AppUtil.showError(Msg.zip_ext_digits.format(string2), true, true);
            return false;
        }
        if (!this.confirmExtensionOverride(collection2, Msg.confirm_zip_ext, "7z", "rar")) {
            return false;
        }
        IndexingConfig indexingConfig = this.index.getConfig();
        this.index.getRootFolder().setDisplayName(string);
        indexingConfig.setTextExtensions(collection);
        indexingConfig.setZipExtensions(collection2);
        indexingConfig.setPatternActions(list);
        indexingConfig.setHtmlPairing(this.htmlPairingBt.getSelection());
        indexingConfig.setDetectExecutableArchives(this.detectExecArchivesBt.getSelection());
        indexingConfig.setIndexFilenames(this.indexFilenameBt.getSelection());
        indexingConfig.setStoreRelativePaths(this.storeRelativePathsBt.getSelection());
        indexingConfig.setWatchFolders(this.watchFolderBt.getSelection());
        indexingConfig.setSkipTarArchives(ProgramConf.Bool.SkipTarArchives.get());
        return true;
    }

    private boolean confirmExtensionOverride(Collection<String> collection, Msg msg, String ... stringArray) {
        LazyList lazyList = new LazyList();
        Object object = collection.iterator();
        block0: while (object.hasNext()) {
            String string = object.next();
            if (ParseService.isBuiltInExtension(this.index.getConfig(), string) && !lazyList.contains(string)) {
                lazyList.add(string);
            }
            string = string.toLowerCase();
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                if (lazyList.contains(string)) continue block0;
                lazyList.add(string);
                continue block0;
            }
        }
        return lazyList.isEmpty() || AppUtil.showConfirmation((String)(object = msg.format(Util.join(", ", lazyList))), true);
    }

    @Override
    protected void restoreDefaults() {
        IndexingConfig indexingConfig = this.index.getConfig();
        this.indexGroupWrapper.setName(Util.getDefaultIndexName(this.index.getCanonicalRootFile()));
        this.extGroupWrapper.setTextExtensions(indexingConfig.getTextExtensions());
        this.extGroupWrapper.setZipExtensions(indexingConfig.getZipExtensions());
        this.patternTable.restoreDefaults();
        this.htmlPairingBt.setSelection(indexingConfig.isHtmlPairing());
        this.detectExecArchivesBt.setSelection(indexingConfig.isDetectExecutableArchives());
        this.indexFilenameBt.setSelection(indexingConfig.isIndexFilenames());
        this.storeRelativePathsBt.setSelection(indexingConfig.isStoreRelativePaths());
        this.watchFolderBt.setSelection(indexingConfig.isWatchFolders());
    }
}

