/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.AlphanumComparator;
import net.sourceforge.docfetcher.util.collect.ListMap;
import net.sourceforge.docfetcher.util.gui.Col;
import net.sourceforge.docfetcher.util.gui.ContextMenuManager;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

final class FileExtensionChooser {
    private final Factory factory;
    private final Shell shell;
    private final Table table;
    private final Composite comp;
    private final StackLayout stackLayout;
    private final Button okBt;
    private Thread thread;
    private ListMap<String, Boolean> output;

    private FileExtensionChooser(Factory factory) {
        this.factory = factory;
        this.shell = new Shell(factory.parentShell, 36080);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(Msg.select_exts.get());
        this.comp = new Composite((Composite)this.shell, 0);
        this.stackLayout = new StackLayout();
        this.comp.setLayout((Layout)this.stackLayout);
        this.table = new Table(this.comp, 34848);
        Composite composite = new Composite(this.comp, 2048);
        composite.setBackground(Col.LIST_BACKGROUND.get());
        composite.setLayout((Layout)UtilGui.createFillLayout(5));
        StyledText styledText = new StyledText(composite, 74);
        styledText.setBackground(Col.LIST_BACKGROUND.get());
        styledText.setText(Msg.loading.get());
        styledText.getCaret().setVisible(false);
        this.stackLayout.topControl = composite;
        this.okBt = new Button((Composite)this.shell, 8);
        this.okBt.setText(Msg.ok.get());
        Button button = new Button((Composite)this.shell, 8);
        button.setText(Msg.cancel.get());
        Button[] buttonArray = UtilGui.maybeSwapButtons(this.okBt, button);
        this.shell.setLayout((Layout)UtilGui.createFormLayout(5));
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.top().left().right().applyTo((Control)label);
        formDataFactory.reset().minWidth(75).bottom().right().applyTo((Control)buttonArray[1]);
        formDataFactory.right((Control)buttonArray[1]).applyTo((Control)buttonArray[0]);
        formDataFactory.reset().left().right().top((Control)label).bottom((Control)buttonArray[0]).applyTo((Control)this.comp);
        this.okBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileExtensionChooser.this.output = ListMap.create(FileExtensionChooser.this.table.getItemCount());
                for (TableItem tableItem : FileExtensionChooser.this.table.getItems()) {
                    FileExtensionChooser.this.output.add(tableItem.getText(), tableItem.getChecked());
                }
                FileExtensionChooser.this.shell.close();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileExtensionChooser.this.shell.close();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                if (FileExtensionChooser.this.thread != null) {
                    FileExtensionChooser.this.thread.interrupt();
                }
            }
        });
        this.initContextMenu();
    }

    private void initContextMenu() {
        ContextMenuManager contextMenuManager = new ContextMenuManager((Control)this.table);
        class CheckAllAction
        extends MenuAction {
            private final boolean value;

            private CheckAllAction(boolean bl) {
                super(bl ? Msg.check_all.get() : Msg.uncheck_all.get());
                this.value = bl;
            }

            @Override
            public void run() {
                for (TableItem tableItem : FileExtensionChooser.this.table.getItems()) {
                    tableItem.setChecked(this.value);
                }
            }
        }
        contextMenuManager.add(new CheckAllAction(true));
        contextMenuManager.add(new CheckAllAction(false));
        contextMenuManager.addSeparator();
        contextMenuManager.add(new MenuAction(Msg.invert_selection.get()){

            @Override
            public void run() {
                for (TableItem tableItem : FileExtensionChooser.this.table.getItems()) {
                    tableItem.setChecked(!tableItem.getChecked());
                }
            }
        });
    }

    public ListMap<String, Boolean> open(final Collection<String> collection) throws FileNotFoundException {
        Util.checkNotNull(collection);
        UtilGui.assertSwtThread();
        if (!this.factory.rootDir.isDirectory()) {
            throw new FileNotFoundException();
        }
        if (this.factory.cachedExtensions != null) {
            this.showExtensions(collection);
        } else {
            this.okBt.setEnabled(false);
            this.thread = new Thread(FileExtensionChooser.class.getSimpleName()){

                @Override
                public void run() {
                    final Set<String> set = FileExtensionChooser.listExtensions(FileExtensionChooser.this.factory.rootDir);
                    if (Util.isInterrupted()) {
                        return;
                    }
                    UtilGui.runAsyncExec((Widget)FileExtensionChooser.this.table, new Runnable(){

                        @Override
                        public void run() {
                            if (FileExtensionChooser.this.factory.cachedExtensions == null) {
                                FileExtensionChooser.this.factory.cachedExtensions = set;
                            }
                            FileExtensionChooser.this.showExtensions(collection);
                            FileExtensionChooser.this.okBt.setEnabled(true);
                        }
                    });
                }
            };
            this.thread.start();
        }
        SettingsConf.ShellBounds.FileExtensionChooser.bind(this.shell);
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.output;
    }

    private void showExtensions(Collection<String> collection) {
        UtilGui.assertSwtThread();
        for (String string : this.factory.cachedExtensions) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(string);
            if (!collection.contains(string)) continue;
            tableItem.setChecked(true);
        }
        this.stackLayout.topControl = this.table;
        this.comp.layout();
    }

    private static Set<String> listExtensions(File file) {
        TreeSet<String> treeSet = new TreeSet<String>(AlphanumComparator.ignoreCaseInstance);
        FileExtensionChooser.listExtensions(treeSet, file);
        return treeSet;
    }

    private static void listExtensions(Set<String> set, File file) {
        for (File file2 : Util.listFiles(file)) {
            if (Util.isInterrupted()) {
                return;
            }
            if (file2.isFile()) {
                String string = Util.getExtension(file2);
                if (string.trim().equals("") || string.length() + 1 == file2.getName().length()) continue;
                set.add(string);
                continue;
            }
            if (!file2.isDirectory()) continue;
            if (ProgramConf.Bool.IgnoreJunctionsAndSymlinks.get()) {
                if (Util.isJunctionOrSymlink(file2)) continue;
                FileExtensionChooser.listExtensions(set, file2);
                continue;
            }
            FileExtensionChooser.listExtensions(set, file2);
        }
    }

    public static final class Factory {
        private final Shell parentShell;
        private final File rootDir;
        private Set<String> cachedExtensions;

        public Factory(Shell shell, File file) {
            Util.checkNotNull(shell, file);
            this.parentShell = shell;
            this.rootDir = file;
        }

        public FileExtensionChooser createChooser() {
            return new FileExtensionChooser(this);
        }
    }
}

