/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.GroupWrapper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class IndexNameGroupWrapper {
    private Text indexNameField;
    private final LuceneIndex index;
    private final GroupWrapper groupWrapper;

    public IndexNameGroupWrapper(Composite composite, LuceneIndex luceneIndex) {
        this.index = luceneIndex;
        this.groupWrapper = new GroupWrapper(composite, Msg.index_name.get()){

            @Override
            protected void createLayout(Group group) {
                IndexNameGroupWrapper.this.createLayout(group);
            }

            @Override
            protected void createContents(Group group) {
                IndexNameGroupWrapper.this.createContents(group);
            }
        };
    }

    public Group getGroup() {
        return this.groupWrapper.getGroup();
    }

    private void createLayout(Group group) {
        GridLayout gridLayout = UtilGui.createGridLayout(1, false, 7, 0);
        gridLayout.verticalSpacing = 5;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createContents(Group group) {
        File file = this.index.getCanonicalRootFile();
        String string = Util.getDefaultIndexName(file);
        this.indexNameField = this.createNameField((Composite)group, string);
    }

    private Text createNameField(Composite composite, String string) {
        Text text = UtilGui.createUnlabeledGridText(composite);
        text.setText(string);
        return text;
    }

    public String getName() {
        return this.indexNameField.getText();
    }

    public void setName(String string) {
        this.indexNameField.setText(string);
    }
}

