/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import java.util.List;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.filter.IndexPanel;
import net.sourceforge.docfetcher.gui.indexing.ConfigPanel;
import net.sourceforge.docfetcher.gui.indexing.FileConfigPanel;
import net.sourceforge.docfetcher.gui.indexing.OutlookConfigPanel;
import net.sourceforge.docfetcher.gui.indexing.ProgressPanel;
import net.sourceforge.docfetcher.gui.indexing.ProgressReporter;
import net.sourceforge.docfetcher.gui.indexing.SingletonDialogFactory;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.DelegatingReporter;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingQueue;
import net.sourceforge.docfetcher.model.index.Task;
import net.sourceforge.docfetcher.model.index.file.FileIndex;
import net.sourceforge.docfetcher.model.index.outlook.OutlookIndex;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.DropDownMenuManager;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import net.sourceforge.docfetcher.util.gui.TabFolderFactory;
import net.sourceforge.docfetcher.util.gui.ToolItemFactory;
import net.sourceforge.docfetcher.util.gui.dialog.MultipleChoiceDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class IndexingDialog
implements SingletonDialogFactory.Dialog {
    public final Event<Rectangle> evtDialogMinimized = new Event();
    private final Shell shell;
    private final CTabFolder tabFolder;
    private final IndexRegistry indexRegistry;
    private boolean childDialogOpen = false;
    private Event.Listener<Task> addedListener;
    private Event.Listener<Task> removedListener;

    public IndexingDialog(Shell shell, IndexRegistry indexRegistry) {
        Util.checkNotNull(shell, indexRegistry);
        this.indexRegistry = indexRegistry;
        int n = 34032;
        this.shell = new Shell(shell, n);
        this.shell.setText(Msg.indexing_queue.get());
        this.shell.setImage(Img.INDEXING_DIALOG.get());
        this.shell.setLayout((Layout)UtilGui.createFillLayout(5));
        this.shell.setMinimumSize(455, 560);
        SettingsConf.ShellBounds.IndexingDialog.bind(this.shell);
        this.tabFolder = TabFolderFactory.create((Composite)this.shell, true, true, false);
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        this.tabFolder.setTopRight((Control)toolBar);
        this.initToolBarMenu(toolBar);
        toolBar.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IndexingDialog.this.tabFolder.forceFocus();
            }
        });
        this.initEventHandlers();
    }

    private void initToolBarMenu(ToolBar toolBar) {
        ToolItemFactory toolItemFactory = new ToolItemFactory(toolBar);
        if (ProgramConf.Bool.AllowIndexCreation.get()) {
            final ToolItem toolItem = toolItemFactory.image(Img.ADD.get()).toolTip(Msg.add_to_queue.get()).create();
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DropDownMenuManager dropDownMenuManager = new DropDownMenuManager(toolItem, (Control)IndexingDialog.this.tabFolder);
                    abstract class ChildDialogAction
                    extends MenuAction {
                        public ChildDialogAction(Image image, String string) {
                            super(image, string);
                        }

                        @Override
                        public final void run() {
                            assert (!IndexingDialog.this.childDialogOpen);
                            IndexingDialog.this.childDialogOpen = true;
                            boolean bl = this.doRun();
                            IndexingDialog.this.childDialogOpen = false;
                            if (!bl && IndexingDialog.this.tabFolder.getItemCount() == 0) {
                                IndexingDialog.this.indexRegistry.getQueue().removeListeners(IndexingDialog.this.addedListener, IndexingDialog.this.removedListener);
                                IndexingDialog.this.shell.dispose();
                            }
                        }

                        protected abstract boolean doRun();
                    }
                    dropDownMenuManager.add(new ChildDialogAction(Img.FOLDER.get(), Msg.add_folder.get()){
                        {
                            super(image, string);
                        }

                        @Override
                        public boolean doRun() {
                            return IndexPanel.createFileTaskFromDialog(IndexingDialog.this.shell, IndexingDialog.this.indexRegistry, null, true);
                        }
                    });
                    dropDownMenuManager.addSeparator();
                    dropDownMenuManager.add(new ChildDialogAction(Img.PACKAGE.get(), Msg.add_archive.get()){
                        {
                            super(image, string);
                        }

                        @Override
                        public boolean doRun() {
                            return IndexPanel.createFileTaskFromDialog(IndexingDialog.this.shell, IndexingDialog.this.indexRegistry, null, false);
                        }
                    });
                    dropDownMenuManager.add(new ChildDialogAction(Img.EMAIL.get(), Msg.add_outlook_pst.get()){
                        {
                            super(image, string);
                        }

                        @Override
                        public boolean doRun() {
                            return IndexPanel.createOutlookTaskFromDialog(IndexingDialog.this.shell, IndexingDialog.this.indexRegistry, null);
                        }
                    });
                    dropDownMenuManager.add(new MenuAction(Img.CLIPBOARD.get(), Msg.add_from_clipboard.get()){

                        @Override
                        public void run() {
                            IndexPanel.createTaskFromClipboard(IndexingDialog.this.shell, IndexingDialog.this.indexRegistry, null);
                        }
                    });
                    dropDownMenuManager.show();
                }
            });
        }
        toolItemFactory.image(Img.HIDE.get()).toolTip(Msg.minimize_to_status_bar.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = IndexingDialog.this.shell.getBounds();
                IndexingDialog.this.shell.setVisible(false);
                IndexingDialog.this.evtDialogMinimized.fire(rectangle);
            }
        }).create();
    }

    private void initEventHandlers() {
        this.addedListener = new Event.Listener<Task>(){

            @Override
            public void update(final Task task) {
                assert (!IndexingDialog.this.shell.isDisposed());
                UtilGui.runSwtSafe((Widget)IndexingDialog.this.tabFolder, new Runnable(){

                    @Override
                    public void run() {
                        boolean bl = task.is(Task.IndexAction.UPDATE);
                        boolean bl2 = IndexingDialog.this.tabFolder.getItemCount() == 0;
                        IndexingDialog.this.addTab(task, !bl || bl2);
                    }
                });
            }
        };
        this.removedListener = new Event.Listener<Task>(){

            @Override
            public void update(final Task task) {
                if (IndexingDialog.this.shell.isDisposed()) {
                    return;
                }
                UtilGui.runSwtSafe((Widget)IndexingDialog.this.tabFolder, new Runnable(){

                    @Override
                    public void run() {
                        for (CTabItem cTabItem : IndexingDialog.this.tabFolder.getItems()) {
                            if (cTabItem.getData() != task) continue;
                            cTabItem.dispose();
                            break;
                        }
                        if (!IndexingDialog.this.childDialogOpen && IndexingDialog.this.tabFolder.getItemCount() == 0) {
                            IndexingDialog.this.indexRegistry.getQueue().removeListeners(IndexingDialog.this.addedListener, IndexingDialog.this.removedListener);
                            IndexingDialog.this.shell.dispose();
                        }
                    }
                });
            }
        };
        this.indexRegistry.getQueue().addListeners(new IndexingQueue.ExistingTasksHandler(){

            @Override
            public void handleExistingTasks(List<Task> list) {
                boolean bl = IndexingDialog.this.tabFolder.getItemCount() == 0;
                for (Task task : list) {
                    IndexingDialog.this.addTab(task, bl);
                    bl = false;
                }
            }
        }, this.addedListener, this.removedListener);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(final ShellEvent shellEvent) {
                IndexingDialog.this.indexRegistry.getQueue().removeAll(new Task.CancelHandler(){

                    @Override
                    public Task.CancelAction cancel() {
                        Task.CancelAction cancelAction = IndexingDialog.this.confirmCancel();
                        shellEvent.doit = cancelAction != null;
                        return cancelAction;
                    }
                }, IndexingDialog.this.addedListener, IndexingDialog.this.removedListener);
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(final CTabFolderEvent cTabFolderEvent) {
                if (IndexingDialog.this.tabFolder.getItemCount() == 1) {
                    cTabFolderEvent.doit = false;
                    IndexingDialog.this.shell.close();
                    return;
                }
                Task task = (Task)cTabFolderEvent.item.getData();
                task.remove(new Task.CancelHandler(){

                    @Override
                    public Task.CancelAction cancel() {
                        Task.CancelAction cancelAction = IndexingDialog.this.confirmCancel();
                        cTabFolderEvent.doit = cancelAction != null;
                        return cancelAction;
                    }
                });
            }
        });
    }

    private Task.CancelAction confirmCancel() {
        MultipleChoiceDialog<Task.CancelAction> multipleChoiceDialog = new MultipleChoiceDialog<Task.CancelAction>(this.shell);
        multipleChoiceDialog.setTitle(Msg.abort_indexing.get());
        multipleChoiceDialog.setText(Msg.keep_partial_index.get());
        if (this.shell.getDisplay().getDismissalAlignment() == 16384) {
            multipleChoiceDialog.addButton(Msg.keep.get(), Task.CancelAction.KEEP);
            multipleChoiceDialog.addButton(Msg.discard.get(), Task.CancelAction.DISCARD);
            multipleChoiceDialog.addButton(Msg.dont_abort.get(), null);
        } else {
            multipleChoiceDialog.addButton(Msg.dont_abort.get(), null);
            multipleChoiceDialog.addButton(Msg.discard.get(), Task.CancelAction.DISCARD);
            multipleChoiceDialog.addButton(Msg.keep.get(), Task.CancelAction.KEEP);
        }
        return (Task.CancelAction)((Object)multipleChoiceDialog.open());
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    private void addTab(final Task task, boolean bl) {
        final CTabItem cTabItem = new CTabItem(this.tabFolder, 64);
        cTabItem.setData((Object)task);
        LuceneIndex luceneIndex = task.getLuceneIndex();
        File file = luceneIndex.getCanonicalRootFile();
        cTabItem.setText(Util.getDefaultIndexName(file));
        cTabItem.setToolTipText(Util.getSystemAbsPath(file));
        if (task.is(Task.TaskState.READY)) {
            cTabItem.setImage(Img.TREE.get());
        } else {
            cTabItem.setImage(Img.CHECK.get());
        }
        cTabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Control control = cTabItem.getControl();
                if (control != null) {
                    control.dispose();
                }
            }
        });
        final IndexingConfig indexingConfig = luceneIndex.getConfig();
        if (task.is(Task.IndexAction.UPDATE) || !task.is(Task.TaskState.NOT_READY)) {
            this.switchToProgressPanel(task, cTabItem, indexingConfig);
        } else {
            ConfigPanel configPanel;
            if (luceneIndex instanceof FileIndex) {
                configPanel = new FileConfigPanel((Composite)this.tabFolder, luceneIndex);
            } else if (luceneIndex instanceof OutlookIndex) {
                configPanel = new OutlookConfigPanel((Composite)this.tabFolder, luceneIndex);
            } else {
                throw new IllegalStateException();
            }
            cTabItem.setControl(configPanel.getControl());
            configPanel.getControl().setFocus();
            configPanel.evtRunButtonClicked.add(new Event.Listener<Void>(){

                @Override
                public void update(Void void_) {
                    cTabItem.setImage(Img.TREE.get());
                    configPanel.getControl().dispose();
                    IndexingDialog.this.switchToProgressPanel(task, cTabItem, indexingConfig);
                    task.setReady();
                    for (CTabItem cTabItem2 : IndexingDialog.this.tabFolder.getItems()) {
                        Task task2 = (Task)cTabItem2.getData();
                        if (task2.is(Task.TaskState.READY)) continue;
                        IndexingDialog.this.tabFolder.setSelection(cTabItem2);
                        break;
                    }
                }
            });
        }
        if (bl) {
            this.tabFolder.setSelection(cTabItem);
        }
    }

    private void switchToProgressPanel(final Task task, final CTabItem cTabItem, IndexingConfig indexingConfig) {
        ProgressPanel progressPanel = new ProgressPanel((Composite)this.tabFolder);
        cTabItem.setControl(progressPanel.getControl());
        Path path = task.getLuceneIndex().getIndexDirPath();
        File file = null;
        if (path != null) {
            file = path.getCanonicalFile();
        }
        final ProgressReporter progressReporter = new ProgressReporter(progressPanel, file);
        task.attachReporter(progressReporter, new DelegatingReporter.ExistingMessagesHandler(){

            @Override
            public void handleMessages(List<IndexingInfo> list, List<IndexingError> list2) {
                for (IndexingInfo object : list) {
                    progressReporter.info(object);
                }
                for (IndexingError indexingError : list2) {
                    progressReporter.fail(indexingError);
                }
            }
        });
        task.evtFinished.add(new Event.Listener<Boolean>(this){

            @Override
            public void update(Boolean bl) {
                if (bl.booleanValue()) {
                    UtilGui.runAsyncExec((Widget)cTabItem, new Runnable(){

                        @Override
                        public void run() {
                            cTabItem.setImage(Img.WARNING_BIG.get());
                        }
                    });
                }
            }
        });
        progressPanel.getProgressTable().scrollToBottom();
        progressPanel.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                task.detachReporter(progressReporter);
            }
        });
    }
}

