/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.util.Collections;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.gui.indexing.ConfigPanel;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.GroupWrapper;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

final class OutlookConfigPanel
extends ConfigPanel {
    private Button indexFilenameBt;
    private Button storeRelativePathsBt;
    private Button watchFolderBt;

    public OutlookConfigPanel(Composite composite, LuceneIndex luceneIndex) {
        super(composite, luceneIndex, false);
    }

    @Override
    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        Group group = new GroupWrapper(composite2, Msg.indexing_options.get()){

            @Override
            protected void createLayout(Group group) {
                group.setLayout((Layout)UtilGui.createGridLayout(1, false, 3, 3));
            }

            @Override
            protected void createContents(Group group) {
                OutlookConfigPanel.this.createGroupContents(group);
            }
        }.getGroup();
        GridLayout gridLayout = UtilGui.createGridLayout(1, false, 0, 0);
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        composite2.setLayout((Layout)gridLayout);
        UtilGui.setGridData((Control)group, true);
        return composite2;
    }

    private void createGroupContents(Group group) {
        this.indexFilenameBt = UtilGui.createCheckButton((Composite)group, Msg.index_filenames.get());
        this.storeRelativePathsBt = UtilGui.createCheckButton((Composite)group, Msg.store_relative_paths.get());
        this.watchFolderBt = UtilGui.createCheckButton((Composite)group, Msg.watch_folders.get());
        IndexingConfig indexingConfig = this.index.getConfig();
        this.indexFilenameBt.setSelection(indexingConfig.isIndexFilenames());
        this.watchFolderBt.setSelection(indexingConfig.isWatchFolders());
        this.storeRelativePathsBt.setSelection(indexingConfig.isStoreRelativePaths());
    }

    @Override
    protected boolean writeToConfig() {
        IndexingConfig indexingConfig = this.index.getConfig();
        indexingConfig.setIndexFilenames(this.indexFilenameBt.getSelection());
        indexingConfig.setStoreRelativePaths(this.storeRelativePathsBt.getSelection());
        indexingConfig.setWatchFolders(this.watchFolderBt.getSelection());
        PatternAction patternAction = new PatternAction(".*");
        patternAction.setAction(PatternAction.MatchAction.DETECT_MIME);
        patternAction.setTarget(PatternAction.MatchTarget.FILENAME);
        indexingConfig.setPatternActions(Collections.singletonList(patternAction));
        return true;
    }

    @Override
    protected void restoreDefaults() {
        IndexingConfig indexingConfig = this.index.getConfig();
        this.indexFilenameBt.setSelection(indexingConfig.isIndexFilenames());
        this.storeRelativePathsBt.setSelection(indexingConfig.isStoreRelativePaths());
        this.watchFolderBt.setSelection(indexingConfig.isWatchFolders());
    }
}

