/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import java.util.List;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.indexing.RegexTestPanel;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.model.index.file.FileIndex;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.LazyImageCache;
import net.sourceforge.docfetcher.util.gui.viewer.ColumnEditSupport;
import net.sourceforge.docfetcher.util.gui.viewer.SimpleTableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

final class PatternTable
extends Composite {
    private final LuceneIndex index;
    private SimpleTableViewer<PatternAction> tableViewer;
    private final RegexTestPanel regexTestPanel;
    private boolean storeRelativePaths;

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        LazyImageCache lazyImageCache = new LazyImageCache(display, "dist/img");
        Img.initialize(lazyImageCache);
        AppUtil.Const.autoInit();
        FileIndex fileIndex = new FileIndex(null, new File(""));
        PatternTable patternTable = new PatternTable((Composite)shell, fileIndex);
        patternTable.setStoreRelativePaths(fileIndex.getConfig().isStoreRelativePaths());
        UtilGui.setCenteredBounds(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public PatternTable(Composite composite, LuceneIndex luceneIndex) {
        super(composite, 0);
        this.index = luceneIndex;
        this.setLayout((Layout)UtilGui.createGridLayout(2, false, 0, 5));
        Table table = this.createTable();
        Control control = this.createButtonPanel();
        this.regexTestPanel = new RegexTestPanel(this, luceneIndex);
        this.regexTestPanel.setStoreRelativePaths(this.storeRelativePaths);
        GridData gridData = new GridData(4, 4, true, true);
        int n = ProgramConf.Int.PatternTableHeight.get() + 1;
        gridData.minimumHeight = Math.max(table.getItemHeight() * n + 5, 120);
        table.setLayoutData((Object)gridData);
        control.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        this.regexTestPanel.setLayoutData(new GridData(4, 4, true, false));
        this.restoreDefaults();
    }

    private Table createTable() {
        int n = 67588;
        this.tableViewer = new SimpleTableViewer(this, n);
        this.tableViewer.enableEditSupport();
        this.tableViewer.addColumn(new SimpleTableViewer.Column<PatternAction>(Msg.pattern_regex.get()){

            @Override
            protected String getLabel(PatternAction patternAction) {
                return patternAction.getRegex();
            }

            @Override
            protected ColumnEditSupport<PatternAction> getEditSupport() {
                return new ColumnEditSupport.TextEditSupport<PatternAction>(){

                    @Override
                    protected void setText(PatternAction patternAction, String string) {
                        patternAction.setRegex(string);
                        PatternTable.this.updateRegexTestPanel();
                    }
                };
            }
        });
        this.tableViewer.addColumn(new SimpleTableViewer.Column<PatternAction>(Msg.match_against.get()){

            @Override
            protected String getLabel(PatternAction patternAction) {
                return this.getLabel(patternAction.getTarget());
            }

            @Override
            protected ColumnEditSupport<PatternAction> getEditSupport() {
                return new ColumnEditSupport.ComboEditSupport<PatternAction, PatternAction.MatchTarget>(PatternAction.MatchTarget.class){

                    @Override
                    protected void setChoice(PatternAction patternAction, PatternAction.MatchTarget matchTarget) {
                        patternAction.setTarget(matchTarget);
                        PatternTable.this.updateRegexTestPanel();
                    }

                    @Override
                    protected String toString(PatternAction.MatchTarget matchTarget) {
                        return this.getLabel(matchTarget);
                    }
                };
            }

            @Override
            private String getLabel(PatternAction.MatchTarget matchTarget) {
                switch (matchTarget) {
                    case FILENAME: {
                        return Msg.filename.get();
                    }
                    case PATH: {
                        return PatternTable.this.storeRelativePaths ? Msg.relative_path.get() : Msg.absolute_path.get();
                    }
                }
                throw new IllegalStateException();
            }
        });
        this.tableViewer.addColumn(new SimpleTableViewer.Column<PatternAction>(Msg.action.get()){

            @Override
            protected String getLabel(PatternAction patternAction) {
                switch (patternAction.getAction()) {
                    case EXCLUDE: {
                        return Msg.exclude.get();
                    }
                    case DETECT_MIME: {
                        return Msg.detect_mime_type.get();
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            protected ColumnEditSupport<PatternAction> getEditSupport() {
                return new ColumnEditSupport.ComboEditSupport<PatternAction, PatternAction.MatchAction>(PatternAction.MatchAction.class){

                    @Override
                    protected void setChoice(PatternAction patternAction, PatternAction.MatchAction matchAction) {
                        patternAction.setAction(matchAction);
                        PatternTable.this.updateRegexTestPanel();
                    }

                    @Override
                    protected String toString(PatternAction.MatchAction matchAction) {
                        return matchAction.displayName;
                    }
                };
            }
        });
        Table table = this.tableViewer.getControl();
        table.setLinesVisible(true);
        SettingsConf.ColumnWidths.PatternTable.bind(table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PatternTable.this.updateRegexTestPanel();
            }
        });
        return table;
    }

    private void updateRegexTestPanel() {
        this.regexTestPanel.setPatternActions(this.tableViewer.getSelection());
    }

    private Control createButtonPanel() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)UtilGui.createGridLayout(1, false, 0, 5));
        UtilGui.createPushButton(composite, Img.ADD.get(), Msg.add_pattern.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PatternAction patternAction = new PatternAction();
                PatternTable.this.tableViewer.add(patternAction);
                PatternTable.this.tableViewer.showElement(patternAction);
                PatternTable.this.tableViewer.setSelection(patternAction);
                PatternTable.this.updateRegexTestPanel();
            }
        });
        UtilGui.createPushButton(composite, Img.REMOVE.get(), Msg.remove_sel_pattern.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (PatternAction patternAction : PatternTable.this.tableViewer.getSelection()) {
                    PatternTable.this.tableViewer.remove(patternAction);
                }
                PatternTable.this.updateRegexTestPanel();
            }
        });
        UtilGui.createPushButton(composite, Img.ARROW_UP.get(), Msg.increase_pattern_priority.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List<PatternAction> list = PatternTable.this.tableViewer.getSelection();
                if (list.size() == 1) {
                    PatternTable.this.tableViewer.move(list.get(0), true);
                }
            }
        });
        UtilGui.createPushButton(composite, Img.ARROW_DOWN.get(), Msg.decrease_pattern_priority.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List<PatternAction> list = PatternTable.this.tableViewer.getSelection();
                if (list.size() == 1) {
                    PatternTable.this.tableViewer.move(list.get(0), false);
                }
            }
        });
        return composite;
    }

    public void setStoreRelativePaths(boolean bl) {
        this.storeRelativePaths = bl;
        this.regexTestPanel.setStoreRelativePaths(bl);
        for (PatternAction patternAction : this.tableViewer.getElements()) {
            this.tableViewer.update(patternAction);
        }
    }

    public List<PatternAction> getPatternActions() {
        return this.tableViewer.getElements();
    }

    public void restoreDefaults() {
        this.tableViewer.removeAll();
        for (PatternAction patternAction : this.index.getConfig().getPatternActions()) {
            this.tableViewer.add(patternAction);
        }
        this.updateRegexTestPanel();
    }
}

