/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.gui.indexing.ErrorTable;
import net.sourceforge.docfetcher.gui.indexing.ProgressPanel;
import net.sourceforge.docfetcher.gui.indexing.ProgressTable;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.util.Util;

final class ProgressReporter
extends IndexingReporter {
    private final ProgressTable progressTable;
    private final ErrorTable errorTable;
    private long start = 0L;
    private IndexingInfo lastInfo;
    private final File indexDir;
    private File logFile;

    public ProgressReporter(ProgressPanel progressPanel, File file) {
        this.progressTable = progressPanel.getProgressTable();
        this.errorTable = progressPanel.getErrorTable();
        this.indexDir = file;
    }

    @Override
    public void setStartTime(long l) {
        this.start = l;
        if (ProgramConf.Bool.WriteIndexingLog.get() && this.indexDir != null) {
            this.logFile = new File(this.indexDir, "indexing-log.txt");
            this.logFile.delete();
            try {
                this.logFile.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void setEndTime(long l) {
        String string = ProgressReporter.toHumanReadableDuration(l - this.start);
        String string2 = Msg.total_elapsed_time.format(string);
        this.progressTable.append(string2);
    }

    private static String toHumanReadableDuration(long l) {
        int n = (int)(l / 1000L);
        int n2 = n / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        n -= n3 * 60;
        Object object = "";
        if (n2 != 0) {
            object = (String)object + n2 + " h";
        }
        if (n3 != 0) {
            object = (String)object + (n2 == 0 ? "" : " ") + n3 + " min";
        }
        if (n != 0) {
            object = (String)object + (n2 == 0 && n3 == 0 ? "" : " ") + n + " s";
        }
        if (((String)object).equals("")) {
            return "0 s";
        }
        return object;
    }

    @Override
    public void info(IndexingInfo indexingInfo) {
        String string = this.getMessage(indexingInfo);
        int[] nArray = indexingInfo.getPercentage();
        if (nArray != null) {
            string = String.format("%s [%d/%d]", string, nArray[0], nArray[1]);
        }
        this.progressTable.append(string);
        this.lastInfo = indexingInfo;
        if (ProgramConf.Bool.WriteIndexingLog.get() && this.indexDir != null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile, true), "UTF-8"));
                bufferedWriter.append(indexingInfo.getTreeNode().getPath().getPath() + "\r\n");
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void subInfo(int n, int n2) {
        Util.checkThat(this.lastInfo != null);
        String string = this.getMessage(this.lastInfo);
        string = String.format("%s [%d/%d]", string, n, n2);
        this.progressTable.replaceLast(string);
    }

    private String getMessage(IndexingInfo indexingInfo) {
        TreeNode treeNode = indexingInfo.getTreeNode();
        String string = ProgramConf.Bool.ShowPathsDuringIndexing.get() ? treeNode.getPath().getPath() : treeNode.getDisplayName();
        return String.format("%,d\t %s", indexingInfo.getNumber(), string);
    }

    @Override
    public void fail(IndexingError indexingError) {
        String string = indexingError.getTreeNode().getDisplayName();
        this.progressTable.append("### " + Msg.error.format(string));
        this.errorTable.addError(indexingError);
        if (ProgramConf.Bool.WriteIndexingLog.get() && this.indexDir != null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile, true), "UTF-8"));
                String string2 = "FAIL: " + indexingError.getTreeNode().getPath().getPath() + "\r\n";
                string2 = string2 + "  " + indexingError.getLocalizedMessage() + "\r\n";
                bufferedWriter.append(string2);
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

