/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

final class ProgressTable {
    private final Lock lock = new ReentrantLock(true);
    private final Condition notEmpty = this.lock.newCondition();
    private final LinkedList<String> queue = new LinkedList();
    private boolean replaceLastInTable = false;
    private final int itemLimit;
    private final Table table;
    private final LinkedList<String> tableItems = new LinkedList();

    public static void main(String[] stringArray) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        UtilGui.setCenteredBounds(shell, 400, 300);
        final ProgressTable progressTable = new ProgressTable((Composite)shell, 1000);
        new Thread(){

            @Override
            public void run() {
                int n = 0;
                while (!shell.isDisposed()) {
                    progressTable.append("" + n);
                    ++n;
                }
            }
        }.start();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public ProgressTable(Composite composite, final int n) {
        Util.checkThat(n >= 2);
        this.itemLimit = n;
        this.table = new Table(composite, 0x10000A00);
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (event.index < 0 || event.index >= ProgressTable.this.tableItems.size()) {
                    return;
                }
                TableItem tableItem = (TableItem)event.item;
                tableItem.setText(ProgressTable.this.tableItems.get(event.index));
            }
        });
        final Thread thread = new Thread(ProgressTable.class.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    boolean bl;
                    List<String> list;
                    ProgressTable.this.lock.lock();
                    try {
                        while (ProgressTable.this.queue.isEmpty()) {
                            ProgressTable.this.notEmpty.await();
                        }
                        int n3 = ProgressTable.this.queue.size();
                        int n2 = Math.max(0, n3 - n);
                        list = ProgressTable.this.queue.subList(n2, n3);
                        list = new ArrayList(list);
                        ProgressTable.this.queue.clear();
                        bl = ProgressTable.this.replaceLastInTable;
                        ProgressTable.this.replaceLastInTable = false;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    finally {
                        ProgressTable.this.lock.unlock();
                    }
                    ProgressTable.this.append(list, bl);
                    try {
                        Thread.sleep(40L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        };
        thread.start();
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                thread.interrupt();
            }
        });
    }

    public Control getControl() {
        return this.table;
    }

    public void append(String string) {
        Util.checkNotNull(string);
        this.lock.lock();
        try {
            this.queue.add(string);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void replaceLast(String string) {
        Util.checkNotNull(string);
        this.lock.lock();
        try {
            if (this.queue.isEmpty()) {
                assert (!this.replaceLastInTable);
                this.replaceLastInTable = true;
            } else {
                this.queue.removeLast();
            }
            this.queue.add(string);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void append(final List<String> list, final boolean bl) {
        Util.checkThat(!list.isEmpty());
        Util.checkThat(list.size() <= this.itemLimit);
        UtilGui.runSyncExec((Widget)this.table, new Runnable(){

            @Override
            public void run() {
                int n;
                int n2;
                ProgressTable.this.table.setRedraw(false);
                int n3 = -1;
                if (bl && !ProgressTable.this.tableItems.isEmpty()) {
                    ProgressTable.this.tableItems.removeLast();
                    n3 = ProgressTable.this.tableItems.size();
                }
                if ((n2 = (n = ProgressTable.this.tableItems.size() + list.size()) - ProgressTable.this.itemLimit) > 0) {
                    while (n2 > 0) {
                        ProgressTable.this.tableItems.removeFirst();
                        --n2;
                    }
                    ProgressTable.this.tableItems.addAll(list);
                    ProgressTable.this.tableItems.set(0, "...");
                    ProgressTable.this.table.clearAll();
                    ProgressTable.this.table.setItemCount(ProgressTable.this.itemLimit);
                } else {
                    ProgressTable.this.tableItems.addAll(list);
                    if (n3 != -1) {
                        ProgressTable.this.table.clear(n3);
                    }
                    ProgressTable.this.table.setItemCount(n);
                }
                TableItem tableItem = ProgressTable.this.table.getItem(ProgressTable.this.tableItems.size() - 1);
                ProgressTable.this.table.showItem(tableItem);
                ProgressTable.this.table.setRedraw(true);
            }
        });
    }

    public void scrollToBottom() {
        UtilGui.runSwtSafe((Widget)this.table, new Runnable(){

            @Override
            public void run() {
                ProgressTable.this.table.setTopIndex(Integer.MAX_VALUE);
            }
        });
    }
}

