/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class RegexTestPanel
extends Composite {
    private final Label label;
    private final Text fileBox;
    private List<PatternAction> patternActions = Collections.emptyList();
    private boolean storeRelativePaths;

    public RegexTestPanel(Composite composite, final LuceneIndex luceneIndex) {
        super(composite, 0);
        Util.checkNotNull(luceneIndex);
        this.label = new Label((Composite)this, 0);
        this.label.setText("");
        this.fileBox = new Text((Composite)this, 2052);
        Button button = UtilGui.createPushButton(this, "...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(RegexTestPanel.this.getShell(), 4096);
                File file = luceneIndex.getCanonicalRootFile();
                if (file.isFile() && (file = file.getParentFile()) == null) {
                    file = Util.USER_DIR;
                }
                fileDialog.setFilterPath(file.getPath());
                fileDialog.setText(Msg.choose_regex_testfile_title.get());
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                File file2 = new File(string);
                Path path = IndexingConfig.getStorablePath(file2, RegexTestPanel.this.storeRelativePaths);
                RegexTestPanel.this.fileBox.setText(path.getPath());
                RegexTestPanel.this.updateLabel();
            }
        });
        this.fileBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                RegexTestPanel.this.updateLabel();
            }
        });
        this.setLayout((Layout)UtilGui.createGridLayout(2, false, 0, 0));
        this.label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fileBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalIndent = 5;
        button.setLayoutData((Object)gridData);
    }

    public void setPatternActions(List<PatternAction> list) {
        Util.checkNotNull(list);
        this.patternActions = list;
        this.updateLabel();
    }

    public void setStoreRelativePaths(boolean bl) {
        if (this.storeRelativePaths == bl) {
            return;
        }
        this.storeRelativePaths = bl;
        String string = this.fileBox.getText().trim();
        if (string.isEmpty()) {
            return;
        }
        File file = Util.getCanonicalFile(string);
        Path path = IndexingConfig.getStorablePath(file, bl);
        this.fileBox.setText(path.getPath());
        this.updateLabel();
    }

    private void updateLabel() {
        try {
            this.label.setText(this.matches() ? Msg.sel_regex_matches_file_yes.get() : Msg.sel_regex_matches_file_no.get());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.label.setText(Msg.sel_regex_malformed.get());
        }
    }

    private boolean matches() throws PatternSyntaxException {
        if (this.patternActions.isEmpty()) {
            return false;
        }
        String string = this.fileBox.getText().trim();
        if (string.length() == 0) {
            return false;
        }
        String string2 = new File(string).getName();
        for (PatternAction patternAction : this.patternActions) {
            String string3;
            Pattern pattern = Pattern.compile(patternAction.getRegex());
            if (!pattern.matcher(string3 = patternAction.getTarget() == PatternAction.MatchTarget.FILENAME ? string2 : string).matches()) continue;
            return true;
        }
        return false;
    }
}

