/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class SingletonDialogFactory<D extends Dialog> {
    public final Event<Void> evtDialogOpened = new Event();
    private final Shell parentShell;
    private D dialog;

    public static void main(String[] stringArray) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setText("Main Shell");
        shell.setLayout((Layout)new GridLayout());
        UtilGui.setCenteredBounds(shell, 200, 200);
        final SingletonDialogFactory<Dialog> singletonDialogFactory = new SingletonDialogFactory<Dialog>(shell){

            @Override
            protected Dialog createDialog(Shell shell3) {
                Shell shell2 = new Shell(shell3, 1264);
                shell2.setText("Sub-Shell");
                shell2.setSize(200, 200);
                Point point = shell.getLocation();
                shell2.setLocation(point.x + 50, point.y + 50);
                shell2.setLayout((Layout)new GridLayout());
                Label label = new Label((Composite)shell2, 0);
                label.setText("Label");
                label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
                class MyDialog
                implements Dialog {
                    private final Shell shell;

                    public MyDialog(Shell shell) {
                        this.shell = shell;
                    }

                    @Override
                    public Shell getShell() {
                        return this.shell;
                    }
                }
                return new MyDialog(shell2);
            }
        };
        Button button = new Button((Composite)shell, 8);
        button.setText("Open");
        button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                singletonDialogFactory.open();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public SingletonDialogFactory(Shell shell) {
        this.parentShell = Util.checkNotNull(shell);
    }

    public final D open() {
        if (this.dialog != null) {
            this.dialog.getShell().open();
            this.evtDialogOpened.fire(null);
            return this.dialog;
        }
        this.dialog = this.createDialog(this.parentShell);
        Shell shell = this.dialog.getShell();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SingletonDialogFactory.this.dialog = null;
            }
        });
        shell.open();
        this.evtDialogOpened.fire(null);
        return this.dialog;
    }

    protected abstract D createDialog(Shell var1);

    public static interface Dialog {
        public Shell getShell();
    }
}

