/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.pref;

import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.pref.PrefDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class ColorOption
extends PrefDialog.PrefOption {
    private SettingsConf.IntArray enumOption;
    private StyledText st;
    private Color color;

    public ColorOption(String string, SettingsConf.IntArray intArray) {
        super(string);
        this.enumOption = intArray;
    }

    @Override
    protected void createControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.labelText);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        int n = 2060;
        this.st = new StyledText(composite, n);
        this.st.setCaret(null);
        this.st.setCursor(this.st.getDisplay().getSystemCursor(21));
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.widthHint = 50;
        this.st.setLayoutData((Object)gridData);
        this.setColor(this.enumOption.get());
        this.st.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                ColorDialog colorDialog = new ColorDialog(ColorOption.this.st.getShell());
                colorDialog.setRGB(ColorOption.this.color.getRGB());
                RGB rGB = colorDialog.open();
                if (rGB == null) {
                    return;
                }
                ColorOption.this.setColor(rGB.red, rGB.green, rGB.blue);
            }
        });
        this.st.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ColorOption.this.color.dispose();
            }
        });
    }

    @Override
    protected void restoreDefault() {
        this.setColor(this.enumOption.defaultValue);
    }

    @Override
    protected void save() {
        RGB rGB = this.color.getRGB();
        this.enumOption.set(rGB.red, rGB.green, rGB.blue);
    }

    private void setColor(int ... nArray) {
        Color color = this.color;
        this.color = new Color((Device)this.st.getDisplay(), nArray[0], nArray[1], nArray[2]);
        this.st.setBackground(this.color);
        this.st.setSelectionBackground(this.color);
        this.st.setSelectionForeground(this.st.getForeground());
        if (color != null) {
            color.dispose();
        }
    }
}

