/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.pref;

import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.pref.PrefDialog;
import net.sourceforge.docfetcher.gui.pref.StyledLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;

final class FontOption
extends PrefDialog.PrefOption {
    private final SettingsConf.FontDescription fontDescription;
    private StyledLabel st;
    private Font font;
    private int fontHeight;

    public FontOption(String string, SettingsConf.FontDescription fontDescription) {
        super(string);
        this.fontDescription = fontDescription;
    }

    @Override
    protected void createControls(Composite composite) {
        this.st = PrefDialog.createLabeledStyledLabel(composite, this.labelText);
        this.st.setCursor(this.st.getDisplay().getSystemCursor(21));
        this.setFont(this.fontDescription.createFontData());
        this.st.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FontOption.this.font.dispose();
            }
        });
        this.st.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                FontDialog fontDialog = new FontDialog(FontOption.this.st.getShell());
                FontData fontData = FontOption.this.font.getFontData()[0];
                fontData.setHeight(FontOption.this.fontHeight);
                fontDialog.setFontList(new FontData[]{fontData});
                FontData fontData2 = fontDialog.open();
                if (fontData2 == null) {
                    return;
                }
                Font font = FontOption.this.font;
                FontOption.this.setFont(fontData2);
                font.dispose();
            }
        });
    }

    @Override
    protected void restoreDefault() {
        this.setFont(this.fontDescription.createDefaultFontData());
    }

    @Override
    protected void save() {
        FontData fontData = this.font.getFontData()[0];
        fontData.setHeight(this.fontHeight);
        this.fontDescription.set(fontData);
    }

    private void setFont(FontData fontData) {
        this.fontHeight = fontData.getHeight();
        Display display = this.st.getDisplay();
        Font font = display.getSystemFont();
        fontData.setHeight(font.getFontData()[0].getHeight());
        this.font = new Font((Device)display, fontData);
        this.st.setFont(this.font);
        this.st.setText(fontData.getName() + " " + this.fontHeight);
    }
}

