/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.pref;

import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class HotkeyDialog {
    private final Shell shell;
    private final Text hotkeyBox;
    private final int[] initialHotkey = SettingsConf.IntArray.Hotkey.get();
    private int[] hotkey = this.initialHotkey;

    public HotkeyDialog(Shell shell) {
        this.shell = new Shell(shell, 112);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setImage(Img.LETTERS.get());
        this.shell.setText(Msg.keybox_title.get());
        Label label = new Label((Composite)this.shell, 0);
        label.setText(Msg.keybox_msg.get());
        this.hotkeyBox = new Text((Composite)this.shell, 2056);
        this.hotkeyBox.setText(UtilGui.toString(this.hotkey));
        this.hotkeyBox.setBackground(Col.LIST_BACKGROUND.get());
        this.hotkeyBox.setForeground(Col.LIST_FOREGROUND.get());
        Label label2 = new Label((Composite)this.shell, 0);
        Label label3 = new Label((Composite)this.shell, 258);
        Label label4 = new Label((Composite)this.shell, 0);
        Button button = new Button((Composite)this.shell, 8);
        button.setText(Msg.ok.get());
        Button button2 = new Button((Composite)this.shell, 8);
        button2.setText(Msg.cancel.get());
        Button button3 = new Button((Composite)this.shell, 8);
        button3.setText(Msg.restore_default.get());
        Button[] buttonArray = UtilGui.maybeSwapButtons(button, button2);
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.top(0, 10).left(0, 10).right(100, -10).applyTo((Control)label);
        formDataFactory.top((Control)label, 10).applyTo((Control)this.hotkeyBox);
        formDataFactory.reset().minWidth(75).bottom().right().applyTo((Control)buttonArray[1]);
        formDataFactory.right((Control)buttonArray[1]).applyTo((Control)buttonArray[0]);
        formDataFactory.right((Control)buttonArray[0]).applyTo((Control)button3);
        formDataFactory.minWidth(0).right((Control)button3).left().applyTo((Control)label4);
        formDataFactory.reset().left().right().bottom((Control)buttonArray[1]).applyTo((Control)label3);
        formDataFactory.bottom((Control)label3).top((Control)this.hotkeyBox).applyTo((Control)label2);
        this.hotkeyBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int[] nArray = HotkeyDialog.this.acceptHotkey(keyEvent.stateMask, keyEvent.keyCode);
                if (nArray == null) {
                    return;
                }
                HotkeyDialog.this.hotkey = nArray;
                HotkeyDialog.this.hotkeyBox.setText(UtilGui.toString(HotkeyDialog.this.hotkey));
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                HotkeyDialog.this.hotkey = HotkeyDialog.this.initialHotkey;
            }
        });
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HotkeyDialog.this.hotkey = SettingsConf.IntArray.Hotkey.defaultValue;
                HotkeyDialog.this.hotkeyBox.setText(UtilGui.toString(HotkeyDialog.this.hotkey));
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsConf.IntArray.Hotkey.set(HotkeyDialog.this.hotkey);
                HotkeyDialog.this.shell.dispose();
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HotkeyDialog.this.shell.close();
            }
        });
    }

    public int[] open() {
        boolean bl = SettingsConf.Bool.HotkeyEnabled.get();
        SettingsConf.Bool.HotkeyEnabled.set(false);
        UtilGui.setCenteredBounds(this.shell);
        this.shell.open();
        this.hotkeyBox.setFocus();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        SettingsConf.Bool.HotkeyEnabled.set(bl);
        return this.hotkey;
    }

    private int[] acceptHotkey(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        if ((n & 0x70000) == 0) {
            return null;
        }
        switch (n2) {
            case 8: 
            case 13: 
            case 127: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 0x1000009: 
            case 0x100000A: 
            case 0x100000B: 
            case 0x100000C: 
            case 0x100000D: 
            case 0x100000E: 
            case 0x100000F: 
            case 0x1000010: 
            case 0x1000011: 
            case 0x1000012: 
            case 0x1000013: 
            case 0x1000014: 
            case 0x1000015: 
            case 0x1000055: 
            case 16777303: {
                return nArray;
            }
        }
        if (n2 == 131072 || n2 == 65536) {
            return null;
        }
        if (Character.isLetterOrDigit(n2)) {
            if (Character.isLetter(n2)) {
                nArray[1] = Character.toUpperCase(nArray[1]);
            }
            return nArray;
        }
        return null;
    }
}

