/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class DelayedOverlay {
    private Shell shell;
    private final Control control;
    private final Color bgColor;
    private volatile long delay = 100L;
    private volatile String message = "";
    private long version = 0L;

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        UtilGui.setCenteredBounds(shell, 640, 480);
        SashForm sashForm = new SashForm((Composite)shell, 256);
        StyledText styledText = new StyledText((Composite)sashForm, 2048);
        styledText.setText("Click here to show the loading screen.");
        new StyledText((Composite)sashForm, 2048);
        final DelayedOverlay delayedOverlay = new DelayedOverlay((Control)styledText);
        delayedOverlay.setMessage("Loading...");
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                delayedOverlay.show();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public DelayedOverlay(final Control control) {
        Util.checkNotNull(control);
        this.control = control;
        this.bgColor = new Color((Device)control.getDisplay(), 200, 255, 200);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (DelayedOverlay.this.shell != null) {
                    DelayedOverlay.this.shell.dispose();
                }
                DelayedOverlay.this.bgColor.dispose();
            }
        });
        ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlMoved(ControlEvent controlEvent) {
                if (DelayedOverlay.this.shell != null) {
                    UtilGui.setCenteredBounds(DelayedOverlay.this.shell, control);
                }
            }

            public void controlResized(ControlEvent controlEvent) {
                if (DelayedOverlay.this.shell != null) {
                    UtilGui.setCenteredBounds(DelayedOverlay.this.shell, control);
                }
            }
        };
        control.addControlListener((ControlListener)controlAdapter);
        control.getShell().addControlListener((ControlListener)controlAdapter);
    }

    public void setDelay(long l) {
        Util.checkThat(l >= 0L);
        this.delay = l;
    }

    public void setMessage(String string) {
        Util.checkNotNull(string);
        this.message = string;
    }

    public Hider show() {
        final long[] lArray = new long[]{-1L};
        UtilGui.runSwtSafe((Widget)this.control, new Runnable(){

            @Override
            public void run() {
                lArray[0] = DelayedOverlay.this.version;
            }
        });
        new Thread(DelayedOverlay.class.getName()){

            @Override
            public void run() {
                try {
                    Thread.sleep(DelayedOverlay.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                UtilGui.runSyncExec((Widget)DelayedOverlay.this.control, new Runnable(){

                    @Override
                    public void run() {
                        if (lArray[0] == DelayedOverlay.this.version) {
                            DelayedOverlay.this.doShow();
                        }
                    }
                });
            }
        }.start();
        return new Hider(lArray[0]);
    }

    private void doShow() {
        if (this.shell != null) {
            return;
        }
        Point point = this.control.getSize();
        if (!this.control.isVisible() || point.x * point.y == 0) {
            return;
        }
        if (this.control.getShell() != this.control.getDisplay().getActiveShell()) {
            return;
        }
        this.shell = new Shell(this.control.getShell(), 8);
        this.shell.setLayout((Layout)UtilGui.createFillLayout(5));
        this.shell.setBackground(this.bgColor);
        this.shell.setForeground(Col.BLACK.get());
        StyledText styledText = new StyledText((Composite)this.shell, 72);
        styledText.setText(this.message);
        styledText.setMargins(20, 5, 20, 5);
        styledText.setBackground(this.shell.getBackground());
        styledText.setForeground(this.shell.getForeground());
        styledText.setEnabled(false);
        UtilGui.setCenteredBounds(this.shell, this.control);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                DelayedOverlay.this.shell = null;
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(this){

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = false;
            }
        });
        this.shell.open();
    }

    private void doHide() {
        ++this.version;
        if (this.shell == null) {
            return;
        }
        this.shell.dispose();
    }

    public final class Hider {
        private final long localVersion;

        private Hider(long l) {
            this.localVersion = l;
        }

        public void hide() {
            UtilGui.runSwtSafe((Widget)DelayedOverlay.this.control, new Runnable(){

                @Override
                public void run() {
                    if (Hider.this.localVersion == DelayedOverlay.this.version) {
                        DelayedOverlay.this.doHide();
                    }
                }
            });
        }
    }
}

