/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.preview.AppendingStyledTextContent;
import net.sourceforge.docfetcher.model.search.HighlightedString;
import net.sourceforge.docfetcher.model.search.Range;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.ContextMenuManager;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

final class HighlightingText {
    private static final int margin = 10;
    private StyledText textViewer;
    private Color highlightColor;
    private StyleRange highlightStyle;
    private int[] highlightSpans = new int[0];
    private Map<Integer, int[]> lineIndexToSpans = new HashMap<Integer, int[]>();
    private int lineNumbersWidth = 0;
    private Bullet lineNumbersBullet = null;
    private Font normalFont;
    private Font monoFont;
    private boolean useMonoFont = true;

    public HighlightingText(Composite composite) {
        int n = 68170;
        this.textViewer = new StyledText(composite, n);
        this.textViewer.setMargins(10, 10, 10, 10);
        this.textViewer.setContent((StyledTextContent)new AppendingStyledTextContent());
        this.textViewer.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent lineStyleEvent) {
                HighlightingText.this.handleLineStyleEvent(lineStyleEvent);
            }
        });
        this.setHighlightColorAndStyle();
        StyleRange styleRange = new StyleRange();
        styleRange.metrics = new GlyphMetrics(0, 0, this.lineNumbersWidth);
        styleRange.foreground = Display.getCurrent().getSystemColor(15);
        this.lineNumbersBullet = new Bullet(18, styleRange);
        SettingsConf.IntArray.PreviewHighlighting.evtChanged.add(new Event.Listener<int[]>(){

            @Override
            public void update(int[] nArray) {
                final Color color = HighlightingText.this.highlightColor;
                HighlightingText.this.setHighlightColorAndStyle();
                HighlightingText.this.textViewer.redraw();
                UtilGui.runAsyncExec((Widget)HighlightingText.this.textViewer, new Runnable(){

                    @Override
                    public void run() {
                        color.dispose();
                    }
                });
            }
        });
        UtilGui.getPreviewFontNormal().evtChanged.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                if (HighlightingText.this.normalFont == null) {
                    return;
                }
                Font font = HighlightingText.this.normalFont;
                HighlightingText.this.normalFont = UtilGui.getPreviewFontNormal().createFont();
                if (HighlightingText.this.textViewer.getFont() == font) {
                    HighlightingText.this.textViewer.setFont(HighlightingText.this.normalFont);
                }
                font.dispose();
                HighlightingText.this.updateLineNumbersCache();
                HighlightingText.this.textViewer.redraw();
            }
        });
        UtilGui.getPreviewFontMono().evtChanged.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                if (HighlightingText.this.monoFont == null) {
                    return;
                }
                Font font = HighlightingText.this.monoFont;
                HighlightingText.this.monoFont = UtilGui.getPreviewFontMono().createFont();
                if (HighlightingText.this.textViewer.getFont() == font) {
                    HighlightingText.this.textViewer.setFont(HighlightingText.this.monoFont);
                }
                font.dispose();
                HighlightingText.this.updateLineNumbersCache();
                HighlightingText.this.textViewer.redraw();
            }
        });
        this.textViewer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Resource[] resourceArray;
                for (Resource resource : resourceArray = new Resource[]{HighlightingText.this.normalFont, HighlightingText.this.monoFont, HighlightingText.this.highlightColor}) {
                    if (resource == null) continue;
                    resource.dispose();
                }
            }
        });
        ContextMenuManager contextMenuManager = new ContextMenuManager((Control)this.textViewer);
        String string = Util.IS_MAC_OS_X ? Msg.copy_macosx.get() : Msg.copy.get();
        contextMenuManager.add(new MenuAction(Img.CLIPBOARD.get(), string){

            @Override
            public void run() {
                HighlightingText.this.textViewer.invokeAction(17039369);
            }
        });
    }

    private void setHighlightColorAndStyle() {
        int[] nArray = SettingsConf.IntArray.PreviewHighlighting.get();
        this.highlightColor = new Color((Device)this.textViewer.getDisplay(), nArray[0], nArray[1], nArray[2]);
        this.highlightStyle = new StyleRange(0, 0, null, this.highlightColor);
    }

    public StyledText getControl() {
        return this.textViewer;
    }

    public void redraw() {
        this.textViewer.redraw();
    }

    public void setText(HighlightedString highlightedString) {
        if (highlightedString.isEmpty()) {
            this.highlightSpans = new int[0];
            this.lineIndexToSpans.clear();
        } else {
            List<Range> list = highlightedString.getRanges();
            this.highlightSpans = new int[list.size() * 2];
            for (int i = 0; i < list.size(); ++i) {
                int n;
                this.highlightSpans[i * 2] = n = list.get((int)i).start;
                this.highlightSpans[i * 2 + 1] = n + list.get((int)i).length;
            }
            this.lineIndexToSpans = Util.createLineMap(highlightedString.getString(), this.highlightSpans);
        }
        this.textViewer.setText(highlightedString.getString());
        this.updateLineNumbersCache();
        this.textViewer.redraw();
    }

    public void clear() {
        this.textViewer.setText("");
        this.highlightSpans = new int[0];
        this.lineIndexToSpans.clear();
        this.updateLineNumbersCache();
        this.textViewer.redraw();
    }

    public void setUseMonoFont(boolean bl) {
        this.useMonoFont = bl;
        if (bl) {
            if (this.monoFont == null) {
                this.monoFont = UtilGui.getPreviewFontMono().createFont();
            }
            this.textViewer.setFont(this.monoFont);
        } else {
            if (this.normalFont == null) {
                this.normalFont = UtilGui.getPreviewFontNormal().createFont();
            }
            this.textViewer.setFont(this.normalFont);
        }
        this.updateLineNumbersCache();
        this.textViewer.redraw();
    }

    public Integer goTo(boolean bl) {
        Point point = this.textViewer.getSelection();
        int n = bl ? point.y : point.x;
        return this.goTo(bl, n);
    }

    public Integer goToLast() {
        return this.goTo(false, this.textViewer.getCharCount());
    }

    public void goTo(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.highlightSpans.length / 2) {
            return;
        }
        int n3 = this.highlightSpans[n2 * 2];
        int n4 = this.highlightSpans[n2 * 2 + 1];
        this.selectAndShowSpan(n3, n4);
    }

    private Integer goTo(boolean bl, int n) {
        if (bl) {
            for (int i = 0; i < this.highlightSpans.length / 2; ++i) {
                int n2 = this.highlightSpans[i * 2];
                if (n2 < n) continue;
                int n3 = this.highlightSpans[i * 2 + 1];
                this.selectAndShowSpan(n2, n3);
                return i + 1;
            }
        } else {
            for (int i = this.highlightSpans.length / 2 - 1; i >= 0; --i) {
                int n4 = this.highlightSpans[i * 2 + 1];
                if (n4 > n) continue;
                int n5 = this.highlightSpans[i * 2];
                this.selectAndShowSpan(n5, n4);
                return i + 1;
            }
        }
        return null;
    }

    private void selectAndShowSpan(int n, int n2) {
        int n3 = this.textViewer.getCharCount();
        if (n < 0 || n2 > n3 || n > n2) {
            return;
        }
        this.textViewer.setSelection(n, n2);
        this.scrollToMiddle((n + n2) / 2);
    }

    private void scrollToMiddle(int n) {
        try {
            int n2 = this.textViewer.getTopPixel();
            int n3 = this.textViewer.getLocationAtOffset((int)n).y + n2 - 10;
            int n4 = n2 + this.textViewer.getClientArea().height;
            int n5 = n4 - n2;
            int n6 = n5 / 3;
            int n7 = 2 * n5 / 3;
            double d = n2 + n5 / 3;
            double d2 = n4 - n5 / 3;
            if ((double)n3 < d) {
                this.textViewer.setTopPixel(n3 - n6);
            } else if ((double)n3 > d2) {
                this.textViewer.setTopPixel(n3 - n7);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateLineNumbersCache() {
        int n = 8;
        String string = " ";
        GC gC = new GC((Drawable)this.textViewer);
        int n2 = n + gC.stringExtent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (int)this.textViewer.getLineCount(), (String)string))).x;
        gC.dispose();
        StyleRange styleRange = new StyleRange();
        styleRange.metrics = new GlyphMetrics(0, 0, n2);
        styleRange.foreground = this.textViewer.getDisplay().getSystemColor(15);
        Bullet bullet = new Bullet(18, styleRange);
        bullet.text = string;
        this.lineNumbersWidth = n2;
        this.lineNumbersBullet = bullet;
    }

    private void handleLineStyleEvent(LineStyleEvent lineStyleEvent) {
        int[] nArray;
        int n = this.textViewer.getLineAtOffset(lineStyleEvent.lineOffset);
        if (SettingsConf.Bool.HighlightingEnabled.get() && (nArray = this.lineIndexToSpans.get(n)) != null) {
            lineStyleEvent.ranges = new int[nArray.length];
            lineStyleEvent.styles = new StyleRange[nArray.length / 2];
            for (int i = 0; i < nArray.length / 2; ++i) {
                int n2;
                lineStyleEvent.ranges[i * 2] = n2 = nArray[i * 2];
                lineStyleEvent.ranges[i * 2 + 1] = nArray[i * 2 + 1] - n2;
                lineStyleEvent.styles[i] = this.highlightStyle;
            }
        }
        if (this.useMonoFont && this.textViewer.getCharCount() > 0) {
            lineStyleEvent.bulletIndex = n;
            lineStyleEvent.bullet = this.lineNumbersBullet;
            lineStyleEvent.wrapIndent = this.lineNumbersWidth;
        }
    }
}

