/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.preview.DelayedOverlay;
import net.sourceforge.docfetcher.gui.preview.EmailPreview;
import net.sourceforge.docfetcher.gui.preview.HtmlPreview;
import net.sourceforge.docfetcher.gui.preview.TextPreview;
import net.sourceforge.docfetcher.model.FileResource;
import net.sourceforge.docfetcher.model.MailResource;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.search.HighlightedString;
import net.sourceforge.docfetcher.model.search.ResultDocument;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.concurrent.MergingBlockingQueue;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public final class PreviewPanel
extends Composite {
    public final Event<Void> evtHideInSystemTray = new Event();
    public final Event<Void> evtSaveSettings = new Event();
    private final TextPreview textPreview;
    private EmailPreview emailPreview;
    private HtmlPreview htmlPreview;
    private final Composite stackComp;
    private final StackLayout stackLayout;
    private final DelayedOverlay delayedOverlay;
    private final StyledText errorField;
    private Color lightRed;
    private ResultDocument lastDoc;
    private MailResource lastMailResource;
    private FileResource lastHtmlResource;
    private boolean browserCreationFailed = false;
    private long requestCount = 0L;

    public PreviewPanel(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)UtilGui.createGridLayout(1, false, 0, 2));
        this.stackComp = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        this.stackComp.setLayout((Layout)this.stackLayout);
        this.stackComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textPreview = new TextPreview(this.stackComp);
        this.stackLayout.topControl = this.textPreview;
        this.delayedOverlay = new DelayedOverlay((Control)this.stackComp);
        this.delayedOverlay.setDelay(500L);
        this.delayedOverlay.setMessage(Msg.loading.get());
        this.errorField = new StyledText((Composite)this, 2120);
        this.errorField.setMargins(5, 5, 5, 5);
        this.errorField.setCaret(null);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.exclude = true;
        this.errorField.setLayoutData((Object)gridData);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                PreviewPanel.this.disposeLastResources();
                if (PreviewPanel.this.lightRed != null) {
                    PreviewPanel.this.lightRed.dispose();
                }
            }
        });
        this.textPreview.evtTextToHtmlBt.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                SettingsConf.Bool.PreferHtmlPreview.set(true);
                PreviewPanel.this.setPreviewUnchecked(PreviewPanel.this.lastDoc);
            }
        });
    }

    public void setPreview(ResultDocument resultDocument) {
        Util.checkNotNull(resultDocument);
        UtilGui.assertSwtThread();
        if (this.lastDoc == resultDocument) {
            return;
        }
        this.lastDoc = resultDocument;
        this.setPreviewUnchecked(resultDocument);
    }

    public boolean setHtmlFile(File file) {
        Util.checkNotNull(file);
        UtilGui.assertSwtThread();
        if (!this.createAndShowHtmlPreview()) {
            return false;
        }
        this.lastDoc = null;
        this.disposeLastResources();
        ++this.requestCount;
        this.setError(null, this.requestCount);
        this.clearPreviews(true, false, true, false);
        this.htmlPreview.setFile(file, false);
        return true;
    }

    private void setPreviewUnchecked(ResultDocument resultDocument) {
        this.disposeLastResources();
        ++this.requestCount;
        this.setError(null, this.requestCount);
        if (resultDocument.isEmail()) {
            if (this.emailPreview == null) {
                this.emailPreview = new EmailPreview(this.stackComp);
            }
            this.moveToTop((Control)this.emailPreview);
            this.clearPreviews(true, false, false, true);
            new EmailThread(resultDocument, this.requestCount).start();
        } else if (resultDocument.isPdfFile() || resultDocument.isChmFile()) {
            this.moveToTop((Control)this.textPreview);
            this.clearPreviews(true, true, true, true);
            new PagingThread(resultDocument, this.requestCount).start();
        } else if (resultDocument.isHtmlFile() && SettingsConf.Bool.PreferHtmlPreview.get() && this.createAndShowHtmlPreview()) {
            this.clearPreviews(true, false, true, false);
            new HtmlThread(resultDocument, this.requestCount).start();
        } else {
            boolean bl = resultDocument.isHtmlFile() && !this.browserCreationFailed;
            this.textPreview.setHtmlButtonEnabled(bl);
            this.moveToTop((Control)this.textPreview);
            this.clearPreviews(false, false, true, true);
            new TextThread(resultDocument, this.requestCount).start();
        }
    }

    private boolean createAndShowHtmlPreview() {
        if (this.browserCreationFailed) {
            return false;
        }
        if (this.htmlPreview == null) {
            try {
                this.htmlPreview = new HtmlPreview(this.stackComp){

                    @Override
                    protected void saveSettings() {
                        PreviewPanel.this.evtSaveSettings.fire(null);
                    }
                };
                Event.redirect(this.htmlPreview.evtHideInSystemTray, this.evtHideInSystemTray);
            }
            catch (SWTError sWTError) {
                this.browserCreationFailed = true;
                return false;
            }
            this.htmlPreview.evtHtmlToTextBt.add(new Event.Listener<Void>(){

                @Override
                public void update(Void void_) {
                    if (PreviewPanel.this.lastDoc == null) {
                        return;
                    }
                    SettingsConf.Bool.PreferHtmlPreview.set(false);
                    PreviewPanel.this.setPreviewUnchecked(PreviewPanel.this.lastDoc);
                }
            });
        }
        this.moveToTop((Control)this.htmlPreview);
        return true;
    }

    public ResultDocument clear() {
        UtilGui.assertSwtThread();
        this.disposeLastResources();
        ++this.requestCount;
        this.setError(null, this.requestCount);
        this.clearPreviews(true, false, true, true);
        ResultDocument resultDocument = this.lastDoc;
        this.lastDoc = null;
        return resultDocument;
    }

    private void clearPreviews(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            this.textPreview.clear(bl2);
        }
        if (bl3 && this.emailPreview != null) {
            this.emailPreview.clear();
        }
        if (bl4 && this.htmlPreview != null) {
            this.htmlPreview.clear();
        }
    }

    private void disposeLastResources() {
        if (this.lastMailResource != null) {
            this.lastMailResource.dispose();
            this.lastMailResource = null;
        }
        if (this.lastHtmlResource != null) {
            this.lastHtmlResource.dispose();
            this.lastHtmlResource = null;
        }
    }

    private void setError(final String string, final long l) {
        UtilGui.runSwtSafe((Widget)this.errorField, new Runnable(){

            @Override
            public void run() {
                if (l != PreviewPanel.this.requestCount) {
                    return;
                }
                boolean bl = string != null;
                GridData gridData = (GridData)PreviewPanel.this.errorField.getLayoutData();
                boolean bl2 = !gridData.exclude;
                gridData.exclude = !bl;
                PreviewPanel.this.errorField.setText(bl ? string : "");
                assert (PreviewPanel.this.lightRed == null == !bl2);
                if (bl && !bl2) {
                    PreviewPanel.this.lightRed = new Color((Device)PreviewPanel.this.getDisplay(), new RGB(0.0f, 0.5f, 1.0f));
                    PreviewPanel.this.errorField.setBackground(PreviewPanel.this.lightRed);
                } else if (!bl && bl2) {
                    PreviewPanel.this.errorField.setBackground(null);
                    PreviewPanel.this.lightRed.dispose();
                    PreviewPanel.this.lightRed = null;
                }
                if (bl2 != bl) {
                    PreviewPanel.this.layout();
                }
            }
        });
    }

    private void moveToTop(Control control) {
        Util.checkNotNull(control);
        if (this.stackLayout.topControl == control) {
            return;
        }
        this.stackLayout.topControl = control;
        this.stackComp.layout();
    }

    private boolean setTextSafely(HighlightedString highlightedString, boolean bl, long l, boolean bl2) {
        return this.setTextSafely(Arrays.asList(highlightedString), bl, l, bl2);
    }

    private boolean setTextSafely(final List<HighlightedString> list, final boolean bl, long l, final boolean bl2) {
        return this.runSafely(l, (Widget)this.textPreview, new Runnable(){

            @Override
            public void run() {
                block4: {
                    block3: {
                        PreviewPanel.this.textPreview.setUseMonoFont(bl);
                        if (!ProgramConf.Bool.TextPreviewEnabled.get()) {
                            return;
                        }
                        if (!bl2) break block3;
                        for (HighlightedString highlightedString : list) {
                            PreviewPanel.this.textPreview.appendPage(highlightedString);
                        }
                        break block4;
                    }
                    if (list.isEmpty()) break block4;
                    Iterator iterator = list.iterator();
                    PreviewPanel.this.textPreview.setText((HighlightedString)iterator.next());
                    while (iterator.hasNext()) {
                        PreviewPanel.this.textPreview.appendPage((HighlightedString)iterator.next());
                    }
                }
            }
        });
    }

    private boolean runSafely(final long l, Widget widget, final Runnable runnable) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        boolean bl = UtilGui.runSwtSafe(widget, new Runnable(){

            @Override
            public void run() {
                if (l != PreviewPanel.this.requestCount) {
                    atomicBoolean.set(false);
                    return;
                }
                runnable.run();
            }
        });
        return bl && atomicBoolean.get();
    }

    private class EmailThread
    extends PreviewThread {
        public EmailThread(ResultDocument resultDocument, long l) {
            super(resultDocument, l);
        }

        @Override
        protected void doRun(DelayedOverlay.Hider hider) throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
            final MailResource mailResource = this.doc.getMailResource();
            boolean bl = PreviewPanel.this.runSafely(this.startCount, (Widget)PreviewPanel.this.stackComp, new Runnable(){

                @Override
                public void run() {
                    PreviewPanel.this.emailPreview.setEmail(mailResource);
                    PreviewPanel.this.lastMailResource = mailResource;
                }
            });
            if (!bl) {
                mailResource.dispose();
            }
        }
    }

    private class PagingThread
    extends PreviewThread {
        private volatile boolean isStopped;

        public PagingThread(ResultDocument resultDocument, long l) {
            super(resultDocument, l);
            this.isStopped = false;
        }

        @Override
        protected void doRun(final DelayedOverlay.Hider hider) throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
            final MergingBlockingQueue<Item> mergingBlockingQueue = new MergingBlockingQueue<Item>(this){

                @Override
                protected Item merge(Item item, Item item2) {
                    class Item {
                        private final List<HighlightedString> strings = new LinkedList<HighlightedString>();
                        private boolean isLastItem;

                        public Item(PagingThread pagingThread, HighlightedString highlightedString, boolean bl) {
                            if (highlightedString != null) {
                                this.strings.add(highlightedString);
                            }
                            this.isLastItem = bl;
                        }
                    }
                    item.strings.addAll(item2.strings);
                    item.isLastItem = item.isLastItem || item2.isLastItem;
                    return item;
                }
            };
            Thread thread = new Thread(PreviewPanel.class.getName() + " (PDF updater)"){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Item item = (Item)mergingBlockingQueue.take();
                                if (!item.strings.isEmpty() && !PreviewPanel.this.setTextSafely(item.strings, false, PagingThread.this.startCount, true)) {
                                    PagingThread.this.isStopped = true;
                                }
                                hider.hide();
                                if (item.isLastItem) {
                                    return;
                                }
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.start();
            this.doc.readPages(new ResultDocument.PreviewPageHandler(){

                @Override
                public void handlePage(HighlightedString highlightedString) {
                    mergingBlockingQueue.put(new Item(PagingThread.this, highlightedString, false));
                }

                @Override
                public boolean isStopped() {
                    return PagingThread.this.isStopped;
                }
            });
            mergingBlockingQueue.put(new Item(this, null, true));
        }
    }

    private class HtmlThread
    extends PreviewThread {
        public HtmlThread(ResultDocument resultDocument, long l) {
            super(resultDocument, l);
        }

        @Override
        protected void doRun(DelayedOverlay.Hider hider) throws ParseException, FileNotFoundException {
            final FileResource fileResource = this.doc.getFileResource();
            boolean bl = PreviewPanel.this.runSafely(this.startCount, (Widget)PreviewPanel.this.stackComp, new Runnable(){

                @Override
                public void run() {
                    PreviewPanel.this.htmlPreview.setFile(fileResource.getFile(), true);
                    PreviewPanel.this.lastHtmlResource = fileResource;
                }
            });
            if (!bl) {
                fileResource.dispose();
            }
        }
    }

    private class TextThread
    extends PreviewThread {
        public TextThread(ResultDocument resultDocument, long l) {
            super(resultDocument, l);
        }

        @Override
        protected void doRun(DelayedOverlay.Hider hider) throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
            HighlightedString highlightedString = this.doc.getHighlightedText();
            PreviewPanel.this.setTextSafely(highlightedString, this.doc.isPlainTextFile(), this.startCount, false);
        }
    }

    private abstract class PreviewThread
    extends Thread {
        protected final ResultDocument doc;
        protected final long startCount;

        public PreviewThread(ResultDocument resultDocument, long l) {
            super(PreviewThread.class.getName());
            this.setPriority(1);
            this.doc = Util.checkNotNull(resultDocument);
            this.startCount = l;
        }

        @Override
        public final void run() {
            DelayedOverlay.Hider hider = PreviewPanel.this.delayedOverlay.show();
            try {
                this.doRun(hider);
            }
            catch (ParseException parseException) {
                PreviewPanel.this.setError(parseException.getMessage(), this.startCount);
            }
            catch (FileNotFoundException fileNotFoundException) {
                PreviewPanel.this.setError(fileNotFoundException.getMessage(), this.startCount);
            }
            catch (CheckedOutOfMemoryError checkedOutOfMemoryError) {
                UtilGui.showOutOfMemoryMessage((Control)PreviewPanel.this, checkedOutOfMemoryError);
            }
            finally {
                hider.hide();
            }
        }

        protected abstract void doRun(DelayedOverlay.Hider var1) throws ParseException, FileNotFoundException, CheckedOutOfMemoryError;
    }
}

