/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.util.Util;

public enum DocumentType {
    FILE(false),
    OUTLOOK(true);

    private final String prefix = this.name().toLowerCase() + "://";
    private final boolean isEmail;

    private DocumentType(boolean bl) {
        this.isEmail = bl;
    }

    public String createUniqueId(Path path) {
        return this.prefix + path.getPath();
    }

    public static Path extractPath(String string) {
        Util.checkNotNull(string);
        for (DocumentType documentType : DocumentType.values()) {
            if (!string.startsWith(documentType.prefix)) continue;
            return new Path(string.substring(documentType.prefix.length()));
        }
        throw new IllegalArgumentException();
    }

    public static boolean isEmailType(String string) {
        Util.checkNotNull(string);
        for (DocumentType documentType : DocumentType.values()) {
            if (!documentType.isEmail || !string.startsWith(documentType.prefix)) continue;
            return true;
        }
        return false;
    }
}

