/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import net.contentobjects.jnotify.JNotify;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.gui.ManualLocator;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.SimpleJNotifyListener;
import net.sourceforge.docfetcher.model.TreeIndex;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.Task;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.index.file.FileFolder;
import net.sourceforge.docfetcher.model.index.file.FileIndex;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.concurrent.DelayedExecutor;

public final class FolderWatcher {
    public final Event<String> evtWatchLimitError = new Event();
    private final Map<LuceneIndex, Boolean> watchQueue = Maps.newLinkedHashMap();
    private final Map<LuceneIndex, Integer> watchIdMap = Maps.newHashMap();
    private final Lock writeLock;
    private final Condition needsUpdate;
    private final Thread thread;
    private volatile boolean shutdown = false;
    private final IndexRegistry indexRegistry;
    private Event.Listener<LuceneIndex> addedListener;
    private Event.Listener<List<LuceneIndex>> removedListener;
    private Event.Listener<LuceneIndex> watchChangedListener;

    public FolderWatcher(IndexRegistry indexRegistry) {
        this.indexRegistry = Util.checkNotNull(indexRegistry);
        this.writeLock = indexRegistry.getWriteLock();
        this.needsUpdate = this.writeLock.newCondition();
        this.initListeners();
        this.thread = new Thread(FolderWatcher.class.getName()){

            @Override
            public void run() {
                try {
                    while (true) {
                        FolderWatcher.this.threadLoop();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        this.thread.start();
    }

    private void initListeners() {
        if (this.thread != null) {
            throw new IllegalStateException();
        }
        this.addedListener = new Event.Listener<LuceneIndex>(){

            @Override
            public void update(LuceneIndex luceneIndex) {
                FolderWatcher.this.writeLock.lock();
                try {
                    if (luceneIndex.isWatchFolders()) {
                        FolderWatcher.this.watchQueue.put(luceneIndex, true);
                        FolderWatcher.this.needsUpdate.signal();
                    }
                }
                finally {
                    FolderWatcher.this.writeLock.unlock();
                }
            }
        };
        this.removedListener = new Event.Listener<List<LuceneIndex>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(List<LuceneIndex> list) {
                FolderWatcher.this.writeLock.lock();
                try {
                    boolean bl = false;
                    for (LuceneIndex luceneIndex : list) {
                        if (!luceneIndex.isWatchFolders()) continue;
                        FolderWatcher.this.watchQueue.put(luceneIndex, false);
                        bl = true;
                    }
                    if (bl) {
                        FolderWatcher.this.needsUpdate.signal();
                    }
                }
                finally {
                    FolderWatcher.this.writeLock.unlock();
                }
            }
        };
        this.writeLock.lock();
        try {
            this.indexRegistry.addListeners(new IndexRegistry.ExistingIndexesHandler(){

                @Override
                public void handleExistingIndexes(List<LuceneIndex> list) {
                    for (LuceneIndex luceneIndex : list) {
                        if (!luceneIndex.isWatchFolders()) continue;
                        FolderWatcher.this.watchQueue.put(luceneIndex, true);
                    }
                }
            }, this.addedListener, this.removedListener);
        }
        finally {
            this.writeLock.unlock();
        }
        this.watchChangedListener = new Event.Listener<LuceneIndex>(){

            @Override
            public void update(LuceneIndex luceneIndex) {
                FolderWatcher.this.writeLock.lock();
                try {
                    FolderWatcher.this.watchQueue.put(luceneIndex, luceneIndex.isWatchFolders());
                    FolderWatcher.this.needsUpdate.signal();
                }
                finally {
                    FolderWatcher.this.writeLock.unlock();
                }
            }
        };
        LuceneIndex.evtWatchFoldersChanged.add(this.watchChangedListener);
    }

    private void threadLoop() throws InterruptedException {
        ImmutableMap immutableMap;
        this.writeLock.lock();
        try {
            while (this.watchQueue.isEmpty() && !this.shutdown) {
                this.needsUpdate.await();
            }
            immutableMap = ImmutableMap.copyOf(this.watchQueue);
            this.watchQueue.clear();
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.shutdown) {
            for (Integer n : this.watchIdMap.values()) {
                try {
                    JNotify.removeWatch((int)n);
                }
                catch (Exception exception) {
                    Util.printErr(exception);
                }
            }
            this.watchIdMap.clear();
            LuceneIndex.evtWatchFoldersChanged.remove(this.watchChangedListener);
            throw new InterruptedException();
        }
        for (LuceneIndex luceneIndex : immutableMap.keySet()) {
            Comparable<Integer> comparable;
            File file = luceneIndex.getCanonicalRootFile();
            if (((Boolean)immutableMap.get(luceneIndex)).booleanValue()) {
                if (this.watchIdMap.containsKey(luceneIndex) || !file.exists()) continue;
                comparable = file.isFile() && !Util.IS_LINUX ? Util.getParentFile(file) : file;
                JNotifyListenerImpl jNotifyListenerImpl = new JNotifyListenerImpl(luceneIndex);
                try {
                    int n = jNotifyListenerImpl.addWatch((File)comparable);
                    this.watchIdMap.put(luceneIndex, n);
                }
                catch (Throwable throwable) {
                    String string = ManualLocator.getManualSubpageUrl("Watch_Limit.html");
                    if (string == null) {
                        string = "???";
                    }
                    String string2 = Msg.install_watch_failed.format(luceneIndex.getDisplayName(), string, throwable.getMessage());
                    this.evtWatchLimitError.fire(string2);
                }
                continue;
            }
            comparable = this.watchIdMap.remove(luceneIndex);
            if (comparable == null || !file.exists()) continue;
            try {
                JNotify.removeWatch((int)((Integer)comparable));
            }
            catch (Exception exception) {
                Util.printErr(exception);
            }
        }
    }

    public void shutdown() {
        this.writeLock.lock();
        try {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.indexRegistry.removeListeners(this.addedListener, this.removedListener);
            this.needsUpdate.signal();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private final class JNotifyListenerImpl
    extends SimpleJNotifyListener {
        private final LuceneIndex watchedIndex;
        private final DelayedExecutor delayedExecutor = new DelayedExecutor(1000L);

        private JNotifyListenerImpl(LuceneIndex luceneIndex) {
            this.watchedIndex = Util.checkNotNull(luceneIndex);
        }

        @Override
        protected void handleEvent(File file, SimpleJNotifyListener.EventType eventType) {
            if (!this.accept(file, eventType)) {
                return;
            }
            this.delayedExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    FolderWatcher.this.indexRegistry.getQueue().addTask(JNotifyListenerImpl.this.watchedIndex, Task.IndexAction.UPDATE);
                }
            });
        }

        private boolean accept(File file, SimpleJNotifyListener.EventType eventType) {
            Serializable serializable;
            boolean bl;
            String string = file.getName();
            boolean bl2 = file.isFile();
            boolean bl3 = bl = eventType == SimpleJNotifyListener.EventType.DELETED;
            if (bl) assert (!bl2);
            if (Util.contains(FolderWatcher.this.indexRegistry.getIndexParentDir(), file)) {
                return false;
            }
            if (file.equals(this.watchedIndex.getCanonicalRootFile())) {
                return true;
            }
            if (string.startsWith("~$")) {
                return false;
            }
            if (string.startsWith(".~")) {
                return false;
            }
            IndexingConfig indexingConfig = this.watchedIndex.getConfig();
            Path path = indexingConfig.getStorablePath(file);
            boolean bl4 = false;
            Object object = indexingConfig.getPatternActions().iterator();
            block4: while (object.hasNext()) {
                serializable = object.next();
                switch (serializable.getAction()) {
                    case EXCLUDE: {
                        if (bl || !serializable.matches(string, path, bl2)) continue block4;
                        return false;
                    }
                    case DETECT_MIME: {
                        if (!serializable.matches(string, path, bl2)) continue block4;
                        bl4 = true;
                        break block4;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (bl2 && !indexingConfig.isArchive(string) && !bl4 && !ParseService.canParseByName(indexingConfig, string)) {
                return false;
            }
            return eventType != SimpleJNotifyListener.EventType.MODIFIED || !(this.watchedIndex instanceof FileIndex) || !this.sameLastModified((TreeNode)(serializable = ((FileFolder)((TreeIndex)(object = (FileIndex)this.watchedIndex)).getRootFolder()).findTreeNode(path)), file);
        }

        private boolean sameLastModified(TreeNode treeNode, File file) {
            if (treeNode == null) {
                return false;
            }
            if (treeNode instanceof FileDocument) {
                FileDocument fileDocument = (FileDocument)treeNode;
                return fileDocument.getLastModified() == file.lastModified();
            }
            if (treeNode instanceof FileFolder) {
                FileFolder fileFolder = (FileFolder)treeNode;
                return fileFolder.getLastModified().longValue() == file.lastModified();
            }
            throw new IllegalStateException();
        }
    }
}

