/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sourceforge.docfetcher.model.Folder;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.util.Util;

public final class TreeCheckState {
    private final Set<FolderWrapper> checkedSet = new HashSet<FolderWrapper>();
    private int folderCount = 0;

    void add(Folder<?, ?> folder, boolean bl) {
        Util.checkNotNull(folder);
        if (bl) {
            this.checkedSet.add(new FolderWrapper(folder));
        }
        ++this.folderCount;
    }

    void add(TreeCheckState treeCheckState) {
        Util.checkNotNull(treeCheckState);
        this.checkedSet.addAll(treeCheckState.checkedSet);
        this.folderCount += treeCheckState.folderCount;
    }

    public boolean isChecked(Path path) {
        Util.checkNotNull(path);
        if (this.checkedSet.isEmpty()) {
            return false;
        }
        if (this.folderCount == this.checkedSet.size()) {
            return true;
        }
        return this.checkedSet.contains(new PathWrapper(path));
    }

    private static final class FolderWrapper {
        private final Folder<?, ?> folder;

        private FolderWrapper(Folder<?, ?> folder) {
            this.folder = folder;
        }

        public boolean equals(Object object) {
            if (object instanceof FolderWrapper) {
                FolderWrapper folderWrapper = (FolderWrapper)object;
                return this.folder.equals(folderWrapper.folder);
            }
            String string = ((PathWrapper)object).path.getPath();
            if (string.length() != this.getPathLength(this.folder)) {
                return false;
            }
            PathReverseIterator pathReverseIterator = new PathReverseIterator(this.folder);
            StringReverseIterator stringReverseIterator = new StringReverseIterator(string);
            while (pathReverseIterator.hasNext()) {
                if (stringReverseIterator.hasNext()) {
                    if (pathReverseIterator.next() == stringReverseIterator.next()) continue;
                    return false;
                }
                return false;
            }
            return !stringReverseIterator.hasNext();
        }

        private int getPathLength(Folder<?, ?> folder) {
            Object obj;
            int n = 0;
            Folder<Object, Object> folder2 = folder;
            while ((obj = folder2.getParent()) != null) {
                n += folder2.getName().length() + 1;
                folder2 = obj;
            }
            return n += folder2.getPath().getPath().length();
        }

        public int hashCode() {
            return this.folder.getPathHashCode();
        }
    }

    private static final class PathWrapper {
        private final Path path;

        public PathWrapper(Path path) {
            this.path = path;
        }

        public boolean equals(Object object) {
            return ((FolderWrapper)object).equals(this);
        }

        public int hashCode() {
            return this.path.getPath().hashCode();
        }
    }

    private static final class StringReverseIterator {
        private String string;
        private int i = -1;

        public StringReverseIterator() {
        }

        public StringReverseIterator(String string) {
            this.setString(string);
        }

        public void setString(String string) {
            this.string = string;
            this.i = string.length() - 1;
        }

        public char next() {
            if (this.i < 0) {
                throw new NoSuchElementException();
            }
            return this.string.charAt(this.i--);
        }

        public boolean hasNext() {
            return this.i >= 0;
        }
    }

    private static final class PathReverseIterator {
        private final StringReverseIterator it = new StringReverseIterator();
        private Folder<?, ?> currentFolder;
        private State state = State.PART;

        public PathReverseIterator(Folder<?, ?> folder) {
            this.setCurrentFolder(folder);
            assert (this.it.hasNext());
        }

        public char next() {
            if (this.state == State.PART) {
                char c = this.it.next();
                if (!this.it.hasNext()) {
                    Object obj = this.currentFolder.getParent();
                    if (obj == null) {
                        this.state = State.END;
                    } else {
                        this.state = State.SEP;
                        this.setCurrentFolder((Folder<?, ?>)obj);
                    }
                }
                return c;
            }
            if (this.state == State.SEP) {
                this.state = State.PART;
                return '/';
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.state != State.END;
        }

        private void setCurrentFolder(Folder<?, ?> folder) {
            this.currentFolder = folder;
            if (folder.getParent() == null) {
                this.it.setString(folder.getPath().getPath());
            } else {
                this.it.setString(folder.getName());
            }
        }

        private static enum State {
            PART,
            SEP,
            END;

        }
    }
}

