/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.Document;
import net.sourceforge.docfetcher.model.Folder;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeCheckState;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.ViewNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAFDirectory;
import org.apache.lucene.store.RAMDirectory;

public abstract class TreeIndex<D extends Document<D, F>, F extends Folder<D, F>>
implements LuceneIndex {
    private static final long serialVersionUID = 1L;
    private final IndexingConfig config;
    private final F rootFolder;
    private final long created;
    private final Path fileIndexDirPath;
    private transient RAMDirectory ramIndexDir;
    private transient File indexParentDir;

    protected TreeIndex(File file, File file2) {
        Util.checkNotNull(file2);
        this.indexParentDir = file;
        this.config = new IndexingConfig(){

            @Override
            protected void onStoreRelativePathsChanged() {
                File file = ((Folder)TreeIndex.this.rootFolder).getPath().getCanonicalFile();
                Path path = TreeIndex.this.config.getStorablePath(file);
                ((Folder)TreeIndex.this.rootFolder).setPath(path);
            }

            @Override
            protected void onWatchFoldersChanged() {
                LuceneIndex.evtWatchFoldersChanged.fire(TreeIndex.this);
            }
        };
        file2 = Util.getCanonicalFile(file2);
        Path path = this.config.getStorablePath(file2);
        this.rootFolder = this.createRootFolder(path);
        Util.checkNotNull(this.rootFolder);
        this.created = Util.getTimestamp();
        if (file == null) {
            this.fileIndexDirPath = null;
            this.ramIndexDir = new RAMDirectory();
        } else {
            String string = this.getIndexDirName(file2) + "_" + this.created;
            File file3 = new File(file, string);
            this.fileIndexDirPath = AppUtil.isPortable() ? new Path(UtilModel.getRelativePathIfPossible(file3)) : new Path(file3);
        }
    }

    @Override
    public final long getCreated() {
        return this.created;
    }

    @Override
    public final File getCanonicalRootFile() {
        return ((Folder)this.rootFolder).getPath().getCanonicalFile();
    }

    protected abstract String getIndexDirName(File var1);

    protected abstract F createRootFolder(Path var1);

    @Override
    public final IndexingConfig getConfig() {
        return this.config;
    }

    @Override
    public final Path getIndexDirPath() {
        if (this.fileIndexDirPath == null) {
            return null;
        }
        if (IndexRegistry.indexPathOverride != null) {
            String string = new File(this.fileIndexDirPath.getPath()).getName();
            return new Path(new File(IndexRegistry.indexPathOverride, string));
        }
        return this.fileIndexDirPath;
    }

    protected final File getIndexParentDir() {
        if (this.fileIndexDirPath == null) {
            return null;
        }
        if (this.indexParentDir == null) {
            this.indexParentDir = Util.getParentFile(this.getIndexDirPath().getCanonicalFile());
        }
        return this.indexParentDir;
    }

    @Override
    public final IndexingResult update(IndexingReporter indexingReporter, Cancelable cancelable) {
        if (indexingReporter == null) {
            indexingReporter = IndexingReporter.nullReporter;
        }
        if (cancelable == null) {
            cancelable = Cancelable.nullCancelable;
        }
        if (cancelable.isCanceled()) {
            return IndexingResult.SUCCESS_UNCHANGED;
        }
        return this.doUpdate(indexingReporter, cancelable);
    }

    protected abstract IndexingResult doUpdate(IndexingReporter var1, Cancelable var2);

    @Override
    public final Directory getLuceneDir() throws IOException {
        if (this.fileIndexDirPath != null) {
            assert (this.ramIndexDir == null);
            if (Util.IS_WINDOWS) {
                return new RAFDirectory(this.getIndexDirPath().getCanonicalFile().toPath());
            }
            return FSDirectory.open((java.nio.file.Path)this.getIndexDirPath().getCanonicalFile().toPath());
        }
        if (this.ramIndexDir == null) {
            this.ramIndexDir = new RAMDirectory();
        }
        return this.ramIndexDir;
    }

    public final F getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public final String getDisplayName() {
        return ((TreeNode)this.rootFolder).getDisplayName();
    }

    @Override
    public final Iterable<ViewNode> getChildren() {
        return ((Folder)this.rootFolder).getChildren();
    }

    @Override
    public final void clear() {
        this.clear(false);
    }

    @Override
    public final void delete() {
        this.clear(true);
    }

    private void clear(boolean bl) {
        block7: {
            if (this.fileIndexDirPath != null) {
                File file = this.getIndexDirPath().getCanonicalFile();
                if (file.exists()) {
                    try {
                        if (bl) {
                            Util.deleteRecursively(file);
                            break block7;
                        }
                        Util.deleteContents(file);
                    }
                    catch (IOException iOException) {
                        Util.printErr(iOException);
                    }
                }
            } else {
                assert (this.ramIndexDir != null);
                this.ramIndexDir = new RAMDirectory();
            }
        }
        ((Folder)this.rootFolder).setLastModified(null);
        ((Folder)this.rootFolder).removeChildren();
    }

    @Override
    public final boolean isChecked() {
        return ((Folder)this.rootFolder).isChecked();
    }

    @Override
    public final void setChecked(boolean bl) {
        ((Folder)this.rootFolder).setChecked(bl);
    }

    @Override
    public final TreeCheckState getTreeCheckState() {
        return ((Folder)this.rootFolder).getTreeCheckState();
    }

    @Override
    public final boolean isIndex() {
        return true;
    }

    @Override
    public final List<String> getDocumentIds() {
        return ((Folder)this.rootFolder).getDocumentIds();
    }

    @Override
    public final boolean isWatchFolders() {
        return this.config.isWatchFolders();
    }

    @Override
    public final boolean hasErrorsDeep() {
        return ((Folder)this.rootFolder).hasErrorsDeep();
    }

    public static enum IndexingResult {
        SUCCESS_CHANGED,
        SUCCESS_UNCHANGED,
        FAILURE;

    }
}

