/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.util.Util;

public abstract class TreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private String displayName;
    private List<IndexingError> errors;

    public TreeNode(String string) {
        this(string, null);
    }

    public TreeNode(String string, String string2) {
        Util.checkNotNull(string);
        this.name = string;
        this.displayName = string2;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public final void setDisplayName(String string) {
        this.displayName = string;
    }

    public abstract Path getPath();

    public final String toString() {
        return this.getPath().toString();
    }

    public final synchronized List<IndexingError> getErrors() {
        return this.errors == null ? Collections.emptyList() : this.errors;
    }

    public final synchronized boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public final synchronized void setError(IndexingError indexingError) {
        this.errors = indexingError == null ? null : Collections.singletonList(indexingError);
    }

    public final synchronized void setErrors(List<IndexingError> list) {
        this.errors = list == null ? null : ImmutableList.copyOf(list);
    }
}

