/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import de.schlichtherle.truezip.file.TFile;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.UtilModel;
import org.junit.Assert;
import org.junit.Test;

public final class UtilModelTest {
    @Test
    public void testGetRelativePath() {
        String[] stringArray = new String[]{"/path/to/file", "/path/to/file", "/path/to/file", "", "", "", "C:", "C:\\", "C:", "/same/path", "same/path/", "../../../same/path", "/path/to/file", "/path/to/file/and/more", "and/more", "", "some/path", "some/path", "/path/to/file/and/more", "/path/to/file", "../..", "C:\\Windows\\System\\Temp\\", "C:\\Windows\\", "../..", "/path/to/one/file", "/path/to/another/file", "../../another/file", "C:\\Windows\\System", "C:\\Program Files\\DocFetcher", "../../Program Files/DocFetcher", "path/to/file", "some/thing/else", "../../../some/thing/else", "C:", "D:\\Windows\\", "../D:/Windows"};
        for (int i = 0; i < stringArray.length - 2; i += 3) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            String string3 = stringArray[i + 2];
            String string4 = UtilModel.getRelativePath(string, string2);
            Assert.assertEquals((Object)string3, (Object)string4);
        }
    }

    @Test
    public void testArchiveDetection() {
        String string = TestFiles.archive_detection.getPath();
        String[] stringArray = new String[]{"real-zip.zip", "fake-zip-is-file.zip", "fake-zip-is-directory.zip", "nested-test.zip/real-zip.zip", "nested-test.zip/fake-zip-is-file.zip", "nested-test.zip/fake-zip-is-directory.zip"};
        boolean[] blArray = new boolean[]{true, false, false, true, false, false};
        Assert.assertTrue((stringArray.length == blArray.length ? 1 : 0) != 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + "/" + stringArray[i];
            TFile tFile = new TFile(string2);
            Assert.assertTrue((boolean)tFile.exists());
            boolean bl = UtilModel.isZipArchive(tFile);
            Assert.assertEquals((Object)blArray[i], (Object)bl);
        }
    }
}

