/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import net.sourceforge.docfetcher.gui.ManualLocator;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;

public final class IndexWriterAdapter
implements Closeable {
    public static final Term idTerm = new Term(Fields.UID.key());
    private static final String EXTERNAL_MODIFICATION_MSG = "Index corrupted by external process (e.g., antivirus software). Please exclude the index folder from antivirus scans, then rebuild the index.";
    private IndexWriter writer;

    private static String getIndexCorruptionMsg() {
        String string = ManualLocator.getManualSubpageUrl("Memory_Limit.html");
        if (string == null) {
            return "Index corruption detected. This is usually caused by running out of memory during a previous indexing operation.";
        }
        return "Index corruption detected. This is usually caused by running out of memory during a previous indexing operation. Please see the following file for instructions on increasing the memory limit, then rebuild the index.\n" + string;
    }

    public IndexWriterAdapter(Directory directory) throws IOException {
        try {
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(IndexRegistry.getAnalyzer());
            this.writer = new IndexWriter(directory, indexWriterConfig);
        }
        catch (CorruptIndexException corruptIndexException) {
            throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), corruptIndexException);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), noSuchFileException);
        }
    }

    public void add(Document document) throws IOException, CheckedOutOfMemoryError {
        try {
            this.writer.addDocument((Iterable)document);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.reopenWriterAndThrow(outOfMemoryError);
        }
        catch (CorruptIndexException corruptIndexException) {
            throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), corruptIndexException);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), noSuchFileException);
        }
        catch (AlreadyClosedException alreadyClosedException) {
            Throwable throwable = alreadyClosedException.getCause();
            if (throwable instanceof CorruptIndexException || throwable instanceof NoSuchFileException) {
                throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), alreadyClosedException);
            }
            throw new IOException(EXTERNAL_MODIFICATION_MSG, alreadyClosedException);
        }
        catch (IllegalStateException illegalStateException) {
            if (illegalStateException.getMessage().contains("OutOfMemoryError")) {
                this.reopenWriterAndThrow(illegalStateException);
            }
            throw illegalStateException;
        }
    }

    public void update(String string, Document document) throws IOException, CheckedOutOfMemoryError {
        try {
            this.writer.updateDocument(new Term(idTerm.field(), string), (Iterable)document);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.reopenWriterAndThrow(outOfMemoryError);
        }
        catch (CorruptIndexException corruptIndexException) {
            throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), corruptIndexException);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), noSuchFileException);
        }
        catch (AlreadyClosedException alreadyClosedException) {
            Throwable throwable = alreadyClosedException.getCause();
            if (throwable instanceof CorruptIndexException || throwable instanceof NoSuchFileException) {
                throw new IOException(IndexWriterAdapter.getIndexCorruptionMsg(), alreadyClosedException);
            }
            throw new IOException(EXTERNAL_MODIFICATION_MSG, alreadyClosedException);
        }
        catch (IllegalStateException illegalStateException) {
            if (illegalStateException.getMessage().contains("OutOfMemoryError")) {
                this.reopenWriterAndThrow(illegalStateException);
            }
            throw illegalStateException;
        }
    }

    private void reopenWriterAndThrow(Throwable throwable) throws IOException, CheckedOutOfMemoryError {
        Directory directory = this.writer.getDirectory();
        Closeables.closeQuietly((Closeable)this.writer);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(IndexRegistry.getAnalyzer());
        this.writer = new IndexWriter(directory, indexWriterConfig);
        throw new CheckedOutOfMemoryError(throwable);
    }

    public void delete(String string) throws IOException {
        this.writer.deleteDocuments(new Term[]{new Term(idTerm.field(), string)});
    }

    @Override
    public void close() throws IOException {
        block2: {
            try {
                this.writer.close();
            }
            catch (AssertionError assertionError) {
                String string = ((Throwable)((Object)assertionError)).getMessage();
                if (string != null && string.contains("fsyncing a directory")) break block2;
                throw assertionError;
            }
        }
    }
}

