/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.util.Util;

public final class PatternAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String regex;
    private transient Pattern pattern;
    private MatchTarget target = MatchTarget.FILENAME;
    private MatchAction action = MatchAction.EXCLUDE;

    public PatternAction() {
        this("regex");
    }

    public PatternAction(String string) {
        this.regex = string;
    }

    public PatternAction(String string, MatchTarget matchTarget, MatchAction matchAction) {
        this.regex = string;
        this.target = matchTarget;
        this.action = matchAction;
    }

    public boolean matches(String string, Path path, boolean bl) {
        if (!bl) {
            return false;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex);
        }
        switch (this.target.ordinal()) {
            case 0: {
                return this.pattern.matcher(string).matches();
            }
            case 1: {
                return this.pattern.matcher(path.getPath()).matches();
            }
        }
        throw new IllegalStateException();
    }

    public void setRegex(String string) {
        Util.checkNotNull(string);
        if (this.regex.equals(string)) {
            return;
        }
        this.regex = string;
        this.pattern = null;
    }

    public boolean validateRegex() {
        if (this.pattern != null) {
            return true;
        }
        try {
            this.pattern = Pattern.compile(this.regex);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public void setTarget(MatchTarget matchTarget) {
        this.target = Util.checkNotNull(matchTarget);
    }

    public MatchTarget getTarget() {
        return this.target;
    }

    public void setAction(MatchAction matchAction) {
        this.action = Util.checkNotNull(matchAction);
    }

    public MatchAction getAction() {
        return this.action;
    }

    public static enum MatchTarget {
        FILENAME,
        PATH;

    }

    public static enum MatchAction {
        EXCLUDE(Msg.exclude.get()),
        DETECT_MIME(Msg.detect_mime_type.get());

        public final String displayName;

        private MatchAction(String string2) {
            this.displayName = string2;
        }
    }
}

