/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import com.google.common.base.Objects;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.PendingDeletion;
import net.sourceforge.docfetcher.model.TreeIndex;
import net.sourceforge.docfetcher.model.index.DelegatingReporter;
import net.sourceforge.docfetcher.model.index.IndexingQueue;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;

public final class Task {
    public final Event<Boolean> evtFinished = new Event();
    private final IndexingQueue queue;
    private final LuceneIndex index;
    private final IndexAction indexAction;
    private volatile TaskState state;
    private volatile PendingDeletion deletion;
    private final DelegatingReporter reporter;
    volatile CancelAction cancelAction;

    Task(IndexingQueue indexingQueue, LuceneIndex luceneIndex, IndexAction indexAction) {
        Util.checkNotNull(indexingQueue, luceneIndex, (Object)indexAction);
        this.queue = indexingQueue;
        this.index = luceneIndex;
        this.indexAction = indexAction;
        this.state = this.is(IndexAction.UPDATE) ? TaskState.READY : TaskState.NOT_READY;
        this.reporter = new DelegatingReporter(indexingQueue.reporterCapacity);
    }

    public void remove(CancelHandler cancelHandler) {
        this.queue.remove(this, cancelHandler);
    }

    public void setReady() {
        this.queue.setReady(this);
    }

    TreeIndex.IndexingResult update() {
        return this.index.update(this.reporter, new Cancelable(){

            @Override
            public boolean isCanceled() {
                return Task.this.cancelAction != null;
            }
        });
    }

    public LuceneIndex getLuceneIndex() {
        return this.index;
    }

    public void attachReporter(IndexingReporter indexingReporter, DelegatingReporter.ExistingMessagesHandler existingMessagesHandler) {
        this.reporter.attachDelegate(indexingReporter, existingMessagesHandler);
    }

    public void detachReporter(IndexingReporter indexingReporter) {
        this.reporter.detachDelegate(indexingReporter);
    }

    public boolean is(IndexAction indexAction) {
        return Objects.equal((Object)((Object)this.indexAction), (Object)((Object)indexAction));
    }

    boolean is(CancelAction cancelAction) {
        this.queue.readLock.lock();
        try {
            boolean bl = Objects.equal((Object)((Object)this.cancelAction), (Object)((Object)cancelAction));
            return bl;
        }
        finally {
            this.queue.readLock.unlock();
        }
    }

    public boolean is(TaskState taskState) {
        this.queue.readLock.lock();
        try {
            boolean bl = Objects.equal((Object)((Object)this.state), (Object)((Object)taskState));
            return bl;
        }
        finally {
            this.queue.readLock.unlock();
        }
    }

    void set(TaskState taskState) {
        this.queue.writeLock.lock();
        try {
            this.state = Util.checkNotNull(taskState);
        }
        finally {
            this.queue.writeLock.unlock();
        }
    }

    void setDeletion(PendingDeletion pendingDeletion) {
        this.queue.writeLock.lock();
        try {
            this.deletion = Util.checkNotNull(pendingDeletion);
        }
        finally {
            this.queue.writeLock.unlock();
        }
    }

    PendingDeletion getDeletion() {
        this.queue.readLock.lock();
        try {
            PendingDeletion pendingDeletion = this.deletion;
            return pendingDeletion;
        }
        finally {
            this.queue.readLock.unlock();
        }
    }

    public String toString() {
        return String.format("Task [%s %s] %s", this.indexAction.name(), this.state.name(), this.index.getCanonicalRootFile().toString());
    }

    public static enum IndexAction {
        CREATE,
        UPDATE,
        REBUILD;

    }

    public static enum TaskState {
        NOT_READY,
        READY,
        INDEXING,
        FINISHED;

    }

    public static interface CancelHandler {
        public CancelAction cancel();
    }

    public static enum CancelAction {
        DISCARD,
        KEEP;

    }
}

