/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import java.io.IOException;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.file.AppendingDocWriter;
import net.sourceforge.docfetcher.model.index.file.FileContext;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import org.apache.lucene.document.Document;

final class AppendingContext
extends FileContext {
    private final FileContext outerContext;

    public AppendingContext(FileContext fileContext) {
        super(fileContext.getConfig(), fileContext.getZipDetector(), new AppendingDocWriter(), fileContext.getReporter(), fileContext.getOriginalPath(), fileContext.getStopper(), fileContext.getFileCount(), fileContext.getIndexParentDir());
        this.outerContext = fileContext;
    }

    @Override
    public void info(IndexingInfo.InfoType infoType, TreeNode treeNode) {
        if (this.getReporter() != IndexingReporter.nullReporter) {
            super.info(infoType, treeNode);
        }
    }

    public boolean appendToOuter(FileDocument fileDocument, boolean bl) throws IndexingException {
        AppendingDocWriter appendingDocWriter = (AppendingDocWriter)this.getWriter();
        Document document = appendingDocWriter.getLuceneDoc();
        try {
            this.outerContext.getWriter().write(fileDocument, document, bl);
            return true;
        }
        catch (IOException iOException) {
            throw new IndexingException(iOException);
        }
        catch (CheckedOutOfMemoryError checkedOutOfMemoryError) {
            this.outerContext.fail(IndexingError.ErrorType.OUT_OF_MEMORY, fileDocument, checkedOutOfMemoryError);
            return false;
        }
    }
}

