/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.IInStream;
import com.google.common.base.Predicate;
import com.google.common.io.Closeables;
import com.google.common.io.NullOutputStream;
import de.innosystec.unrar.Archive;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.rarfile.FileHeader;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.FileResource;
import net.sourceforge.docfetcher.model.HotColdFileCache;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.index.DiskSpaceException;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.file.ArchiveEncryptedException;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.index.file.FileFolder;
import net.sourceforge.docfetcher.model.index.file.HtmlFileWalker;
import net.sourceforge.docfetcher.model.index.file.RarTree;
import net.sourceforge.docfetcher.model.index.file.SevenZipInputStream;
import net.sourceforge.docfetcher.model.index.file.SevenZipTree;
import net.sourceforge.docfetcher.model.index.file.SevenZipUnpacker;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveTree;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.Util;

public final class FileFactory {
    private final HotColdFileCache unpackCache;

    public FileFactory(HotColdFileCache hotColdFileCache) {
        this.unpackCache = Util.checkNotNull(hotColdFileCache);
    }

    public FileResource createFile(IndexingConfig indexingConfig, Path path) throws ParseException, FileNotFoundException {
        Util.checkNotNull(indexingConfig, path);
        try {
            Path.PathParts pathParts = path.splitAtExistingFile();
            File file = pathParts.getLeft().getCanonicalFile();
            if (pathParts.getRight().isEmpty()) {
                return new HotColdFileCache.PermanentFileResource(file);
            }
            final FileResource[] fileResourceArray = new FileResource[1];
            Path.PathParts pathParts2 = path.splitFromRight(new Predicate<Path>(){

                public boolean apply(Path path) {
                    fileResourceArray[0] = FileFactory.this.unpackCache.get(path);
                    return fileResourceArray[0] != null;
                }
            });
            if (pathParts2 == null) {
                HotColdFileCache.PermanentFileResource permanentFileResource = new HotColdFileCache.PermanentFileResource(file);
                Path path2 = pathParts.getLeft();
                String string = pathParts.getRight();
                return this.unpackFromArchive(indexingConfig, path2, permanentFileResource, string);
            }
            if (pathParts2.getRight().isEmpty()) {
                return fileResourceArray[0];
            }
            Path path3 = pathParts2.getLeft();
            String string = pathParts2.getRight();
            return this.unpackFromArchive(indexingConfig, path3, fileResourceArray[0], string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = Msg.file_not_found.get() + " " + path.getPath();
            throw new FileNotFoundException(string);
        }
        catch (ArchiveEncryptedException archiveEncryptedException) {
            String string = Msg.archive_encrypted.get();
            throw new ParseException(string, archiveEncryptedException);
        }
        catch (DiskSpaceException diskSpaceException) {
            throw new ParseException(diskSpaceException);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    private FileResource unpackFromArchive(IndexingConfig indexingConfig, Path path, FileResource fileResource, String string) throws ArchiveEncryptedException, DiskSpaceException, FileNotFoundException, IOException {
        File file = fileResource.getFile();
        assert (!(file instanceof TFile));
        assert (file.isFile());
        TFile tFile = new TFile(file, indexingConfig.createZipDetector());
        if (tFile.isDirectory()) {
            return this.unpackFromZipArchive(indexingConfig, path, fileResource, tFile, string);
        }
        return this.unpackFromSolidArchive(indexingConfig, path, fileResource, string);
    }

    private FileResource unpackFromSolidArchive(IndexingConfig indexingConfig, Path path, FileResource fileResource, String string) throws ArchiveEncryptedException, DiskSpaceException, FileNotFoundException, IOException {
        SolidArchiveTree solidArchiveTree;
        File file = fileResource.getFile();
        String string2 = Util.splitFilename(file)[1];
        if (!Util.hasExtension(string, indexingConfig.getHtmlExtensions())) {
            if (string2.equals("exe") || string2.equals("7z")) {
                return this.unpackFrom7zArchive(indexingConfig, path, fileResource, string);
            }
            if (string2.equals("rar")) {
                return this.unpackFromRarArchive(indexingConfig, path, fileResource, string);
            }
            throw new FileNotFoundException();
        }
        if (string2.equals("exe") || string2.equals("7z")) {
            solidArchiveTree = new SevenZipTree(file, indexingConfig, true, path, null);
        } else if (string2.equals("rar")) {
            solidArchiveTree = new RarTree(file, indexingConfig, true, path, null);
        } else {
            throw new FileNotFoundException();
        }
        return this.unpackFromSolidArchive(indexingConfig, fileResource, solidArchiveTree, string);
    }

    private FileResource unpackFromZipArchive(final IndexingConfig indexingConfig, final Path path, final FileResource fileResource, final TFile tFile, final String string) throws ArchiveEncryptedException, DiskSpaceException, FileNotFoundException, IOException {
        assert (tFile.isArchive());
        assert (tFile.getEnclArchive() == null);
        final FileResource[] fileResourceArray = new FileResource[1];
        final Exception[] exceptionArray = new Exception[1];
        new HtmlFileWalker((File)tFile, indexingConfig){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void handleFile(File file) {
                block6: {
                    String string3 = FileFactory.getRelativePath((File)tFile, file);
                    try {
                        File file2;
                        if (string3.equals(string)) {
                            File file3 = FileFactory.maybeUnpackZipEntry(indexingConfig, file);
                            Path path2 = path.createSubPath(string3);
                            fileResourceArray[0] = FileFactory.this.unpackCache.putIfAbsent(path2, file3);
                            this.stop();
                            break block6;
                        }
                        if (!string.startsWith(string3 + "/") || !indexingConfig.isSolidArchive(file.getName())) break block6;
                        try {
                            file2 = FileFactory.maybeUnpackZipEntry(indexingConfig, file);
                            TVFS.umount((TFile)tFile);
                        }
                        finally {
                            fileResource.dispose();
                        }
                        Path path3 = path.createSubPath(string3);
                        FileResource fileResource2 = FileFactory.this.unpackCache.putIfAbsent(path3, file2);
                        String string2 = string.substring(string3.length() + 1);
                        fileResourceArray[0] = FileFactory.this.unpackFromSolidArchive(indexingConfig, path3, fileResource2, string2);
                        this.stop();
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                        this.stop();
                    }
                }
            }

            @Override
            protected void handleHtmlPair(File file, File file2) {
                String string2 = FileFactory.getRelativePath((File)tFile, file);
                if (!string2.equals(string)) {
                    return;
                }
                Path path2 = path.createSubPath(string2);
                try {
                    if (file2 == null) {
                        File file3 = FileFactory.maybeUnpackZipEntry(indexingConfig, file);
                        fileResourceArray[0] = FileFactory.this.unpackCache.putIfAbsent(path2, file3);
                    } else {
                        TFile tFile3 = (TFile)file;
                        TFile tFile2 = (TFile)file2;
                        File file4 = Util.createTempDir();
                        File file5 = new File(file4, tFile3.getName());
                        File file6 = new File(file4, tFile2.getName());
                        tFile3.cp(file5);
                        tFile2.cp_r(file6);
                        fileResourceArray[0] = FileFactory.this.unpackCache.putIfAbsent(path2, file5, file4);
                    }
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
                this.stop();
            }

            @Override
            protected void handleDir(File file) {
            }

            @Override
            protected boolean skip(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                String string2 = FileFactory.getRelativePath((File)tFile, file);
                return !string.startsWith(string2 + "/");
            }

            @Override
            protected void runFinally() {
                try {
                    if (tFile.exists()) {
                        TVFS.umount((TFile)tFile);
                    }
                }
                catch (FsSyncException fsSyncException) {
                    exceptionArray[0] = fsSyncException;
                }
                finally {
                    fileResource.dispose();
                }
            }
        }.runSilently();
        FileFactory.maybeThrow(exceptionArray, DiskSpaceException.class);
        FileFactory.maybeThrow(exceptionArray, IOException.class);
        FileFactory.maybeThrow(exceptionArray, FileNotFoundException.class);
        FileFactory.maybeThrow(exceptionArray, ArchiveEncryptedException.class);
        assert (exceptionArray[0] == null) : exceptionArray[0].toString();
        if (fileResourceArray[0] == null) {
            throw new FileNotFoundException();
        }
        return fileResourceArray[0];
    }

    private static <T extends Throwable> void maybeThrow(Exception[] exceptionArray, Class<T> clazz) throws T {
        assert (exceptionArray.length == 1);
        if (clazz.isInstance(exceptionArray[0])) {
            throw (Throwable)clazz.cast(exceptionArray[0]);
        }
    }

    private static String getRelativePath(File file, File file2) {
        String string = UtilModel.getRelativePath(file, file2);
        assert (FileFactory.noTrailingSlash(string));
        return string;
    }

    private static File maybeUnpackZipEntry(IndexingConfig indexingConfig, File file) throws DiskSpaceException, IOException {
        try {
            File file2 = UtilModel.maybeUnpackZipEntry(indexingConfig, file);
            assert (file2 != null);
            return file2;
        }
        catch (IndexingException indexingException) {
            throw indexingException.getIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileResource unpackFrom7zArchive(IndexingConfig indexingConfig, Path path, FileResource fileResource, String string) throws ArchiveEncryptedException, DiskSpaceException, FileNotFoundException, IOException {
        assert (FileFactory.noTrailingSlash(string));
        Handler handler = new Handler();
        SevenZipInputStream sevenZipInputStream = new SevenZipInputStream(fileResource.getFile());
        if (handler.Open((IInStream)sevenZipInputStream) != 0) {
            throw new IOException();
        }
        try {
            for (int i = 0; i < handler.size(); ++i) {
                File file;
                SevenZipEntry sevenZipEntry = handler.getEntry(i);
                if (sevenZipEntry.isDirectory()) continue;
                String string2 = sevenZipEntry.getName();
                assert (!string2.contains("\\"));
                assert (FileFactory.noTrailingSlash(string2));
                if (string.equals(string2)) {
                    File file2 = FileFactory.unpack7zEntry(indexingConfig, (IInArchive)handler, string2, i);
                    Path path2 = path.createSubPath(string2);
                    FileResource fileResource2 = this.unpackCache.putIfAbsent(path2, file2);
                    return fileResource2;
                }
                if (!string.startsWith(string2 + "/") || !indexingConfig.isArchive(string2)) continue;
                try {
                    file = FileFactory.unpack7zEntry(indexingConfig, (IInArchive)handler, string2, i);
                }
                finally {
                    fileResource.dispose();
                }
                Path path3 = path.createSubPath(string2);
                String string3 = string.substring(string2.length() + 1);
                FileResource fileResource3 = this.unpackCache.putIfAbsent(path3, file);
                FileResource fileResource4 = this.unpackFromArchive(indexingConfig, path3, fileResource3, string3);
                return fileResource4;
            }
        }
        finally {
            handler.close();
            fileResource.dispose();
        }
        throw new FileNotFoundException();
    }

    private static File unpack7zEntry(final IndexingConfig indexingConfig, IInArchive iInArchive, final String string, int n) throws IOException {
        return (File)new SevenZipUnpacker<File>(iInArchive){
            private File unpackedFile;

            @Override
            public File getOutputFile(int n) throws IOException {
                String string2 = FileFactory.getLastPathPart(string);
                try {
                    this.unpackedFile = indexingConfig.createDerivedTempFile(string2);
                    return this.unpackedFile;
                }
                catch (IndexingException indexingException) {
                    throw indexingException.getIOException();
                }
            }

            @Override
            public File getUnpackResult() {
                return this.unpackedFile;
            }
        }.unpack(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileResource unpackFromRarArchive(IndexingConfig var1_1, Path var2_2, FileResource var3_3, String var4_4) throws ArchiveEncryptedException, DiskSpaceException, FileNotFoundException, IOException {
        block19: {
            block18: {
                var5_5 = null;
                try {
                    var6_6 = var3_3.getFile();
                    var5_5 = new Archive(var6_6);
                    if (var5_5.isEncrypted()) {
                        throw new ArchiveEncryptedException(var6_6, var2_2.getPath());
                    }
                    var7_8 = var5_5.getFileHeaders();
                    var8_9 = false;
                    for (Object var10_12 : var7_8) {
                        if (!var10_12.isSolid()) continue;
                        var8_9 = true;
                        break;
                    }
                    if (var8_9) {
                        var9_11 = false;
                        var10_12 = var7_8.iterator();
                        while (var10_12.hasNext()) {
                            var11_13 = (FileHeader)var10_12.next();
                            if (var11_13.isEncrypted() || var11_13.isDirectory()) continue;
                            var12_14 = var11_13.isUnicode() != false ? var11_13.getFileNameW() : var11_13.getFileNameString();
                            var12_14 = Util.toForwardSlashes((String)var12_14);
                            if (!FileFactory.$assertionsDisabled && !FileFactory.noTrailingSlash((String)var12_14)) {
                                throw new AssertionError();
                            }
                            if (!var4_4.equals(var12_14) && (!var4_4.startsWith((String)var12_14 + "/") || !var1_1.isArchive((String)var12_14))) continue;
                            var9_11 = true;
                            break;
                        }
                        if (!var9_11) {
                            throw new FileNotFoundException();
                        }
                    }
                    var9_10 = null;
                    v0 /* !! */  = var10_12 = var8_9 != false ? new NullOutputStream() : null;
lbl30:
                    // 4 sources

                    while ((var9_10 = var5_5.nextFileHeader()) != null) {
                        if (var9_10.isEncrypted() || var9_10.isDirectory()) continue;
                        var11_13 = var9_10.isUnicode() != false ? var9_10.getFileNameW() : var9_10.getFileNameString();
                        var11_13 = Util.toForwardSlashes((String)var11_13);
                        if (!FileFactory.$assertionsDisabled && !FileFactory.noTrailingSlash((String)var11_13)) {
                            throw new AssertionError();
                        }
                        if (var4_4.equals(var11_13)) {
                            var12_14 = var2_2.createSubPath((String)var11_13);
                            var13_15 = FileFactory.unpackRarEntry(var1_1, var5_5, var9_10, var4_4);
                            var14_17 = this.unpackCache.putIfAbsent((Path)var12_14, var13_15);
                            break block18;
                        }
                        ** GOTO lbl-1000
                    }
                    break block19;
                }
                catch (RarException var6_7) {
                    try {
                        throw new IOException(var6_7);
                    }
                    catch (Throwable var17_22) {
                        Closeables.closeQuietly(var5_5);
                        var3_3.dispose();
                        throw var17_22;
                    }
                }
            }
            Closeables.closeQuietly((Closeable)var5_5);
            var3_3.dispose();
            return var14_17;
lbl-1000:
            // 1 sources

            {
                if (!var4_4.startsWith((String)var11_13 + "/") || !var1_1.isArchive((String)var11_13)) ** GOTO lbl-1000
                try {
                    var12_14 = FileFactory.unpackRarEntry(var1_1, var5_5, var9_10, (String)var11_13);
                }
                finally {
                    var3_3.dispose();
                }
                var13_16 = var2_2.createSubPath((String)var11_13);
                var14_18 = this.unpackCache.putIfAbsent(var13_16, (File)var12_14);
                var15_20 = var4_4.substring(var11_13.length() + 1);
                var16_21 = this.unpackFromArchive(var1_1, var13_16, var14_18, var15_20);
            }
            Closeables.closeQuietly((Closeable)var5_5);
            var3_3.dispose();
            return var16_21;
lbl-1000:
            // 1 sources

            {
                if (!var8_9) ** GOTO lbl30
                var5_5.extractFile(var9_10, (OutputStream)var10_12);
                ** GOTO lbl30
            }
        }
        Closeables.closeQuietly((Closeable)var5_5);
        var3_3.dispose();
        throw new FileNotFoundException();
    }

    private static File unpackRarEntry(IndexingConfig indexingConfig, Archive archive, FileHeader fileHeader, String string) throws IOException, RarException {
        File file;
        String string2 = FileFactory.getLastPathPart(string);
        FileOutputStream fileOutputStream = null;
        try {
            File file2 = indexingConfig.createDerivedTempFile(string2);
            fileOutputStream = new FileOutputStream(file2);
            archive.extractFile(fileHeader, (OutputStream)fileOutputStream);
            file = file2;
        }
        catch (IndexingException indexingException) {
            try {
                throw indexingException.getIOException();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)fileOutputStream);
        return file;
    }

    private static String getLastPathPart(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c != '/' && c != '\\') continue;
            return string.substring(i + 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileResource unpackFromSolidArchive(IndexingConfig indexingConfig, FileResource fileResource, final SolidArchiveTree<?> solidArchiveTree, final String string) throws ArchiveEncryptedException, DiskSpaceException, FileNotFoundException, IOException {
        final TreeNode[] treeNodeArray = new TreeNode[1];
        final String[] stringArray = new String[1];
        try {
            new FileFolder.FileFolderVisitor<Exception>(this, solidArchiveTree.getArchiveFolder()){

                @Override
                protected void visitFolder(FileFolder fileFolder, FileFolder fileFolder2) {
                    if (!fileFolder2.isArchive()) {
                        return;
                    }
                    String string2 = solidArchiveTree.getArchiveEntryPath(fileFolder2);
                    assert (FileFactory.noTrailingSlash(string2));
                    if (!string.startsWith(string2 + "/")) {
                        return;
                    }
                    treeNodeArray[0] = fileFolder2;
                    stringArray[0] = string.substring(string2.length() + 1);
                    this.stop();
                }

                @Override
                protected void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                    String string2 = solidArchiveTree.getArchiveEntryPath(fileDocument);
                    assert (FileFactory.noTrailingSlash(string2));
                    if (!string2.equals(string)) {
                        return;
                    }
                    treeNodeArray[0] = fileDocument;
                    this.stop();
                }
            }.runSilently();
            TreeNode treeNode = treeNodeArray[0];
            if (treeNode == null) {
                throw new FileNotFoundException();
            }
            Path path = treeNode.getPath();
            if (treeNodeArray[0] instanceof FileFolder) {
                try {
                    solidArchiveTree.unpack(treeNode);
                }
                finally {
                    fileResource.dispose();
                }
                File file = solidArchiveTree.getFile(treeNode);
                if (file == null) {
                    throw new IOException();
                }
                FileResource fileResource2 = this.unpackCache.putIfAbsent(path, file);
                FileResource fileResource3 = this.unpackFromArchive(indexingConfig, path, fileResource2, stringArray[0]);
                return fileResource3;
            }
            if (treeNodeArray[0] instanceof FileDocument) {
                FileDocument fileDocument = (FileDocument)treeNode;
                FileFolder fileFolder = fileDocument.getHtmlFolder();
                if (fileFolder == null) {
                    solidArchiveTree.unpack(treeNode);
                    File file = solidArchiveTree.getFile(treeNode);
                    FileResource fileResource4 = this.unpackCache.putIfAbsent(path, file);
                    return fileResource4;
                }
                List list = fileFolder.getDocumentsDeep();
                list.add(fileDocument);
                File file = Util.createTempDir();
                solidArchiveTree.unpack(list, file);
                File file2 = solidArchiveTree.getFile(fileDocument);
                FileResource fileResource5 = this.unpackCache.putIfAbsent(path, file2, file);
                return fileResource5;
            }
            throw new IllegalStateException();
        }
        finally {
            Closeables.closeQuietly(solidArchiveTree);
            fileResource.dispose();
        }
    }

    private static boolean noTrailingSlash(String string) {
        int n = string.length();
        if (n == 0) {
            return true;
        }
        char c = string.charAt(n - 1);
        return c != '/' && c != '\\';
    }
}

