/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

abstract class LuceneDocWriter {
    LuceneDocWriter() {
    }

    public final void add(FileDocument fileDocument, File file, ParseResult parseResult) throws IOException, CheckedOutOfMemoryError {
        Document document = this.createLuceneDoc(fileDocument, file, parseResult);
        this.write(fileDocument, document, true);
    }

    public void update(FileDocument fileDocument, File file, ParseResult parseResult) throws IOException, CheckedOutOfMemoryError {
        Document document = this.createLuceneDoc(fileDocument, file, parseResult);
        this.write(fileDocument, document, false);
    }

    private Document createLuceneDoc(FileDocument fileDocument, File file, ParseResult parseResult) {
        String string;
        CharSequence charSequence;
        Document document = new Document();
        String string2 = fileDocument.getName();
        if (this.appendMetadata()) {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            charSequence = Util.getExtension(string2);
                            try {
                                document.add((IndexableField)Fields.UID.create(fileDocument.getUniqueId()));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (illegalArgumentException.getMessage() != null && illegalArgumentException.getMessage().contains("immense term")) break block14;
                                throw illegalArgumentException;
                            }
                        }
                        document.add((IndexableField)Fields.FILENAME.create(string2));
                        try {
                            document.add((IndexableField)Fields.TYPE.create((String)charSequence));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (illegalArgumentException.getMessage() != null && illegalArgumentException.getMessage().contains("immense term")) break block15;
                            throw illegalArgumentException;
                        }
                    }
                    try {
                        document.add((IndexableField)Fields.PARSER.create(parseResult.getParserName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (illegalArgumentException.getMessage() != null && illegalArgumentException.getMessage().contains("immense term")) break block16;
                        throw illegalArgumentException;
                    }
                }
                string = parseResult.getTitle();
                if (string == null || string.trim().isEmpty()) {
                    document.add((IndexableField)Fields.TITLE.create(Util.splitFilename(string2)[0]));
                } else {
                    document.add((IndexableField)Fields.TITLE.create(string));
                }
                document.add((IndexableField)Fields.SIZE.create(file.length()));
                try {
                    document.add((IndexableField)Fields.LAST_MODIFIED.create(String.valueOf(fileDocument.getLastModified())));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage() != null && illegalArgumentException.getMessage().contains("immense term")) break block17;
                    throw illegalArgumentException;
                }
            }
            List<String> list = parseResult.getAuthors();
            if (list != null) {
                for (String string3 : list) {
                    document.add((IndexableField)Fields.AUTHOR.create(string3));
                }
            }
        }
        document.add((IndexableField)Fields.createContent(parseResult.getContent()));
        charSequence = parseResult.getMetadata();
        ((StringBuilder)charSequence).append(string2);
        string = Util.splitFilename(string2)[0];
        if (!string.equals(string2)) {
            ((StringBuilder)charSequence).append(" ");
            ((StringBuilder)charSequence).append(string);
        }
        document.add((IndexableField)Fields.createContent(charSequence));
        return document;
    }

    protected abstract boolean appendMetadata();

    public abstract void write(FileDocument var1, Document var2, boolean var3) throws IOException, CheckedOutOfMemoryError;

    public abstract void delete(String var1) throws IOException;
}

